/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailFieldsLoader
extends DataBrowserLoader {
    private Collection<DataObject> images;
    private CallHandle handle;
    private int row;
    private int column;

    public ThumbnailFieldsLoader(DataBrowser viewer, Collection<DataObject> images, int row, int column) {
        super(viewer);
        if (images == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.images = images;
        this.row = row;
        this.column = column;
    }

    @Override
    public void load() {
        long userID = DataBrowserAgent.getUserDetails().getId();
        this.handle = this.hiBrwView.loadThumbnails(this.images, 96, 96, userID, 0, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        List l = (List)fe.getPartialResult();
        if (l != null) {
            this.viewer.setThumbnailsFieldsFor(l, this.row, this.column);
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

