/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.util.ImageTableRenderer;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.OMETreeTable;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeTableModel;
import org.openmicroscopy.shoola.util.ui.treetable.renderers.NumberCellRenderer;
import pojos.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageTable
extends OMETreeTable {
    static final int NAME_COL = 0;
    static final int DATE_COL = 1;
    static final int ANNOTATED_COL = 2;
    static final String NAME = "Name";
    static final String LOGIN_NAME = "User Name";
    static final String DATE = "Acquisition Date";
    static final String ANNOTATED = "Annotated";
    static final String INSTITUTION = "Institution";
    private static Vector<String> COLUMNS = new Vector(3);
    private static Map<Integer, Class> RENDERERS;
    private static Vector<String> COLUMNS_GROUPS;
    private static Map<Integer, Class> RENDERERS_GROUPS;
    private ImageTableNode tableRoot;
    private TreeSelectionListener selectionListener;
    private ImageTableView view;
    private List<ImageTableNode> nodes;
    private DataBrowserModel model;

    private void buildTreeNode(ImageTableNode parent, List comp) {
        if (parent == null) {
            return;
        }
        if (comp == null || comp.size() == 0) {
            return;
        }
        for (Object c : comp) {
            if (!(c instanceof ImageDisplay)) continue;
            ImageDisplay display = (ImageDisplay)c;
            ImageTableNode n = new ImageTableNode(display);
            parent.insert((MutableTreeTableNode)n, parent.getChildCount());
            this.buildTreeNode(n, this.view.getSorter().sort(display.getInternalDesktop().getComponents()));
        }
    }

    private void onNodeSelection() {
        TreePath[] paths = this.getTreeSelectionModel().getSelectionPaths();
        if (paths == null) {
            return;
        }
        int n = paths.length;
        if (n == 0) {
            return;
        }
        ArrayList<ImageDisplay> nodes = new ArrayList<ImageDisplay>();
        for (int i = 0; i < n; ++i) {
            Object node = paths[i].getLastPathComponent();
            if (!(node instanceof ImageTableNode)) continue;
            nodes.add((ImageDisplay)((ImageTableNode)((Object)node)).getUserObject());
        }
        this.view.selectNodes(nodes);
    }

    private void initialize() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.nodes = new ArrayList<ImageTableNode>();
        OMETreeTableModel om = this.model.getType() == 8 ? new OMETreeTableModel(this.tableRoot, COLUMNS_GROUPS, RENDERERS_GROUPS) : new OMETreeTableModel(this.tableRoot, COLUMNS, RENDERERS);
        this.setTableModel((TreeTableModel)om);
        this.setTreeCellRenderer(new ImageTableRenderer());
        this.setAutoResizeMode(4);
        this.setDefaultRenderer(String.class, new NumberCellRenderer());
        this.setRootVisible(false);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setHorizontalScrollEnabled(true);
        this.setColumnControlVisible(true);
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ImageTable.this.onNodeSelection();
            }
        };
        this.addTreeSelectionListener(this.selectionListener);
    }

    private void visitAllNodes(ImageTableNode node, List<DataObject> objects) {
        Object ho = node.getHierarchyObject();
        if (ho instanceof DataObject) {
            Iterator<DataObject> i = objects.iterator();
            DataObject object = (DataObject)ho;
            long objectId = object.getId();
            while (i.hasNext()) {
                DataObject data = i.next();
                if (data.getId() != objectId) continue;
                this.nodes.add(node);
                break;
            }
        }
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                this.visitAllNodes((ImageTableNode)((Object)e.nextElement()), objects);
            }
        }
    }

    private void visitAllNodes(ImageTableNode node, Class type, Collection<Long> ids) {
        Object ho = node.getHierarchyObject();
        if (ho == null) {
            return;
        }
        if (ho.getClass().equals(type) && ho instanceof DataObject) {
            Iterator<Long> i = ids.iterator();
            DataObject object = (DataObject)ho;
            long objectId = object.getId();
            while (i.hasNext()) {
                Long id = i.next();
                if (id != objectId) continue;
                this.nodes.add(node);
                break;
            }
        }
        if (node.getChildCount() >= 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                this.visitAllNodes((ImageTableNode)((Object)e.nextElement()), type, ids);
            }
        }
    }

    ImageTable(ImageDisplay root, ImageTableView view, DataBrowserModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view");
        }
        if (model == null) {
            throw new IllegalArgumentException("No Model");
        }
        this.view = view;
        this.model = model;
        this.tableRoot = new ImageTableNode(root);
        Object[] comp = root.getInternalDesktop().getComponents();
        this.buildTreeNode(this.tableRoot, view.getSorter().sort(comp));
        this.initialize();
    }

    void refreshTable() {
        ImageDisplay root = (ImageDisplay)this.tableRoot.getUserObject();
        this.tableRoot = new ImageTableNode(root);
        Object[] comp = root.getInternalDesktop().getComponents();
        this.buildTreeNode(this.tableRoot, this.view.getSorter().sort(comp));
        OMETreeTableModel om = this.model.getType() == 8 ? new OMETreeTableModel(this.tableRoot, COLUMNS_GROUPS, RENDERERS_GROUPS) : new OMETreeTableModel(this.tableRoot, COLUMNS, RENDERERS);
        this.setTableModel((TreeTableModel)om);
        this.setDefaultRenderer(String.class, new NumberCellRenderer());
        this.invalidate();
        this.repaint();
    }

    void setSelectedNodes(List<DataObject> objects) {
        this.removeTreeSelectionListener(this.selectionListener);
        this.visitAllNodes(this.tableRoot, objects);
        Iterator<ImageTableNode> i = this.nodes.iterator();
        int row = 0;
        this.selectionModel.clearSelection();
        while (i.hasNext()) {
            ImageTableNode node = i.next();
            row = this.getRowForPath(node.getPath());
            this.selectionModel.addSelectionInterval(row, row);
        }
        this.nodes.clear();
        this.repaint();
        this.addTreeSelectionListener(this.selectionListener);
    }

    void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        this.removeTreeSelectionListener(this.selectionListener);
        this.visitAllNodes(this.tableRoot, type, ids);
        Iterator<ImageTableNode> i = this.nodes.iterator();
        int row = 0;
        this.selectionModel.clearSelection();
        while (i.hasNext()) {
            long id;
            ImageTableNode node = i.next();
            Object ho = node.getHierarchyObject();
            if (!ho.getClass().equals(type) || !(ho instanceof DataObject) || !ids.contains(id = ((DataObject)ho).getId())) continue;
            row = this.getRowForPath(node.getPath());
            this.selectionModel.addSelectionInterval(row, row);
        }
        this.nodes.clear();
        this.repaint();
        this.addTreeSelectionListener(this.selectionListener);
    }

    @Override
    protected void onMousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.view.showMenu(e.getPoint());
        }
    }

    @Override
    protected void onMouseReleased(MouseEvent e) {
        int count = e.getClickCount();
        if (count == 2) {
            if (this.model.getType() != 8) {
                this.view.viewSelectedNode();
            }
        } else if (e.isPopupTrigger()) {
            this.view.showMenu(e.getPoint());
        }
    }

    static {
        COLUMNS.add(NAME);
        COLUMNS.add(DATE);
        RENDERERS = new HashMap<Integer, Class>();
        RENDERERS.put(0, ImageTableNode.class);
        RENDERERS.put(1, String.class);
        COLUMNS_GROUPS = new Vector(3);
        COLUMNS_GROUPS.add(LOGIN_NAME);
        COLUMNS_GROUPS.add(NAME);
        COLUMNS_GROUPS.add(INSTITUTION);
        RENDERERS_GROUPS = new HashMap<Integer, Class>();
    }
}

