/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Color;
import java.sql.Timestamp;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

public class ImageTableNode
extends OMETreeNode {
    private IconManager icons;

    ImageTableNode(ImageDisplay refNode) {
        super(refNode);
        if (refNode == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        this.setAllowsChildren(!(refNode instanceof ImageNode));
        this.icons = IconManager.getInstance();
    }

    public Object getHierarchyObject() {
        return ((ImageDisplay)this.getUserObject()).getHierarchyObject();
    }

    public Color getHighLight() {
        return ((ImageDisplay)this.getUserObject()).getHighlight();
    }

    public Object getValueAt(int column) {
        ImageDisplay node = (ImageDisplay)this.getUserObject();
        Object ho = node.getHierarchyObject();
        switch (column) {
            case 0: {
                if (ho instanceof ExperimenterData) {
                    ExperimenterData exp = (ExperimenterData)ho;
                    return exp.getUserName();
                }
                return node.toString();
            }
            case 1: {
                if (ho instanceof ImageData) {
                    Timestamp time = EditorUtil.getAcquisitionTime((ImageData)ho);
                    if (time == null) {
                        return "--";
                    }
                    return UIUtilities.formatWDMYDate(time);
                }
                if (ho instanceof ExperimenterData) {
                    return node.toString();
                }
                return "--";
            }
            case 2: {
                if (ho instanceof ExperimenterData) {
                    ExperimenterData exp = (ExperimenterData)ho;
                    return exp.getInstitution();
                }
                if (ho instanceof DataObject && EditorUtil.isAnnotated(ho)) {
                    return this.icons.getIcon(17);
                }
                return this.icons.getIcon(18);
            }
        }
        return null;
    }
}

