/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor;

import java.io.File;
import java.util.List;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.editor.view.AutosaveRecovery;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.events.editor.CopyEvent;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.UserGroupSwitched;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.util.AgentSaveInfo;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isServerAvailable() {
        Environment env = (Environment)registry.lookup("/env");
        return env.isServerAvailable();
    }

    public static String getOmeroHome() {
        Environment env = (Environment)registry.lookup("/env");
        String omeroDir = env.getOmeroHome();
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return omeroDir;
    }

    public static String getEditorHome() {
        String editorDir = (String)registry.lookup("/services/editor/home");
        editorDir = EditorAgent.getOmeroHome() + File.separator + editorDir;
        File home = new File(editorDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return editorDir;
    }

    public static String getEditorAutosave() {
        String editorDir = (String)registry.lookup("/services/editor/autosave");
        editorDir = EditorAgent.getEditorHome() + File.separator + editorDir;
        File home = new File(editorDir);
        if (!home.exists()) {
            home.mkdir();
        }
        return editorDir;
    }

    public static Editor openLocalFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        Editor editor = EditorFactory.getEditor(file);
        if (editor != null) {
            if (editor.getState() == 1) {
                editor.setFileToEdit(null, file);
            }
            editor.activate();
        }
        return editor;
    }

    private void handleFileEdition(EditFileEvent event) {
        if (event == null) {
            return;
        }
        Boolean available = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        if (available != null && !available.booleanValue()) {
            return;
        }
        Editor editor = null;
        FileAnnotationData data = event.getFileAnnotation();
        if (data == null) {
            if (event.getFileAnnotationID() > 0L) {
                editor = EditorFactory.getEditor(event.getFileAnnotationID());
            }
        } else {
            if (data.getId() <= 0L) {
                return;
            }
            String name = data.getFileName();
            String ns = data.getNameSpace();
            if (name == null) {
                return;
            }
            if ("openmicroscopy.org/omero/editor/experiment".equals(ns) || "openmicroscopy.org/omero/editor/protocol".equals(ns) || "openmicroscopy.org/omero/import/companionFile".equals(ns) || EditorUtil.isEditorFile(name)) {
                editor = EditorFactory.getEditor(data);
            } else {
                DownloadActivityParam activity;
                ApplicationData app = new ApplicationData("");
                UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
                OriginalFile f = (OriginalFile)data.getContent();
                Environment env = (Environment)EditorAgent.getRegistry().lookup("/env");
                if (f.isLoaded()) {
                    activity = new DownloadActivityParam(f, new File(env.getOmeroFilesHome()), null);
                } else {
                    long id = data.getId();
                    String path = env.getOmeroFilesHome();
                    path = path + File.separator + name;
                    activity = new DownloadActivityParam(id, 1, new File(path), null);
                }
                activity.setApplicationData(app);
                un.notifyActivity(activity);
                return;
            }
        }
        if (editor != null) {
            editor.activate();
        }
    }

    private void handleShowEditor(ShowEditorEvent evt) {
        AutosaveRecovery autosaveRecovery = new AutosaveRecovery();
        Editor editor = null;
        if (evt == null) {
            editor = EditorFactory.getEditor();
            if (editor != null) {
                editor.activate();
            }
            autosaveRecovery.checkForRecoveredFiles();
            return;
        }
        if (evt.getParent() == null) {
            editor = EditorFactory.getEditor();
        } else {
            int editorType = 100;
            if (evt.getType() == 0) {
                editorType = 101;
            }
            editor = EditorFactory.getEditor(evt.getParent(), evt.getName(), editorType);
        }
        autosaveRecovery.checkForRecoveredFiles();
        if (editor != null) {
            editor.activate();
        }
    }

    private void handleUserGroupSwitched(UserGroupSwitched evt) {
        if (evt == null) {
            return;
        }
        EditorFactory.onGroupSwitched(evt.isSuccessful());
    }

    private void handleCopyData(CopyEvent evt) {
        EditorFactory.setCopiedData(evt.getCopiedData());
    }

    @Override
    public void activate() {
        if (!EditorAgent.isServerAvailable()) {
            this.handleShowEditor(null);
        }
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, EditFileEvent.class);
        bus.register((AgentEventListener)this, ShowEditorEvent.class);
        bus.register((AgentEventListener)this, CopyEvent.class);
        bus.register((AgentEventListener)this, UserGroupSwitched.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public AgentSaveInfo getDataToSave() {
        try {
            List<Object> instances = EditorFactory.getInstancesToSave();
            if (instances == null || instances.size() == 0) {
                return null;
            }
            return new AgentSaveInfo("Editors", instances);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void save(List<Object> instances) {
        EditorFactory.saveInstances(instances);
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof EditFileEvent) {
            this.handleFileEdition((EditFileEvent)e);
        } else if (e instanceof ShowEditorEvent) {
            this.handleShowEditor((ShowEditorEvent)e);
        } else if (e instanceof CopyEvent) {
            this.handleCopyData((CopyEvent)e);
        } else if (e instanceof UserGroupSwitched) {
            this.handleUserGroupSwitched((UserGroupSwitched)e);
        }
    }
}

