/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public abstract class EditorAction
extends AbstractAction
implements ChangeListener {
    protected Editor model;

    protected void onStateChange() {
    }

    public EditorAction(Editor model) {
        this.setEnabled(false);
        if (model == null) {
            throw new IllegalArgumentException("No Editor");
        }
        this.model = model;
        model.addChangeListener(this);
    }

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setDescription(String description) {
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(description));
    }

    protected void setIcon(int iconID) {
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(iconID));
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.model.getState()) {
            case 2: {
                this.setEnabled(false);
                break;
            }
            case 3: {
                this.setEnabled(true);
                break;
            }
            case 1: {
                this.setEnabled(true);
            }
        }
        this.onStateChange();
    }
}

