/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.ActionCmd;
import org.openmicroscopy.shoola.agents.editor.actions.SaveLocallyCmd;
import org.openmicroscopy.shoola.agents.editor.actions.SaveServerCmd;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.ui.MessageBox;

public class SaveNewCmd
implements ActionCmd {
    private Editor model;

    public SaveNewCmd(Editor model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public void execute() {
        if (EditorAgent.isServerAvailable()) {
            JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
            MessageBox msg = new MessageBox(f, "Save As...", "Would you like to save this file locally, or save it to the OMERO.server?");
            msg.setYesText("Save to Server");
            msg.setNoText("Save locally");
            msg.addCancelButton();
            int option = msg.centerMsgBox();
            if (option == 1) {
                SaveServerCmd save = new SaveServerCmd(this.model);
                save.execute();
            } else if (option == 0) {
                SaveLocallyCmd save = new SaveLocallyCmd(this.model);
                save.execute();
            }
        } else {
            SaveLocallyCmd save = new SaveLocallyCmd(this.model);
            save.execute();
        }
    }
}

