/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.ActionCmd;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.InputDialog;

class SaveServerCmd
implements ActionCmd {
    private Editor model;

    SaveServerCmd(Editor model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    public void execute() {
        JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
        InputDialog dialog = new InputDialog(f, "Save to server: Enter file name", "");
        String text = this.model.getEditorTitle();
        if (this.model.isExperiment()) {
            text = text + "_exp";
        }
        dialog.setText(text);
        int option = dialog.centerMsgBox();
        if (option == 1) {
            String fileName = dialog.getText();
            if (fileName == null || fileName.length() == 0) {
                this.execute();
            } else {
                EditorFileFilter editor = new EditorFileFilter();
                if (!editor.accept(fileName)) {
                    fileName = fileName + "." + editor.getExtension();
                }
                this.model.save(fileName, 1);
            }
        }
    }
}

