/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.model.ExperimentInfo;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;

class BrowserModel {
    private boolean fileLocked;
    private int savedState;
    private long id;
    protected Browser component;
    private TreeModel treeModel;
    private int type;

    BrowserModel(int state, int type) {
        this.setEditingMode(state);
        this.savedState = 3;
        this.type = type;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    TreeModel getTreeModel() {
        return this.treeModel;
    }

    void setTreeModel(TreeModel model) {
        this.treeModel = model;
        if (this.isModelExperiment()) {
            this.setEditingMode(2);
        }
    }

    int getEditingMode() {
        if (this.isModelExperiment()) {
            if ("true".equals(ExperimentInfo.getExpInfo(this.treeModel).getAttribute("editProtocol"))) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    int getSavedState() {
        return this.savedState;
    }

    void setEdited(boolean edited) {
        this.savedState = edited ? 4 : 3;
        if (!edited) {
            DefaultTreeModel d = (DefaultTreeModel)this.treeModel;
            d.nodeChanged((TreeNode)d.getRoot());
        }
    }

    void setFileLocked(boolean locked) {
        this.fileLocked = locked;
    }

    boolean isFileLocked() {
        return this.fileLocked;
    }

    void setEditingMode(int mode) {
        if (this.isModelExperiment()) {
            if (mode == 1) {
                ExperimentInfo.getExpInfo(this.treeModel).setAttribute("editProtocol", "true");
            } else {
                ExperimentInfo.getExpInfo(this.treeModel).setAttribute("editProtocol", "false");
            }
        }
    }

    boolean isModelExperiment() {
        return ExperimentInfo.isModelExperiment(this.treeModel);
    }

    Date getLastSavedDate() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        IAttributes rootField = (IAttributes)root.getUserObject();
        String archiveUTC = rootField.getAttribute("archive-date");
        try {
            long millis = new Long(archiveUTC);
            Date d = new Date(millis);
            return d;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    void setId(long id) {
        this.id = id;
    }

    long getId() {
        return this.id;
    }
}

