/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.editor.browser.EditableTree;
import org.openmicroscopy.shoola.agents.editor.browser.ExperimentInfoPanel;
import org.openmicroscopy.shoola.agents.editor.browser.FieldEditorDisplay;
import org.openmicroscopy.shoola.agents.editor.browser.MetadataUI;
import org.openmicroscopy.shoola.agents.editor.browser.NavTree;
import org.openmicroscopy.shoola.agents.editor.browser.TextAreasView;
import org.openmicroscopy.shoola.agents.editor.browser.ToolBar;
import org.openmicroscopy.shoola.util.ui.ScrollablePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class BrowserUI
extends JPanel
implements ChangeListener {
    private BrowserControl controller;
    private BrowserModel model;
    private Browser browser;
    private static final String TREE_VIEW = "Tree View";
    private static final String TEXT_VIEW = "Text View";
    private int DIVIDER_WIDTH = 6;
    private JTree treeDisplay;
    private JTree navTree;
    private FieldEditorDisplay editorPanel;
    private JSplitPane rightSplitPane;
    private JTabbedPane tabbedPane;
    private ExperimentInfoPanel expInfoText;
    private ExperimentInfoPanel expInfoTree;
    private TextAreasView textView;
    private MetadataUI metadataUI;

    private void createTrees() {
        this.navTree = new NavTree();
        this.treeDisplay = new EditableTree(this.controller, this.navTree);
        this.textView = new TextAreasView(this.navTree, this.controller, this.browser);
        this.metadataUI = new MetadataUI(this, this.model.getTreeModel(), this.controller);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        ToolTipManager.sharedInstance().registerComponent(this.navTree);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        ScrollablePanel previewPanel = new ScrollablePanel();
        previewPanel.setLayout(new BorderLayout());
        previewPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        previewPanel.add((Component)this.metadataUI, "North");
        previewPanel.add((Component)this.navTree, "Center");
        JSplitPane leftSplitPane = new JSplitPane();
        leftSplitPane.setOneTouchExpandable(true);
        leftSplitPane.setDividerLocation(220);
        leftSplitPane.setDividerSize(this.DIVIDER_WIDTH);
        leftSplitPane.setResizeWeight(0.3);
        leftSplitPane.setBorder(null);
        leftSplitPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane previewScroll = new JScrollPane(previewPanel);
        previewScroll.setOpaque(true);
        previewScroll.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        previewScroll.setBackground(UIUtilities.BACKGROUND_COLOR);
        leftSplitPane.setLeftComponent(previewScroll);
        this.rightSplitPane = new JSplitPane();
        this.rightSplitPane.setOneTouchExpandable(true);
        this.rightSplitPane.setBorder(null);
        this.rightSplitPane.setResizeWeight(0.75);
        this.rightSplitPane.setDividerSize(this.DIVIDER_WIDTH);
        this.tabbedPane = new JTabbedPane();
        JPanel textTabPane = new JPanel(new BorderLayout());
        textTabPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane textScroller = new JScrollPane(this.textView);
        textScroller.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
        textTabPane.add((Component)textScroller, "Center");
        this.expInfoText = new ExperimentInfoPanel(this.navTree, this.controller);
        textTabPane.add((Component)this.expInfoText, "North");
        JPanel treeTabPane = new JPanel(new BorderLayout());
        treeTabPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        JScrollPane treeScroller = new JScrollPane(this.treeDisplay);
        treeScroller.setBackground(UIUtilities.BACKGROUND_COLOR);
        treeTabPane.add((Component)treeScroller, "Center");
        this.expInfoTree = new ExperimentInfoPanel(this.navTree, this.controller);
        treeTabPane.add((Component)this.expInfoTree, "North");
        this.tabbedPane.addTab(TEXT_VIEW, textTabPane);
        this.tabbedPane.addTab(TREE_VIEW, treeTabPane);
        this.tabbedPane.addChangeListener(this);
        this.rightSplitPane.setLeftComponent(this.tabbedPane);
        this.editorPanel = new FieldEditorDisplay(this.navTree, this.controller);
        this.editorPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rightSplitPane.setRightComponent(this.editorPanel);
        leftSplitPane.setRightComponent(this.rightSplitPane);
        this.add((Component)leftSplitPane, "Center");
    }

    private void showFieldEditor(boolean visible) {
        if (this.editorPanel != null) {
            this.editorPanel.setVisible(visible);
        }
        this.rightSplitPane.setDividerSize(visible ? 9 : 0);
        this.rightSplitPane.setDividerLocation(visible ? 0.7 : 1.0);
    }

    private void updateViewingMode() {
        String title = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        if (TEXT_VIEW.equals(title)) {
            this.controller.setViewingMode(1);
        } else {
            this.controller.setViewingMode(0);
        }
    }

    BrowserUI(Browser browser) {
        if (browser == null) {
            throw new NullPointerException("No browser.");
        }
        this.browser = browser;
        browser.addChangeListener(this);
    }

    JComponent getToolBar() {
        return new ToolBar(this.controller, this.navTree);
    }

    void initialize(BrowserControl controller, BrowserModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.createTrees();
        this.buildUI();
        this.onStateChanged();
    }

    void displayTree() {
        TreePath rootPath;
        TreeModel tm = this.model.getTreeModel();
        this.navTree.setModel(tm);
        this.metadataUI.setTreeModel(tm);
        this.textView.setTreeModel(tm);
        this.treeDisplay.setModel(tm);
        this.expInfoText.setTreeModel(tm);
        this.expInfoTree.setTreeModel(tm);
        if (tm != null) {
            tm.addTreeModelListener(this.editorPanel);
        }
        if ((rootPath = this.navTree.getPathForRow(0)) != null) {
            this.navTree.setSelectionPath(rootPath);
        }
        this.updateViewingMode();
    }

    void onStateChanged() {
        this.editorPanel.refreshEditorDisplay();
        this.editorPanel.setId(this.model.getId());
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == null) {
            return;
        }
        if (e.getSource().equals(this.tabbedPane)) {
            this.updateViewingMode();
        } else if (e.getSource().equals(this.browser)) {
            boolean editable = !this.browser.isFileLocked() && this.browser.getEditingMode() == 2;
            this.treeDisplay.setEditable(editable);
            this.expInfoTree.refreshEditingMode();
            this.expInfoText.refreshEditingMode();
        }
    }
}

