/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class TextAreaFilter
extends DocumentFilter {
    private StyledDocument document;
    private HTML.Tag tag;

    private boolean isOffsetWithinTag(int offset) {
        HTMLDocument.RunElement rE;
        Object ob;
        Element el = this.document.getCharacterElement(offset);
        return el instanceof HTMLDocument.RunElement && (ob = (rE = (HTMLDocument.RunElement)el).getAttribute(this.tag)) != null;
    }

    TextAreaFilter(StyledDocument doc, HTML.Tag tag) {
        this.document = doc;
        this.tag = tag;
    }

    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        boolean edit = this.canEdit(offs);
        if (edit) {
            super.insertString(fb, offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        boolean edit = this.canEdit(offs);
        if (edit) {
            boolean charEndOfATag = this.isOffsetWithinTag(offs - 1);
            if (charEndOfATag) {
                a = null;
            }
            super.replace(fb, offs, length, str, a);
        } else if (this.canEdit(offs - 1)) {
            a = null;
            super.replace(fb, offs, length, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        int end = offset + length;
        if (this.canEdit(offset)) {
            if (this.canEdit(end) || this.canEdit(end - 1)) {
                super.remove(fb, offset, length);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean canEdit(int offset) {
        return !this.isOffsetWithinTag(offset);
    }
}

