/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMEComboBoxUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CustomComboBox
extends OMEComboBox {
    public static final int MAX_LINE_LENGTH = 52;
    private int maximumWidth = 0;
    private int maxPreferredWidth = 0;

    public CustomComboBox(String[] items) {
        super(items);
        this.initialise();
    }

    public CustomComboBox(int maxPreferredWidth) {
        super(new Object[0]);
        this.initialise();
        this.setMaxPreferredWidth(maxPreferredWidth);
    }

    private void initialise() {
        this.setFont(new CustomFont());
        this.setUI(new OMEComboBoxUI());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtilities.LIGHT_GREY));
        this.setRenderer(new TruncatedListItemRenderer());
        this.addActionListener(new TruncateSelectionListener());
    }

    public void setMaximumWidth(int maxWidth) {
        this.maximumWidth = maxWidth;
    }

    public void setMaxPreferredWidth(int maxWidth) {
        this.maxPreferredWidth = maxWidth;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int prefWidth = 0;
        int height = 0;
        prefWidth = (int)size.getWidth() + 20;
        if (this.maxPreferredWidth > 0) {
            prefWidth = Math.max(prefWidth, this.maxPreferredWidth);
        }
        if (this.maximumWidth > 0) {
            prefWidth = Math.min(prefWidth, this.maximumWidth);
        }
        height = (int)size.getHeight();
        return new Dimension(prefWidth, height);
    }

    public void truncateEditableItem() {
        Object text = this.getSelectedItem();
        String fullText = "";
        if (text != null) {
            fullText = text.toString();
        }
        if (fullText.length() > 52) {
            this.setToolTipText(fullText);
            fullText = fullText.substring(0, 52) + "...";
            this.setSelectedItem(fullText);
        } else {
            this.setToolTipText(null);
        }
    }

    public class TruncateSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            CustomComboBox.this.truncateEditableItem();
        }
    }

    public class TruncatedListItemRenderer
    extends CustomLabel
    implements ListCellRenderer {
        public TruncatedListItemRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                String fullText = value.toString();
                if (fullText.length() > 52) {
                    this.setToolTipText(fullText);
                    fullText = fullText.substring(0, 52) + "...";
                } else {
                    this.setToolTipText(null);
                }
                this.setText(fullText);
                this.setBorder(new EmptyBorder(1, 2, 1, 2));
            }
            return this;
        }
    }

    public class MultiLineListItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public MultiLineListItemRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value == null) {
                return this;
            }
            String fulltext = value.toString();
            String htmlText = "<html>";
            while (fulltext.length() > 0) {
                int newLineLength = 52;
                newLineLength = fulltext.length() > 52 ? fulltext.lastIndexOf(" ", 52) : fulltext.length();
                String newLine = fulltext.substring(0, newLineLength);
                htmlText = htmlText + newLine + "<br> &nbsp &nbsp &nbsp";
                fulltext = fulltext.substring(newLineLength, fulltext.length());
            }
            htmlText = htmlText.substring(0, htmlText.lastIndexOf("<br>"));
            htmlText = htmlText + "</html>";
            this.setText(htmlText);
            this.setFont(list.getFont());
            return this;
        }
    }
}

