/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.actions.EditorAction;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.agents.editor.view.EditorControl;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class NoFileOpenUI
extends JPanel {
    private static final Font DEFAULT_FONT = new Font("Sans Serif", 0, 14);

    private void addButton(Action action, JComponent container, Icon icon) {
        CustomButton b = new CustomButton(action);
        b.setIcon(icon);
        b.setAlignmentX(0.0f);
        b.setFont(DEFAULT_FONT);
        container.add(b);
    }

    NoFileOpenUI(EditorControl controller) {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtilities.LIGHT_GREY));
        IconManager im = IconManager.getInstance();
        boolean server = EditorAgent.isServerAvailable();
        CustomLabel welcomeLabel = null;
        if (!server) {
            welcomeLabel = new CustomLabel();
            welcomeLabel.setFont(DEFAULT_FONT);
            welcomeLabel.setText("Welcome to OMERO.editor");
            welcomeLabel.setIconTextGap(10);
            welcomeLabel.setIcon(im.getIcon(82));
            welcomeLabel.setAlignmentX(0.5f);
        }
        CustomLabel infoLabel = new CustomLabel();
        infoLabel.setForeground(new Color(100, 100, 100));
        infoLabel.setFont(new Font("Sans Serif", 0, 12));
        infoLabel.setText("Please choose an option to get you started:");
        infoLabel.setAlignmentX(0.5f);
        infoLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (server) {
            infoLabel.setIcon(im.getIcon(57));
        }
        JToolBar buttonContainer = new JToolBar();
        buttonContainer.setFloatable(false);
        buttonContainer.setOrientation(1);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtilities.LIGHT_GREY);
        CompoundBorder cb = BorderFactory.createCompoundBorder(lineBorder, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonContainer.setBorder(cb);
        buttonContainer.setAlignmentX(0.5f);
        buttonContainer.setLayout(new BoxLayout(buttonContainer, 1));
        buttonContainer.setBackground(null);
        EditorAction openNew = controller.getAction(EditorControl.NEW_BLANK_FILE);
        Icon openIcon = im.getIcon(79);
        EditorAction openWww = controller.getAction(EditorControl.OPEN_WWW_FILE);
        Icon wwwIcon = im.getIcon(80);
        EditorAction openOld = controller.getAction(EditorControl.OPEN_LOCAL_FILE);
        Icon folderIcon = im.getIcon(81);
        this.addButton(openNew, buttonContainer, openIcon);
        this.addButton(openWww, buttonContainer, wwwIcon);
        this.addButton(openOld, buttonContainer, folderIcon);
        JPanel topSpacer = new JPanel();
        topSpacer.setBackground(null);
        JPanel bottomSpacer = new JPanel();
        bottomSpacer.setBackground(null);
        this.add(topSpacer);
        if (welcomeLabel != null) {
            this.add(welcomeLabel);
        }
        this.add(infoLabel);
        this.add(buttonContainer);
        this.add(bottomSpacer);
    }
}

