/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.events.iviewer;

import java.awt.Rectangle;
import org.openmicroscopy.shoola.env.event.RequestEvent;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.DataObject;
import pojos.ImageData;
import pojos.WellSampleData;

public class ViewImage
extends RequestEvent {
    private DataObject image;
    private Rectangle requesterBounds;
    private RndProxyDef settings;
    private long selectedUserID;
    private DataObject parent;
    private DataObject grandParent;
    private long imageID;
    private boolean separateWindow;

    public ViewImage(long imageID, Rectangle bounds) {
        if (imageID < 0L) {
            throw new IllegalArgumentException("Image ID not valid.");
        }
        this.imageID = imageID;
        this.requesterBounds = bounds;
        this.selectedUserID = -1L;
        this.separateWindow = true;
    }

    public ViewImage(DataObject image, Rectangle bounds) {
        if (image == null) {
            throw new IllegalArgumentException("Image not null.");
        }
        if (!(image instanceof ImageData) && !(image instanceof WellSampleData)) {
            throw new IllegalArgumentException("Object can either be a WellSample or an Image.");
        }
        this.image = image;
        this.requesterBounds = bounds;
        this.selectedUserID = -1L;
        this.imageID = -1L;
        this.separateWindow = true;
    }

    public void setContext(DataObject parent, DataObject grandParent) {
        this.parent = parent;
        this.grandParent = grandParent;
    }

    public long getImageID() {
        return this.imageID;
    }

    public DataObject getParent() {
        return this.parent;
    }

    public DataObject getGrandParent() {
        return this.grandParent;
    }

    public void setSettings(RndProxyDef settings, long selectedUserID) {
        this.settings = settings;
        this.selectedUserID = selectedUserID;
    }

    public RndProxyDef getSettings() {
        return this.settings;
    }

    public long getSelectedUserID() {
        return this.selectedUserID;
    }

    public DataObject getImage() {
        return this.image;
    }

    public Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    public boolean isSeparateWindow() {
        return this.separateWindow;
    }

    public void setSeparateWindow(boolean separateWindow) {
        this.separateWindow = separateWindow;
    }
}

