/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileElement {
    private File file;
    private String name;

    FileElement(File file) {
        if (file == null) {
            throw new IllegalArgumentException("No file set");
        }
        this.file = file;
    }

    boolean isDirectory() {
        if (this.file.isFile()) {
            return false;
        }
        File[] list = this.file.listFiles();
        return list != null && list.length != 0;
    }

    List<File> getFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        File[] list = this.file.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        if (list == null || list.length == 0) {
            return files;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isHidden() || list[i].isDirectory()) continue;
            files.add(list[i]);
        }
        return files;
    }

    String getName() {
        if (this.name == null) {
            return this.file.getAbsolutePath();
        }
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getName();
    }
}

