/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.FileSelectionTable;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImportableObject;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog
extends JDialog
implements ActionListener,
ChangeListener,
PropertyChangeListener {
    public static final String LOAD_TAGS_PROPERTY = "loadTags";
    public static final String CANCEL_SELECTION_PROPERTY = "cancelSelection";
    public static final String IMPORT_PROPERTY = "import";
    public static final int IMPORT = 0;
    public static final int CANCEL = 1;
    private static final int REFRESH = 2;
    private static final int RESET = 3;
    private static final int APPLY_TO_ALL = 4;
    private static final int TAG = 5;
    private static final int OVERRIDE = 6;
    private static final String TITLE = "Import";
    private static final String MESSAGE = "Selects the files or directories to import";
    private static final String MESSAGE_PLATE = "Selects the plates to import";
    private static final String END = ".";
    private static final String SUB_MESSAGE = "The name of the file will be, by default, the absolute path. \n You can either edit the name or set the number of directories before the file's name.";
    private static final List<String> WARNING = new ArrayList<String>();
    private static final int COLUMN_WIDTH = 200;
    private int option;
    private FileSelectionTable table;
    private JFileChooser chooser;
    private JButton cancelButton;
    private JButton importButton;
    private JButton refreshButton;
    private JButton resetButton;
    private JButton applyToAllButton;
    private JCheckBox archived;
    private JRadioButton partialName;
    private JRadioButton fullName;
    private JCheckBox overrideName;
    private NumericalTextField numberOfFolders;
    private List<FileFilter> filters;
    private TitlePanel titlePane;
    private JCheckBox folderAsTag;
    private JButton tagButton;
    private JCheckBox folderAsContainer;
    private List<NumericalTextField> pixelsSize;
    private JPanel tagsPane;
    private Map<JButton, TagAnnotationData> tagsMap;
    private ActionListener listener;
    private DataObject container;

    private void handleTagsSelection(Collection tags) {
        Collection<TagAnnotationData> set = this.tagsMap.values();
        HashMap<String, TagAnnotationData> newTags = new HashMap<String, TagAnnotationData>();
        for (TagAnnotationData tag : set) {
            if (tag.getId() >= 0L) continue;
            newTags.put(tag.getTagValue(), tag);
        }
        ArrayList<Object> toKeep = new ArrayList<Object>();
        for (TagAnnotationData tag : tags) {
            if (tag.getId() < 0L) {
                if (newTags.containsKey(tag.getTagValue())) continue;
                toKeep.add(tag);
                continue;
            }
            toKeep.add(tag);
        }
        toKeep.addAll(newTags.values());
        this.tagsMap.clear();
        this.tagsPane.removeAll();
        Iterator<Object> i = toKeep.iterator();
        IconManager icons = IconManager.getInstance();
        JPanel p = this.initRow();
        int width = 0;
        while (i.hasNext()) {
            TagAnnotationData tag;
            tag = (TagAnnotationData)i.next();
            JPanel entry = this.buildTagEntry(tag, icons.getIcon(6));
            if (width + entry.getPreferredSize().width >= 200) {
                this.tagsPane.add(p);
                p = this.initRow();
                width = 0;
            } else {
                width += entry.getPreferredSize().width;
                width += 2;
            }
            p.add(entry);
        }
        if (p.getComponentCount() > 0) {
            this.tagsPane.add(p);
        }
        this.tagsPane.validate();
        this.tagsPane.repaint();
    }

    private JPanel initRow() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        return p;
    }

    private JPanel buildTagEntry(TagAnnotationData tag, Icon icon) {
        JButton b = new JButton(icon);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addActionListener(this.listener);
        this.tagsMap.put(b, tag);
        JPanel p = new JPanel();
        JLabel l = new JLabel();
        l.setText(tag.getTagValue());
        p.setLayout(new FlowLayout(0, 0, 0));
        p.add(l);
        p.add(b);
        return p;
    }

    private void showSelectionWizard(Class type, Collection available, Collection selected, boolean addCreation) {
        IconManager icons = IconManager.getInstance();
        Registry reg = ImporterAgent.getRegistry();
        String title = "";
        String text = "";
        Icon icon = null;
        if (TagAnnotationData.class.equals((Object)type)) {
            title = "Tags Selection";
            text = "Select the Tags to add or remove, \nor Create new Tags";
            icon = icons.getIcon(5);
        }
        long userID = MetadataViewerAgent.getUserDetails().getId();
        SelectionWizard wizard = new SelectionWizard(reg.getTaskBar().getFrame(), available, selected, type, addCreation, userID);
        wizard.setAcceptButtonText("Save");
        wizard.setTitle(title, text, icon);
        wizard.addPropertyChangeListener(this);
        UIUtilities.centerAndShow(wizard);
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportDialog.this.cancelSelection();
            }
        });
    }

    private void initComponents(DataObject container, int type) {
        this.listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TagAnnotationData tag;
                Object src = e.getSource();
                if (src instanceof JButton && (tag = (TagAnnotationData)ImportDialog.this.tagsMap.get(src)) != null) {
                    ImportDialog.this.tagsMap.remove(src);
                    ImportDialog.this.handleTagsSelection(ImportDialog.this.tagsMap.values());
                }
            }
        };
        this.numberOfFolders = new NumericalTextField();
        this.numberOfFolders.setMinimum(0.0);
        this.numberOfFolders.addPropertyChangeListener(this);
        this.numberOfFolders.setText("0");
        this.numberOfFolders.setColumns(3);
        this.numberOfFolders.setEnabled(false);
        this.tagsMap = new LinkedHashMap<JButton, TagAnnotationData>();
        if (container == null || container instanceof ProjectData) {
            switch (type) {
                case 0: {
                    this.folderAsContainer = new JCheckBox("Folder as Dataset");
                    this.folderAsContainer.setToolTipText("Create a Dataset using the name of the folder");
                    this.folderAsContainer.setEnabled(false);
                    this.numberOfFolders.setMinimum(1.0);
                    this.numberOfFolders.setText("1");
                    if (container != null) break;
                    this.container = new DatasetData();
                    break;
                }
                case 1: {
                    this.folderAsContainer = new JCheckBox("Folder as Screen");
                    this.folderAsContainer.setToolTipText("Create a Screen using the name of the folder");
                    this.container = new ScreenData();
                }
            }
            if (this.folderAsContainer != null) {
                this.folderAsContainer.setSelected(true);
                this.folderAsContainer.addChangeListener(this);
            }
        }
        IconManager icons = IconManager.getInstance();
        this.tagButton = new JButton(icons.getIcon(3));
        UIUtilities.unifiedButtonLookAndFeel(this.tagButton);
        this.tagButton.addActionListener(this);
        this.tagButton.setActionCommand("5");
        this.tagButton.setToolTipText("Add Tags.");
        this.tagsPane = new JPanel();
        this.tagsPane.setLayout(new BoxLayout(this.tagsPane, 1));
        this.archived = new JCheckBox();
        this.archived.setText("Archived files");
        Boolean b = (Boolean)ImporterAgent.getRegistry().lookup("/options/Archived");
        this.archived.setSelected(b);
        b = (Boolean)ImporterAgent.getRegistry().lookup("/options/ArchivedAvailable");
        this.archived.setVisible(b);
        this.overrideName = new JCheckBox("Override default naming using the File Name.");
        this.overrideName.setToolTipText(UIUtilities.formatToolTipText(WARNING));
        this.overrideName.setSelected(true);
        this.overrideName.addChangeListener(this);
        ButtonGroup group = new ButtonGroup();
        this.fullName = new JRadioButton("Full Path+File name");
        this.fullName.setSelected(true);
        group.add(this.fullName);
        this.partialName = new JRadioButton();
        this.partialName.addChangeListener(this);
        this.partialName.setText("Directories+File name");
        group.add(this.partialName);
        this.chooser = new JFileChooser();
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            this.chooser.setCurrentDirectory(f);
        }
        this.chooser.addPropertyChangeListener(this);
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setApproveButtonText(TITLE);
        this.chooser.setApproveButtonToolTipText("Import the selected files or directories");
        if (this.filters != null) {
            Iterator<FileFilter> i = this.filters.iterator();
            while (i.hasNext()) {
                this.chooser.setFileFilter(i.next());
            }
        }
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.table = new FileSelectionTable(this);
        this.table.addPropertyChangeListener(this);
        this.cancelButton = new JButton("Close");
        this.cancelButton.setToolTipText("Close the dialog and do not import.");
        this.cancelButton.setActionCommand("1");
        this.cancelButton.addActionListener(this);
        this.importButton = new JButton(TITLE);
        this.importButton.setToolTipText("Import the selected files or directories.");
        this.importButton.setActionCommand("0");
        this.importButton.addActionListener(this);
        this.importButton.setEnabled(false);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText("Reloads the files view.");
        this.refreshButton.setActionCommand("2");
        this.refreshButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Resets the name of all files to either the full path or the partial name if selected.");
        this.resetButton.setActionCommand("3");
        this.resetButton.addActionListener(this);
        this.applyToAllButton = new JButton("Apply Partial Name");
        this.applyToAllButton.setToolTipText("Apply the partial name to all files in the queue.");
        this.applyToAllButton.setActionCommand("4");
        this.applyToAllButton.addActionListener(this);
        this.applyToAllButton.setEnabled(false);
        this.pixelsSize = new ArrayList<NumericalTextField>();
        for (int i = 0; i < 3; ++i) {
            NumericalTextField field = new NumericalTextField();
            field.setNumberType(Double.class);
            field.setColumns(2);
            this.pixelsSize.add(field);
        }
    }

    private JPanel buildToolBarRight() {
        JPanel bar = new JPanel();
        bar.setLayout(new FlowLayout(2));
        bar.add(this.resetButton);
        bar.add(Box.createHorizontalStrut(20));
        bar.add(this.cancelButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.importButton);
        bar.add(Box.createHorizontalStrut(10));
        return bar;
    }

    private JPanel buildToolBarLeft() {
        JPanel bar = new JPanel();
        bar.setLayout(new FlowLayout(0));
        bar.add(this.refreshButton);
        return bar;
    }

    private String getContainerText(Object container) {
        if (container instanceof DatasetData) {
            return "Selects the files or directories to import into dataset: " + ((DatasetData)container).getName() + END;
        }
        if (container instanceof ScreenData) {
            return "Selects the plates to import into screen: " + ((ScreenData)container).getName() + END;
        }
        return "Selects the files or directories to import.";
    }

    private JPanel buildPathComponent() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        JLabel l = new JLabel();
        l.setText("Depth: ");
        p.add(l);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.numberOfFolders);
        l = new JLabel();
        l.setText("Directories");
        p.add(l);
        return p;
    }

    private JXTaskPane buildMetadataComponent() {
        JXTaskPane pane = new JXTaskPane();
        pane.setCollapsed(true);
        pane.setTitle("Metadata Defaults");
        pane.add((Component)this.buildPixelSizeComponent());
        return pane;
    }

    private JPanel buildPixelSizeComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createTitledBorder("Pixels Size Defaults"));
        JLabel l = new JLabel();
        l.setText("Used if no values included in the file:");
        p.add(UIUtilities.buildComponentPanel(l));
        JPanel row = new JPanel();
        row.setLayout(new FlowLayout(0));
        l = new JLabel();
        l.setText("X: ");
        row.add(l);
        row.add(this.pixelsSize.get(0));
        l = new JLabel();
        l.setText("Y: ");
        row.add(l);
        row.add(this.pixelsSize.get(1));
        l = new JLabel();
        l.setText("Z: ");
        row.add(l);
        row.add(this.pixelsSize.get(2));
        p.add(row);
        return UIUtilities.buildComponentPanel(p);
    }

    private JComponent buildNamingComponent() {
        JPanel p = new JPanel();
        double[][] size = new double[][]{{15.0, -2.0}, {-2.0, -2.0, -2.0, -2.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        if (this.folderAsContainer != null) {
            p.add((Component)this.folderAsContainer, "0, 0, 1, 0");
            p.add((Component)this.buildPathComponent(), "1, 1");
            p.add((Component)this.overrideName, "0, 2, 1, 2");
        }
        p.add((Component)UIUtilities.buildComponentPanel(this.archived), "0, 3, 1, 3");
        p.add((Component)this.buildLocationComponent(), "0, 4, 1, 4");
        return UIUtilities.buildComponentPanel(p);
    }

    private JPanel buildLocationComponent() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel l = new JLabel();
        l.setText("Add Tag");
        JPanel tagPanel = new JPanel(new FlowLayout(0));
        tagPanel.add(l);
        tagPanel.add(this.tagButton);
        l = new JLabel();
        l.setText(": ");
        tagPanel.add(l);
        tagPanel.add(this.tagsPane);
        p.add(tagPanel);
        return UIUtilities.buildComponentPanel(p);
    }

    private JPanel buildOptionsPane() {
        JPanel options = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0}};
        options.setLayout((LayoutManager)new TableLayout((double[][])size));
        options.add((Component)this.buildNamingComponent(), "0, 1");
        options.add((Component)this.buildMetadataComponent(), "0, 2");
        return options;
    }

    private void buildGUI(Object container) {
        boolean supportsWindowDecorations;
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        IconManager icons = IconManager.getInstance();
        this.titlePane = new TitlePanel(TITLE, this.getContainerText(container), icons.getIcon(2));
        this.titlePane.setSubtitle(SUB_MESSAGE);
        c.add((Component)((Object)this.titlePane), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Files to import", this.table);
        tabbedPane.add("Options", this.buildOptionsPane());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.table.buildControls());
        p.add(tabbedPane);
        JSplitPane pane = new JSplitPane(1, this.chooser, p);
        c.add((Component)pane, "Center");
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(this.buildToolBarLeft());
        bar.add(this.buildToolBarRight());
        controls.add(new JSeparator());
        controls.add(bar);
        c.add((Component)controls, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void cancelSelection() {
        this.firePropertyChange(CANCEL_SELECTION_PROPERTY, (Object)false, (Object)true);
        this.option = 1;
        this.setVisible(false);
        this.dispose();
    }

    private void importFiles() {
        Integer number;
        this.option = 0;
        try {
            File dir = this.chooser.getCurrentDirectory();
            if (dir != null) {
                UIUtilities.setDefaultFolder(dir.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Map files = null;
        ImportableObject object = new ImportableObject(files, this.archived.isSelected(), this.overrideName.isSelected());
        if (this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
            object.setDepth(number);
        }
        Collection<TagAnnotationData> tags = this.tagsMap.values();
        if (this.folderAsTag != null && this.folderAsTag.isSelected()) {
            ArrayList<TagAnnotationData> folders = new ArrayList<TagAnnotationData>();
            Set keys = files.keySet();
            for (File f : keys) {
                if (!f.isDirectory()) continue;
                folders.add(new TagAnnotationData(f.getName()));
            }
            if (folders.size() > 0) {
                tags.addAll(folders);
            }
        }
        object.setTags(tags);
        long id = this.container.getId();
        if (id >= 0L && this.container.isLoaded()) {
            object.setContainer(this.container);
        } else {
            object.setFolderAsContainer(this.container.getClass());
        }
        Iterator<NumericalTextField> i = this.pixelsSize.iterator();
        double[] size = new double[3];
        int index = 0;
        int count = 0;
        while (i.hasNext()) {
            NumericalTextField f = i.next();
            Number n = f.getValueAsNumber();
            if (n != null) {
                ++count;
                size[index] = n.doubleValue();
            } else {
                size[index] = 1.0;
            }
            ++index;
        }
        if (count > 0) {
            object.setPixelsSize(size);
        }
        this.firePropertyChange(IMPORT_PROPERTY, null, object);
        this.setVisible(false);
        this.dispose();
    }

    private boolean isFileImportable(File f) {
        return true;
    }

    private void checkFile(File f, List<File> l) {
        File[] list;
        if (f == null || f.isHidden()) {
            return;
        }
        if (f.isFile()) {
            if (this.isFileImportable(f)) {
                l.add(f);
            }
        } else if (f.isDirectory() && (list = f.listFiles()) != null && list.length > 0) {
            l.add(f);
        }
    }

    boolean isArchived() {
        return this.archived.isSelected();
    }

    boolean canArchived() {
        return this.archived.isVisible();
    }

    String getDisplayedFileName(String fullPath) {
        if (fullPath == null || !this.partialName.isSelected()) {
            return fullPath;
        }
        Integer number = (Integer)this.numberOfFolders.getValueAsNumber();
        return UIUtilities.getDisplayedFileName(fullPath, number);
    }

    public ImportDialog(JFrame owner, List<FileFilter> filters, DataObject container, int type) {
        super(owner);
        this.filters = filters;
        this.setProperties();
        this.initComponents(container, type);
        this.buildGUI(container);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(7 * (screenSize.width / 10), 7 * (screenSize.height / 10));
    }

    public void resetObject(Object container) {
        this.titlePane.setTextHeader(this.getContainerText(container));
        this.titlePane.setSubtitle(SUB_MESSAGE);
        this.table.removeAllFiles();
    }

    public int showDialog() {
        UIUtilities.setLocationRelativeToAndShow(this.getParent(), this);
        return this.option;
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public void setTags(Collection tags) {
        if (tags == null) {
            return;
        }
        Collection<TagAnnotationData> set = this.tagsMap.values();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<TagAnnotationData> available = new ArrayList<TagAnnotationData>();
        ArrayList<TagAnnotationData> selected = new ArrayList<TagAnnotationData>();
        for (TagAnnotationData tag : set) {
            if (tag.getId() <= 0L) continue;
            ids.add(tag.getId());
        }
        for (TagAnnotationData tag : tags) {
            if (ids.contains(tag.getId())) {
                selected.add(tag);
                continue;
            }
            available.add(tag);
        }
        this.showSelectionWizard(TagAnnotationData.class, available, selected, true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("add".equals(name)) {
            File[] files = this.chooser.getSelectedFiles();
            if (files == null || files.length == 0) {
                return;
            }
            ArrayList<File> l = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                this.checkFile(files[i], l);
            }
            this.table.addFiles(l);
            this.importButton.setEnabled(this.table.hasFilesToImport());
        } else if ("remove".equals(name)) {
            this.importButton.setEnabled(this.table.hasFilesToImport());
        } else if ("SelectedFilesChangedProperty".equals(name)) {
            File[] files = this.chooser.getSelectedFiles();
            this.table.allowAddition(files != null && files.length > 0);
        } else if ("textUpdated".equals(name)) {
            Integer number;
            if (this.partialName.isSelected() && (number = (Integer)this.numberOfFolders.getValueAsNumber()) != null && number >= 0) {
                this.table.applyToAll();
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                if (!TagAnnotationData.class.getName().equals(type.getName())) continue;
                this.handleTagsSelection((Collection)entry.getValue());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int index = Integer.parseInt(evt.getActionCommand());
        switch (index) {
            case 0: {
                this.importFiles();
                break;
            }
            case 1: {
                this.cancelSelection();
                break;
            }
            case 2: {
                this.chooser.rescanCurrentDirectory();
                this.chooser.repaint();
                break;
            }
            case 3: {
                this.partialName.setSelected(false);
                this.table.resetFilesName();
                break;
            }
            case 4: {
                this.table.applyToAll();
                break;
            }
            case 5: {
                this.firePropertyChange(LOAD_TAGS_PROPERTY, (Object)false, (Object)true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.folderAsContainer) {
            boolean b = this.folderAsContainer.isSelected();
            this.numberOfFolders.setEnabled(b);
        }
    }

    static {
        WARNING.add("NOTE: Some file formats do not include the file name in their metadata, ");
        WARNING.add("and disabling this option may result in files being imported without a");
        WARNING.add("reference to their file name e.g. 'myfile.lsm [image001]'");
        WARNING.add("would show up as 'image001' with this optioned turned off.");
    }
}

