/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import com.sun.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GLImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.ProjectionBICanvas;

class ProjectionCanvas
extends GLImageCanvas {
    private MouseAdapter listener;
    private String text = "Click here to create\n a projection preview.";

    private void attachListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ProjectionCanvas.this.model.projectionPreview();
                ProjectionCanvas.this.text = "Creating preview";
                ProjectionCanvas.this.removeMouseListener(ProjectionCanvas.this.listener);
                ProjectionCanvas.this.repaint();
            }
        };
        this.addMouseListener(this.listener);
    }

    ProjectionCanvas(BrowserModel model, BrowserUI view) {
        super(model, view);
    }

    public void display(GLAutoDrawable drawable) {
        TextureData data = this.model.getProjectedImageAsTexture();
        if (data == null) {
            GL gl = drawable.getGL();
            gl.glClear(16640);
            Color c = ProjectionBICanvas.BACKGROUND_COLOR;
            float[] array = new float[4];
            array = c.getRGBColorComponents(array);
            gl.glClearColor(array[0], array[1], array[2], array[3]);
            c = ProjectionBICanvas.TEXT_COLOR;
            gl.glColor3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            gl.glRasterPos2f(0.25f, 0.5f);
            this.glut.glutBitmapString(6, this.text);
            this.attachListener();
            return;
        }
        this.onDisplay(drawable, data);
    }
}

