/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.player.Player;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;

class MoviePlayer
extends Player {
    public static final int FPS_MIN = 1;
    public static final int FPS_INIT = 12;
    protected static final int LOOP = 200;
    protected static final int BACKWARD = 201;
    protected static final int FORWARD = 202;
    protected static final int PINGPONG = 203;
    protected static final int LOOP_BACKWARD = 204;
    private int startZ;
    private int endZ;
    private int startT;
    private int endT;
    private int timerDelay;
    private int frameNumberZ;
    private int frameNumberT;
    private int index;
    private int movieType;
    private boolean up;
    private MoviePlayerDialog parent;

    private void initialize() {
        this.up = true;
        this.movieType = 202;
        this.timerDelay = 12;
        this.startT = this.model.getDefaultT();
        this.endT = this.getMaxT();
        this.startZ = this.model.getDefaultZ();
        this.endZ = this.getMaxZ();
        if (this.timerDelay > this.getMaximumTimer()) {
            this.timerDelay = this.getMaximumTimer();
        }
        this.setTimerDelay(this.timerDelay);
        if (this.getMaxT() != 0) {
            this.index = 301;
        } else if (this.getMaxZ() != 0) {
            this.index = 300;
        }
    }

    private void setFrameNumbers() {
        switch (this.movieType) {
            case 201: 
            case 204: {
                this.frameNumberZ = this.endZ;
                this.frameNumberT = this.endT;
                break;
            }
            default: {
                this.frameNumberZ = this.startZ;
                this.frameNumberT = this.startT;
            }
        }
    }

    private void playMovieAcrossZ() {
        switch (this.movieType) {
            case 200: {
                if (this.frameNumberZ == this.endZ) {
                    this.frameNumberZ = this.startZ;
                    break;
                }
                ++this.frameNumberZ;
                break;
            }
            case 204: {
                if (this.frameNumberZ == this.startZ) {
                    this.frameNumberZ = this.endZ;
                    break;
                }
                --this.frameNumberZ;
                break;
            }
            case 201: {
                if (this.frameNumberZ == this.startZ) {
                    this.frameNumberZ = this.endZ;
                    this.setPlayerState(1);
                    break;
                }
                --this.frameNumberZ;
                break;
            }
            case 202: {
                if (this.frameNumberZ == this.endZ) {
                    this.frameNumberZ = this.startZ;
                    this.setPlayerState(1);
                    break;
                }
                ++this.frameNumberZ;
                break;
            }
            case 203: {
                if (this.frameNumberZ < this.endZ && this.up) {
                    ++this.frameNumberZ;
                    break;
                }
                if (this.frameNumberZ > this.startZ && !this.up) {
                    --this.frameNumberZ;
                    break;
                }
                if (this.frameNumberZ == this.endZ && this.up) {
                    --this.frameNumberZ;
                    this.up = false;
                    break;
                }
                if (this.frameNumberZ != this.startZ || this.up) break;
                ++this.frameNumberZ;
                this.up = true;
            }
        }
    }

    private void playMovieAcrossT() {
        switch (this.movieType) {
            case 200: {
                if (this.frameNumberT == this.endT) {
                    this.frameNumberT = this.startT;
                    break;
                }
                ++this.frameNumberT;
                break;
            }
            case 204: {
                if (this.frameNumberT == this.startT) {
                    this.frameNumberT = this.endT;
                    break;
                }
                --this.frameNumberT;
                break;
            }
            case 201: {
                if (this.frameNumberT == this.startT) {
                    this.frameNumberT = this.endT;
                    this.setPlayerState(1);
                    break;
                }
                --this.frameNumberT;
                break;
            }
            case 202: {
                if (this.frameNumberT == this.endT) {
                    this.frameNumberT = this.startT;
                    this.setPlayerState(1);
                    break;
                }
                ++this.frameNumberT;
                break;
            }
            case 203: {
                if (this.frameNumberT < this.endT && this.up) {
                    ++this.frameNumberT;
                    break;
                }
                if (this.frameNumberT > this.startT && !this.up) {
                    --this.frameNumberT;
                    break;
                }
                if (this.frameNumberT == this.endT && this.up) {
                    --this.frameNumberT;
                    this.up = false;
                    break;
                }
                if (this.frameNumberT != this.startT || this.up) break;
                ++this.frameNumberT;
                this.up = true;
            }
        }
    }

    private void playMovieAcrossZT() {
        switch (this.movieType) {
            case 200: {
                if (this.frameNumberZ == this.endZ) {
                    this.frameNumberZ = this.startZ;
                    if (this.frameNumberT == this.endT) {
                        this.frameNumberT = this.startT;
                        break;
                    }
                    ++this.frameNumberT;
                    break;
                }
                ++this.frameNumberZ;
                break;
            }
            case 204: {
                if (this.frameNumberZ == this.startZ) {
                    this.frameNumberZ = this.endZ;
                    if (this.frameNumberT == this.startT) {
                        this.frameNumberT = this.endT;
                        break;
                    }
                    --this.frameNumberT;
                    break;
                }
                --this.frameNumberZ;
                break;
            }
            case 201: {
                if (this.frameNumberZ == this.startZ) {
                    this.frameNumberZ = this.endZ;
                    if (this.frameNumberT == this.startT) {
                        this.frameNumberT = this.endT;
                        this.setPlayerState(1);
                        break;
                    }
                    --this.frameNumberT;
                    break;
                }
                --this.frameNumberZ;
                break;
            }
            case 202: {
                if (this.frameNumberZ == this.endZ) {
                    this.frameNumberZ = this.startZ;
                    if (this.frameNumberT == this.endT) {
                        this.frameNumberT = this.startT;
                        this.setPlayerState(1);
                        break;
                    }
                    ++this.frameNumberT;
                    break;
                }
                ++this.frameNumberZ;
                break;
            }
            case 203: {
                if (this.up) {
                    if (this.frameNumberZ == this.endZ) {
                        if (this.frameNumberT == this.endT) {
                            --this.frameNumberZ;
                            this.up = false;
                            break;
                        }
                        this.frameNumberZ = this.startZ;
                        ++this.frameNumberT;
                        break;
                    }
                    ++this.frameNumberZ;
                    break;
                }
                if (this.frameNumberZ == this.startZ) {
                    if (this.frameNumberT == this.startT) {
                        ++this.frameNumberZ;
                        this.up = true;
                        break;
                    }
                    this.frameNumberZ = this.endZ;
                    --this.frameNumberT;
                    break;
                }
                --this.frameNumberZ;
            }
        }
    }

    MoviePlayer(ImViewer model, MoviePlayerDialog parent) {
        super(model);
        this.parent = parent;
        this.initialize();
        this.setFrameNumbers();
    }

    int getTimerDelay() {
        return this.timerDelay;
    }

    int getMaximumTimer() {
        return Math.max(this.getMaxZ(), this.getMaxT());
    }

    int getMovieType() {
        return this.movieType;
    }

    int getMaxT() {
        return this.model.getMaxT();
    }

    int getMaxZ() {
        return this.model.getMaxZ();
    }

    int getMinZ() {
        return 0;
    }

    int getMinT() {
        return 0;
    }

    void setStartT(int v) {
        this.startT = v;
        this.setPlayerState(1);
        this.setFrameNumbers();
    }

    void setStartZ(int v) {
        this.startZ = v;
        this.setPlayerState(1);
        this.setFrameNumbers();
    }

    void setEndT(int v) {
        this.endT = v;
        this.setPlayerState(1);
        this.setFrameNumbers();
    }

    void setEndZ(int v) {
        this.endZ = v;
        this.setPlayerState(1);
        this.setFrameNumbers();
    }

    void setTimerDelay(int delay) {
        this.setPlayerState(1);
        this.timerDelay = delay;
        this.setDelay(delay);
    }

    void setMovieType(int type) {
        this.setPlayerState(1);
        this.movieType = type;
    }

    int getStartT() {
        return this.startT;
    }

    int getEndT() {
        return this.endT;
    }

    int getStartZ() {
        return this.startZ;
    }

    int getEndZ() {
        return this.endZ;
    }

    int getMovieIndex() {
        return this.index;
    }

    void setMovieIndex(int index) {
        if (this.index == index) {
            return;
        }
        this.setPlayerState(1);
        this.index = index;
    }

    int getFrameNumberZ() {
        return this.frameNumberZ;
    }

    int getFrameNumberT() {
        return this.frameNumberT;
    }

    protected void onPlayerStateChange() {
        switch (this.state) {
            case 0: {
                this.parent.setMoviePlay(true);
                this.timer.start();
                break;
            }
            case 1: {
                this.parent.setMoviePlay(false);
                this.timer.stop();
                this.setFrameNumbers();
                this.up = true;
                break;
            }
            case 2: {
                this.parent.setMoviePlay(false);
                this.timer.stop();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 300: {
                if (this.frameNumberZ > this.getMaxZ() || this.frameNumberZ < this.startZ || this.frameNumberZ > this.endZ || this.state != 0) break;
                this.parent.renderImage();
                this.playMovieAcrossZ();
                break;
            }
            case 301: {
                if (this.frameNumberT > this.getMaxT() || this.frameNumberT < this.startT || this.frameNumberT > this.endT || this.state != 0) break;
                this.parent.renderImage();
                this.playMovieAcrossT();
                break;
            }
            case 302: {
                this.parent.renderImage();
                this.playMovieAcrossZT();
            }
        }
    }
}

