/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.saver;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaver;
import org.openmicroscopy.shoola.agents.imviewer.util.saver.ImgSaverUI;
import org.openmicroscopy.shoola.util.filter.file.BMPFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImgSaverFileChooser
extends JFileChooser
implements DocumentListener {
    private static final String DEFAULT_FORMAT = "png";
    private static final String MSG_DIR = "The image has been saved in \n";
    private ImgSaver model;
    private ImgSaverUI view;
    private JTextField nameArea;

    private void initComponents() {
        this.nameArea = (JTextField)UIUtilities.findComponent(this, JTextField.class);
        if (this.nameArea != null) {
            this.nameArea.setText(this.model.getPartialImageName());
            this.nameArea.getDocument().addDocumentListener(this);
        }
    }

    private void buildGUI() {
        this.setAcceptAllFileFilterUsed(false);
        this.setDialogType(1);
        this.setFileSelectionMode(0);
        this.addChoosableFileFilter(new BMPFilter());
        this.addChoosableFileFilter(new JPEGFilter());
        PNGFilter filter = new PNGFilter();
        this.addChoosableFileFilter(filter);
        this.addChoosableFileFilter(new TIFFFilter());
        this.setFileFilter(filter);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                this.setCurrentDirectory(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.nameArea != null) {
            this.setControlButtonsAreShown(false);
        } else {
            this.setApproveButtonToolTipText(UIUtilities.formatToolTipText("Save the current image in the specified format."));
            this.setApproveButtonText("Save as");
        }
    }

    private String getFormat(FileFilter filter) {
        String format = DEFAULT_FORMAT;
        if (filter instanceof JPEGFilter) {
            format = "jpg";
        } else if (filter instanceof PNGFilter) {
            format = DEFAULT_FORMAT;
        } else if (filter instanceof TIFFFilter) {
            format = "tif";
        } else if (filter instanceof BMPFilter) {
            format = "bmp";
        }
        return format;
    }

    private void handleTextUpdate() {
        if (this.nameArea == null) {
            return;
        }
        String text = this.nameArea.getText();
        boolean b = text == null || text.trim().length() == 0;
        this.view.setControlsEnabled(!b);
    }

    private Boolean setSelection() {
        File f = this.getSelectedFile();
        if (f == null) {
            return false;
        }
        String format = this.getFormat(this.getFileFilter());
        String fileName = f.getAbsolutePath();
        String message = MSG_DIR + this.getCurrentDirectory();
        this.model.setFileName(fileName);
        this.model.setFileFormat(format);
        this.model.setFileMessage(message);
        File[] l = this.getCurrentDirectory().listFiles();
        String n = this.model.getExtendedName(fileName, format);
        boolean exist = false;
        for (int i = 0; i < l.length; ++i) {
            if (!l[i].getAbsolutePath().equals(n)) continue;
            exist = true;
            break;
        }
        this.setSelectedFile(null);
        return exist;
    }

    ImgSaverFileChooser(ImgSaver model, ImgSaverUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void previewSelection() {
        Boolean b = this.setSelection();
        if (b == null) {
            return;
        }
        if (b.booleanValue()) {
            this.model.setSelection(0);
        } else {
            this.model.previewImage();
        }
    }

    void createFolder(String name) {
        File dir = this.getCurrentDirectory();
        String n = dir.getAbsolutePath() + File.separator + name;
        String message = "Cannot create a folder.";
        boolean b = new File(n).mkdir();
        if (b) {
            message = "Folder created.";
        }
        ImViewerAgent.getRegistry().getLogger().info((Object)this, message);
    }

    public void insertUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void cancelSelection() {
        this.model.close();
        super.cancelSelection();
    }

    public void approveSelection() {
        Boolean exist = this.setSelection();
        if (exist == null) {
            super.approveSelection();
        } else {
            if (exist.booleanValue()) {
                this.model.setSelection(1);
            } else {
                this.model.saveImage(true);
            }
            super.approveSelection();
        }
        super.approveSelection();
    }

    public File getSelectedFile() {
        if (this.nameArea == null) {
            return super.getSelectedFile();
        }
        return new File(this.getCurrentDirectory().toString(), this.nameArea.getText());
    }
}

