/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import com.sun.opengl.util.texture.TextureData;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import omero.model.PlaneInfo;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomCmd;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomGridAction;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelColorMenuItem;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.PlaneInfoComponent;
import org.openmicroscopy.shoola.agents.imviewer.view.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.view.HistoryUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.imviewer.view.ToolBar;
import org.openmicroscopy.shoola.agents.imviewer.view.UsersPopupMenu;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPane;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.ColorCheckBoxMenuItem;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImViewerUI
extends TopWindow {
    static final int GRID_ONLY = 0;
    static final int VIEW_ONLY = 1;
    static final int PROJECTION_ONLY = 2;
    static final int ALL_VIEW = 3;
    static final int NEUTRAL = 0;
    static final int HISTORY = 1;
    static final int RENDERER = 2;
    static final int HISTORY_AND_RENDERER = 3;
    private static final int ICON_EXTRA = 4;
    private static final double SCREEN_RATIO = 0.9;
    private static Map<Color, String> backgrounds = new LinkedHashMap<Color, String>();
    private ImViewerControl controller;
    private ImViewerModel model;
    private StatusBar statusBar;
    private LensComponent lens;
    private ToolBar toolBar;
    private ControlPane controlPane;
    private ButtonGroup zoomingGroup;
    private ButtonGroup colorModelGroup;
    private LoadingWindow loadingWindow = new LoadingWindow(this);
    private ClosableTabbedPane tabs;
    private HistoryUI historyUI;
    private JSplitPane historySplit;
    private JSplitPane rendererSplit;
    private int displayMode = 0;
    private JCheckBoxMenuItem rndItem;
    private JCheckBoxMenuItem metadataItem;
    private JCheckBoxMenuItem historyItem;
    private Dimension restoreSize;
    private HierarchyBoundsAdapter boundsAdapter;
    private int tabbedIconHeight;
    private UsersPopupMenu usersMenu;
    private Insets refInsets;
    private ButtonGroup bgColorGroup;
    private ButtonGroup scaleBarGroup;
    private Component source;
    private Point location;
    private JMenu zoomMenu;
    private JMenu zoomGridMenu;
    private ButtonGroup zoomingGridGroup;
    private ClosableTabbedPaneComponent viewPanel;
    private ClosableTabbedPaneComponent gridViewPanel;
    private ClosableTabbedPaneComponent projectionViewPanel;
    private Map<Integer, PlaneInfoComponent> planes;
    private JComponent mainComponent;
    private int defaultIndex = 2;
    private JComponent component;

    private HistoryItem findParentDisplay(Object x) {
        while (true) {
            if (x instanceof HistoryItem) {
                return (HistoryItem)x;
            }
            if (!(x instanceof JComponent)) break;
            x = ((JComponent)x).getParent();
        }
        return null;
    }

    private JSplitPane initSplitPane(int orientation) {
        int type;
        switch (orientation) {
            case 0: 
            case 1: {
                type = orientation;
                break;
            }
            default: {
                type = 1;
            }
        }
        JSplitPane pane = new JSplitPane(type);
        pane.setOneTouchExpandable(true);
        pane.setContinuousLayout(true);
        pane.setDividerLocation(-1);
        pane.setResizeWeight(0.0);
        return pane;
    }

    private void initSplitPanes() {
        if (this.historyUI == null) {
            this.historyUI = new HistoryUI(this, this.model, this.controller);
        }
        this.historySplit = this.initSplitPane(0);
        this.rendererSplit = this.initSplitPane(1);
    }

    private JMenuBar createMenuBar(ViewerPreferences pref) {
        this.zoomMenu = new JMenu("Zoom");
        this.zoomMenu.setMnemonic(90);
        this.zoomingGroup = new ButtonGroup();
        this.zoomGridMenu = new JMenu("Zoom");
        this.zoomingGridGroup = new ButtonGroup();
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu(pref));
        menuBar.add(this.createViewMenu(pref));
        menuBar.add(this.createZoomMenu(pref, true));
        menuBar.add(this.createShowViewMenu());
        TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
        menuBar.add(tb.getWindowsMenu());
        menuBar.add(tb.getHelpMenu());
        return menuBar;
    }

    private JMenuItem createBackgroundColorSubMenu(ViewerPreferences pref) {
        JMenu menu = new JMenu("Background color");
        this.bgColorGroup = new ButtonGroup();
        Iterator<Map.Entry<Color, String>> i = backgrounds.entrySet().iterator();
        Color refColor = ImagePaintingFactory.DEFAULT_BACKGROUND;
        if (pref != null) {
            refColor = pref.getBackgroundColor();
        }
        if (refColor == null) {
            refColor = ImagePaintingFactory.DEFAULT_BACKGROUND;
        }
        while (i.hasNext()) {
            Map.Entry<Color, String> entry = i.next();
            Color c = entry.getKey();
            ColorCheckBoxMenuItem item = new ColorCheckBoxMenuItem(c);
            item.setText(entry.getValue());
            item.setSelected(c.equals(refColor));
            this.bgColorGroup.add(item);
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorCheckBoxMenuItem src = (ColorCheckBoxMenuItem)e.getSource();
                    if (src.isSelected()) {
                        ImViewerUI.this.controller.setPreferences();
                        if (ImViewerUI.this.lens != null) {
                            ImViewerUI.this.lens.setBackgroundColor(src.getColor());
                        }
                        ImViewerUI.this.model.getBrowser().setBackgroundColor(src.getColor());
                    }
                }
            });
        }
        return menu;
    }

    private JMenuItem createScaleBarColorSubMenu(ViewerPreferences pref) {
        JMenu menu = new JMenu("Scale bar/Text color");
        ButtonGroup group = new ButtonGroup();
        Iterator<Map.Entry<Color, String>> i = EditorUtil.COLORS_BAR.entrySet().iterator();
        Color refColor = ImagePaintingFactory.UNIT_BAR_COLOR;
        if (pref != null) {
            refColor = pref.getScaleBarColor();
        }
        if (refColor == null) {
            refColor = ImagePaintingFactory.UNIT_BAR_COLOR;
        }
        while (i.hasNext()) {
            Map.Entry<Color, String> entry = i.next();
            Color c = entry.getKey();
            ColorCheckBoxMenuItem item = new ColorCheckBoxMenuItem(c);
            item.setText(entry.getValue());
            item.setSelected(c.equals(refColor));
            group.add(item);
            menu.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorCheckBoxMenuItem source = (ColorCheckBoxMenuItem)e.getSource();
                    if (source.isSelected()) {
                        ImViewerUI.this.model.getBrowser().setUnitBarColor(source.getColor());
                    }
                }
            });
        }
        return menu;
    }

    private JMenu createScaleBarLengthSubMenu(ViewerPreferences pref) {
        JMenu menu = new JMenu("Scale bar length (in  \u00b5m)");
        this.scaleBarGroup = new ButtonGroup();
        if (pref != null && pref.getScaleBarIndex() > 0) {
            this.defaultIndex = pref.getScaleBarIndex();
        }
        UnitBarSizeAction a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_ONE);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
        item.setSelected(a.getIndex() == this.defaultIndex);
        this.scaleBarGroup.add(item);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TWO);
        item = new JCheckBoxMenuItem(a);
        item.setSelected(a.getIndex() == this.defaultIndex);
        this.scaleBarGroup.add(item);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_FIVE);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_FIVE));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TEN);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_TEN));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_TWENTY);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_TWENTY));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_FIFTY);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_FIFTY));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_HUNDRED);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_HUNDRED));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        a = (UnitBarSizeAction)this.controller.getAction(ImViewerControl.UNIT_BAR_CUSTOM);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.UNIT_BAR_CUSTOM));
        this.scaleBarGroup.add(item);
        item.setSelected(a.getIndex() == this.defaultIndex);
        menu.add(item);
        return menu;
    }

    private JMenu createViewMenu(ViewerPreferences pref) {
        JMenu menu = new JMenu("Display");
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setSelected(this.model.isUnitBar());
        item.setAction(this.controller.getAction(ImViewerControl.UNIT_BAR));
        menu.add(item);
        menu.add(this.createScaleBarLengthSubMenu(pref));
        menu.add(this.createScaleBarColorSubMenu(pref));
        menu.add(new JSeparator(0));
        menu.add(this.createBackgroundColorSubMenu(pref));
        return menu;
    }

    private JMenu createControlsMenu(ViewerPreferences pref) {
        JMenu menu = new JMenu("Controls");
        menu.setMnemonic(67);
        ViewerAction action = this.controller.getAction(ImViewerControl.RENDERER);
        this.rndItem = new JCheckBoxMenuItem();
        this.rndItem.setSelected(this.isRendererShown());
        this.rndItem.setAction(action);
        this.rndItem.setText(action.getName());
        if (pref != null) {
            this.rndItem.setSelected(pref.isRenderer());
        }
        action = this.controller.getAction(ImViewerControl.METADATA);
        this.metadataItem = new JCheckBoxMenuItem();
        this.metadataItem.setSelected(this.isRendererShown());
        this.metadataItem.setAction(action);
        this.metadataItem.setText(action.getName());
        if (pref != null) {
            this.metadataItem.setSelected(pref.isRenderer());
        }
        action = this.controller.getAction(ImViewerControl.HISTORY);
        this.historyItem = new JCheckBoxMenuItem();
        this.historyItem.setSelected(this.isHistoryShown());
        this.historyItem.setAction(action);
        this.historyItem.setText(action.getName());
        if (pref != null) {
            this.historyItem.setSelected(pref.isHistory());
        }
        action = this.controller.getAction(ImViewerControl.MOVIE);
        JMenuItem item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.LENS);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.MEASUREMENT_TOOL);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        menu.add(new JSeparator(0));
        this.colorModelGroup = new ButtonGroup();
        action = this.controller.getAction(ImViewerControl.GREY_SCALE_MODEL);
        item = new JCheckBoxMenuItem();
        String cm = this.model.getColorModel();
        item.setSelected(cm.equals("greyscale"));
        item.setAction(action);
        this.colorModelGroup.add(item);
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.RGB_MODEL);
        item = new JCheckBoxMenuItem();
        item.setAction(action);
        item.setSelected(cm.equals("rgb"));
        this.colorModelGroup.add(item);
        menu.add(item);
        menu.add(new JSeparator());
        action = this.controller.getAction(ImViewerControl.CHANNELS_ON);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.CHANNELS_OFF);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        menu.add(new JSeparator());
        action = this.controller.getAction(ImViewerControl.SAVE);
        item = new JMenuItem(action);
        item.setText(action.getName());
        menu.add(item);
        action = this.controller.getAction(ImViewerControl.PREFERENCES);
        item = new JMenuItem(action);
        item.setText(action.getName());
        return menu;
    }

    private JMenu createZoomMenu(ViewerPreferences pref, boolean full) {
        ViewerAction action = this.controller.getAction(ImViewerControl.ZOOM_25);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        this.zoomMenu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_50);
        item = new JCheckBoxMenuItem(action);
        this.zoomMenu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_75);
        item = new JCheckBoxMenuItem(action);
        this.zoomMenu.add(item);
        this.zoomingGroup.add(item);
        action = this.controller.getAction(ImViewerControl.ZOOM_100);
        item = new JCheckBoxMenuItem();
        item.setAction(action);
        this.zoomMenu.add(item);
        this.zoomingGroup.add(item);
        if (full) {
            action = this.controller.getAction(ImViewerControl.ZOOM_125);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_150);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_175);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_200);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_225);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_250);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_275);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
            action = this.controller.getAction(ImViewerControl.ZOOM_300);
            item = new JCheckBoxMenuItem(action);
            this.zoomMenu.add(item);
            this.zoomingGroup.add(item);
        }
        action = this.controller.getAction(ImViewerControl.ZOOM_FIT_TO_WINDOW);
        item = new JCheckBoxMenuItem(action);
        this.zoomMenu.add(item);
        this.zoomingGroup.add(item);
        int index = 3;
        double factor = 1.0;
        if (pref != null && pref.isFieldSelected("Zoom factor")) {
            index = pref.getZoomIndex();
            factor = ZoomAction.getZoomFactor(index);
        }
        this.setZoomFactor(factor, index);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.ZOOM_GRID_25));
        this.zoomGridMenu.add(item);
        this.zoomingGridGroup.add(item);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.ZOOM_GRID_50));
        this.zoomGridMenu.add(item);
        this.zoomingGridGroup.add(item);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.ZOOM_GRID_75));
        this.zoomGridMenu.add(item);
        this.zoomingGridGroup.add(item);
        item = new JCheckBoxMenuItem(this.controller.getAction(ImViewerControl.ZOOM_GRID_100));
        this.zoomGridMenu.add(item);
        this.zoomingGridGroup.add(item);
        this.setGridMagnificationFactor(0.5);
        return this.zoomMenu;
    }

    private JMenu createShowViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(83);
        JMenuItem item = new JMenuItem(this.controller.getAction(ImViewerControl.TAB_GRID));
        if (this.model.isBigImage() || this.model.isNumerousChannel()) {
            item.setEnabled(false);
        } else {
            item.setEnabled(this.model.getMaxC() > 1);
        }
        menu.add(item);
        item = new JMenuItem(this.controller.getAction(ImViewerControl.TAB_PROJECTION));
        item.setEnabled(this.model.getMaxZ() > 1 && !this.model.isBigImage());
        menu.add(item);
        return menu;
    }

    private void buildGUI() {
        Browser browser = this.model.getBrowser();
        Dimension d = this.model.computeSize();
        int sizeX = d.width;
        int sizeY = d.height;
        double f = this.model.getZoomFactor();
        if (f > 0.0) {
            sizeX = (int)((double)sizeX * f);
            sizeY = (int)((double)sizeY * f);
            double factor = (double)Math.round(f * 100.0) / 100.0;
            this.setZoomFactor(factor, ZoomCmd.getZoomIndex(f));
            this.setMagnificationStatus(factor);
        }
        browser.setComponentsSize(sizeX, sizeY);
        this.tabs = new ClosableTabbedPane(1, 0);
        this.tabs.setAlignmentX(0.0f);
        this.viewPanel = new ClosableTabbedPaneComponent(0, browser.getTitle(), browser.getIcon(), "");
        this.viewPanel.setClosable(false);
        double[][] tl = new double[][]{{-2.0, -1.0}, {-1.0, -2.0, -2.0}};
        this.viewPanel.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.viewPanel.add((Component)this.controlPane, "0, 0");
        this.viewPanel.add((Component)browser.getUI(), "1, 0");
        this.viewPanel.add((Component)this.controlPane.getTimeSliderPane(0), "1, 1");
        if (this.model.isNumerousChannel()) {
            this.viewPanel.add((Component)this.controlPane.getLifetimeSliderPane(0), "1, 2");
        }
        this.tabbedIconHeight = browser.getIcon().getIconHeight() + 4;
        this.tabs.insertTab(browser.getTitle(), browser.getIcon(), this.viewPanel, "", 0);
        this.gridViewPanel = new ClosableTabbedPaneComponent(1, browser.getGridViewTitle(), browser.getGridViewIcon(), "");
        this.gridViewPanel.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.gridViewPanel.add((Component)this.controlPane.buildGridComponent(), "0, 0");
        this.gridViewPanel.add((Component)browser.getGridView(), "1, 0");
        this.gridViewPanel.add((Component)this.controlPane.getTimeSliderPane(1), "1, 1");
        if (this.model.allowSplitView() && !this.model.isBigImage()) {
            this.tabs.insertTab(browser.getGridViewTitle(), browser.getGridViewIcon(), this.gridViewPanel, "", 1);
        }
        double[][] tl2 = new double[][]{{-2.0, -1.0}, {-2.0, -1.0, -2.0}};
        this.projectionViewPanel = new ClosableTabbedPaneComponent(2, browser.getProjectionViewTitle(), browser.getProjectionViewIcon(), "");
        this.projectionViewPanel.setLayout((LayoutManager)new TableLayout((double[][])tl2));
        this.projectionViewPanel.add((Component)this.controlPane.buildProjectionToolBar(), "0, 0, 1, 0");
        this.projectionViewPanel.add((Component)this.controlPane.buildProjectionComponent(), "0, 1");
        this.projectionViewPanel.add((Component)browser.getProjectionView(), "1, 1");
        this.projectionViewPanel.add((Component)this.controlPane.getTimeSliderPane(2), "1, 2");
        if (this.model.getMaxZ() > 0 && !this.model.isBigImage()) {
            this.tabs.insertTab(browser.getProjectionViewTitle(), browser.getProjectionViewIcon(), this.projectionViewPanel, "", 2);
        }
        this.tabs.addChangeListener(this.controller);
        this.rendererSplit.setLeftComponent(this.tabs);
        this.mainComponent = this.rendererSplit;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.mainComponent, "Center");
        container.add((Component)this.statusBar, "South");
        this.boundsAdapter = new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent e) {
                if (ImViewerUI.this.tabs != null) {
                    ImViewerUI.this.restoreSize = ImViewerUI.this.tabs.getSize();
                }
            }
        };
        container.addHierarchyBoundsListener(this.boundsAdapter);
    }

    private Dimension getIdealSize(int w, int h) {
        Dimension sz = new Dimension();
        Dimension tbDim = this.toolBar.getPreferredSize();
        Dimension statusDim = this.statusBar.getPreferredSize();
        Insets frameInsets = this.getInsets();
        Insets stInsets = this.statusBar.getInsets();
        sz.width = w + frameInsets.left + frameInsets.right + stInsets.left + stInsets.right + this.rendererSplit.getDividerSize();
        sz.height = h + tbDim.height + statusDim.height + frameInsets.top + frameInsets.bottom + this.tabbedIconHeight + stInsets.top + stInsets.bottom;
        return sz;
    }

    private void addComponents(JSplitPane pane, JComponent left, JComponent right) {
        Component c = pane.getLeftComponent();
        if (c != null) {
            pane.remove(c);
        }
        if ((c = pane.getRightComponent()) != null) {
            pane.remove(c);
        }
        pane.setLeftComponent(left);
        pane.setRightComponent(right);
    }

    private void layoutComponents(boolean fromPreferences) {
        Dimension d;
        Container container = this.getContentPane();
        container.removeHierarchyBoundsListener(this.boundsAdapter);
        int width = 0;
        int height = 0;
        int vExtra = 2;
        switch (this.displayMode) {
            case 2: {
                JComponent rightComponent = this.model.getMetadataViewer().getEditorUI();
                this.rendererSplit.setRightComponent(rightComponent);
                if (this.restoreSize == null) {
                    this.rendererSplit.setResizeWeight(1.0);
                    return;
                }
                d = this.model.getMetadataViewer().getIdealRendererSize();
                rightComponent.setMinimumSize(d);
                this.tabs.setMinimumSize(this.restoreSize);
                height = this.restoreSize.height;
                int diff = d.height - this.restoreSize.height;
                height = diff > 0 ? (height += diff) : (height += vExtra);
                int addition = this.rendererSplit.getDividerSize() + 2 * (this.refInsets.left + this.refInsets.right);
                width = this.restoreSize.width + d.width;
                width += 4 * addition;
                break;
            }
            case 1: {
                container.remove(this.mainComponent);
                this.historyUI.doGridLayout();
                this.addComponents(this.historySplit, this.tabs, this.historyUI);
                this.mainComponent = this.historySplit;
                container.add((Component)this.mainComponent, "Center");
                container.validate();
                container.repaint();
                height = this.restoreSize.height;
                width = this.restoreSize.width;
                d = this.historyUI.getIdealSize();
                int addition = this.historySplit.getDividerSize() + 2 * (this.refInsets.top + this.refInsets.bottom);
                height += d.height;
                this.historySplit.setResizeWeight(0.49);
                height += addition;
                break;
            }
            case 3: {
                this.historySplit.setResizeWeight(0.49);
                container.remove(this.mainComponent);
                this.historyUI.doGridLayout();
                JComponent rightComponent = this.model.getMetadataViewer().getEditorUI();
                this.addComponents(this.rendererSplit, this.tabs, rightComponent);
                this.addComponents(this.historySplit, this.rendererSplit, this.historyUI);
                this.mainComponent = this.historySplit;
                container.add((Component)this.mainComponent, "Center");
                container.validate();
                container.repaint();
                d = this.model.getMetadataViewer().getIdealRendererSize();
                height = this.restoreSize.height;
                int diff = d.height - this.restoreSize.height;
                height = diff > 0 ? (height += diff) : (height += vExtra);
                int addition = this.rendererSplit.getDividerSize() + 2 * (this.refInsets.left + this.refInsets.right);
                width = this.restoreSize.width + d.width;
                width += 4 * addition;
                d = this.historyUI.getPreferredSize();
                addition = this.historySplit.getDividerSize() + 2 * (this.refInsets.top + this.refInsets.bottom);
                height += d.height;
                height += addition;
                break;
            }
            case 0: {
                JComponent rightComponent = this.model.getMetadataViewer().getEditorUI();
                this.rendererSplit.remove(rightComponent);
                if (this.restoreSize == null) {
                    return;
                }
                width = this.restoreSize.width;
                height = this.restoreSize.height;
                break;
            }
        }
        d = this.getIdealSize(width, height);
        this.setSize(d);
        this.setPreferredSize(d);
        this.pack();
        container.addHierarchyBoundsListener(this.boundsAdapter);
    }

    private void packWindow() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        int width = (int)((double)screenSize.width * 0.9);
        int height = (int)((double)screenSize.height * 0.9);
        int w = size.width;
        int h = size.height;
        boolean reset = false;
        if (w > width) {
            reset = true;
        }
        if (h > height) {
            reset = true;
            h = height;
        }
        if (reset) {
            this.setSize(h, h);
            this.model.setZoomFactor(-1.0, false);
            this.clearZoomMenu(this.zoomingGroup, this.zoomMenu);
            this.clearZoomMenu(this.zoomingGridGroup, this.zoomGridMenu);
            ViewerPreferences pref = ImViewerFactory.getPreferences();
            this.createZoomMenu(pref, false);
            this.controlPane.resetZoomValues();
        }
    }

    private void clearZoomMenu(ButtonGroup group, JMenu menu) {
        menu.removeAll();
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            group.remove(e.nextElement());
        }
    }

    ImViewerUI(String title) {
        super(title);
    }

    void initialize(ImViewerControl controller, ImViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.toolBar = new ToolBar(this, controller);
        this.controlPane = new ControlPane(controller, model, this);
        this.statusBar = new StatusBar(model);
        this.initSplitPanes();
        this.refInsets = this.rendererSplit.getInsets();
        this.addComponentListener(controller);
        this.planes = new HashMap<Integer, PlaneInfoComponent>();
        ImageIcon icon = IconManager.getInstance().getImageIcon(22);
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
    }

    void buildComponents() {
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        this.setJMenuBar(this.createMenuBar(pref));
        this.toolBar.buildComponent();
        this.controlPane.buildComponent();
        this.buildGUI();
        List<ChannelData> data = this.model.getChannelData();
        for (ChannelData d : data) {
            int index = d.getIndex();
            PlaneInfoComponent comp = new PlaneInfoComponent(this.model.getChannelColor(index));
            comp.addPropertyChangeListener("planeInfo", this.controller);
            this.planes.put(index, comp);
        }
    }

    void setZoomFactor(double factor, int zoomIndex) {
        this.setMagnificationStatus(factor);
        if (this.zoomingGroup == null) {
            return;
        }
        Enumeration<AbstractButton> e = this.zoomingGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem b = (JCheckBoxMenuItem)e.nextElement();
            Action a = b.getAction();
            if (!(a instanceof ZoomAction)) continue;
            b.removeActionListener(a);
            b.setSelected(((ZoomAction)a).getIndex() == zoomIndex);
            b.setAction(a);
        }
        this.controlPane.setZoomFactor(zoomIndex);
    }

    void setMagnificationStatus(double factor) {
        if (this.statusBar == null) {
            return;
        }
        if (factor != -1.0) {
            this.statusBar.setRigthStatus("x" + (double)Math.round(factor * this.model.getOriginalRatio() * 100.0) / 100.0);
        } else {
            this.statusBar.setRigthStatus("Zoom to Fit");
        }
    }

    int getZoomIndex() {
        if (this.zoomingGroup == null) {
            return 12;
        }
        Enumeration<AbstractButton> e = this.zoomingGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem b = (JCheckBoxMenuItem)e.nextElement();
            Action a = b.getAction();
            if (!b.isSelected()) continue;
            return ((ZoomAction)a).getIndex();
        }
        return 12;
    }

    void setColorModel(int key) {
        this.controlPane.setColorModel();
        Enumeration<AbstractButton> e = this.colorModelGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            Action a = b.getAction();
            if (!(a instanceof ColorModelAction)) continue;
            b.removeActionListener(a);
            b.setSelected(((ColorModelAction)a).getIndex() == key);
            b.setAction(a);
        }
    }

    void setZSection(int z) {
        this.controlPane.setZSection(z);
    }

    void setTimepoint(int t) {
        this.controlPane.setTimepoint(t);
    }

    LoadingWindow getLoadingWindow() {
        return this.loadingWindow;
    }

    void onStateChange(boolean b) {
        this.tabs.setEnabled(b);
        this.enableSliders(b);
        this.controlPane.onStateChange(b);
        this.toolBar.onStateChange(b);
    }

    void setLeftStatus() {
        String text = "";
        int max = this.model.getMaxZ();
        double d = this.model.getPixelsSizeZ();
        if (this.model.getTabbedIndex() == 2) {
            int n = this.getProjectionStartZ();
            int m = this.getProjectionEndZ();
            text = text + "Z range:" + (n + 1);
            text = text + "-" + (this.getProjectionEndZ() + 1);
            if (d > 0.0 && max > 0) {
                text = text + " (" + UIUtilities.roundTwoDecimals((double)n * d) + "-" + UIUtilities.roundTwoDecimals((double)m * d) + " " + "\u00b5m" + ")";
            }
            text = text + "/" + (this.model.getMaxZ() + 1);
        } else {
            int n = this.model.getDefaultZ();
            text = text + "Z=" + (n + 1);
            if (d > 0.0 && max > 0) {
                text = text + " (" + UIUtilities.roundTwoDecimals((double)n * d) + "\u00b5m" + ")";
            }
            text = text + "/" + (this.model.getMaxZ() + 1);
        }
        text = text + " T=" + (this.model.getDefaultT() + 1) + "/" + (this.model.getMaxT() + 1);
        if (this.model.isNumerousChannel()) {
            text = text + " L=" + (this.model.getSelectedBin() + 1);
            text = text + "/" + this.model.getMaxLifetimeBin();
        }
        this.setLeftStatus(text);
    }

    void setLeftStatus(String description) {
        this.statusBar.setLeftStatus(description);
    }

    void setPlaneInfoStatus() {
        if (this.model.getTabbedIndex() == 2) {
            this.statusBar.setCenterStatus(new JLabel());
            return;
        }
        List<Integer> indexes = this.model.getActiveChannels();
        if (indexes == null || indexes.size() == 0) {
            this.statusBar.setCenterStatus(new JLabel());
            return;
        }
        int z = this.model.getDefaultZ();
        int t = this.model.getDefaultT();
        Map<Integer, Color> colors = this.model.getChannelsColorMap();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        List<ChannelData> metadata = this.model.getChannelData();
        Iterator<ChannelData> c = metadata.iterator();
        while (c.hasNext()) {
            int index = c.next().getIndex();
            String s = "";
            String toolTipText = "";
            ArrayList<String> tips = new ArrayList<String>();
            PlaneInfo info = this.model.getPlane(z, index, t);
            PlaneInfoComponent comp = this.planes.get(index);
            if (info == null) continue;
            Map<String, Object> details = EditorUtil.transformPlaneInfo(info);
            List notSet = (List)details.get("NotSet");
            comp.setColor(colors.get(index));
            if (!notSet.contains("DeltaT")) {
                s = s + EditorUtil.formatTimeInSeconds((Double)details.get("DeltaT"));
            }
            if (!notSet.contains("Exposure Time")) {
                toolTipText = toolTipText + "Exposure Time: ";
                toolTipText = toolTipText + details.get("Exposure Time");
                toolTipText = toolTipText + "s";
                tips.add(toolTipText);
            }
            toolTipText = "";
            toolTipText = toolTipText + "Stage coordinates: ";
            if (!notSet.contains("Position X")) {
                toolTipText = toolTipText + "x=" + details.get("Position X") + " ";
            }
            if (!notSet.contains("Position Y")) {
                toolTipText = toolTipText + "y=" + details.get("Position Y") + " ";
            }
            if (!notSet.contains("Position Z")) {
                toolTipText = toolTipText + "z=" + details.get("Position Z");
            }
            tips.add(toolTipText);
            comp.setToolTipText(UIUtilities.formatToolTipText(tips));
            comp.setText(s);
            panel.add(comp);
        }
        this.statusBar.setCenterStatus(panel);
    }

    void setChannelsSelection(int index) {
        this.controlPane.setChannelsSelection(index);
    }

    void setChannelsSelection(List channels) {
        this.controlPane.setChannelsSelection(channels);
    }

    void playChannelMovie(boolean enabled) {
        this.tabs.setEnabled(enabled);
    }

    void setChannelColor(int index, Color c) {
        PlaneInfoComponent comp = this.planes.get(index);
        if (comp != null) {
            comp.setColor(c);
        }
        this.controlPane.setChannelColor(index, c);
    }

    void resetDefaults() {
        this.controlPane.resetRndSettings();
    }

    void switchRndControl() {
        this.controlPane.switchRndControl();
    }

    void refresh() {
        this.resetDefaults();
        this.model.refresh();
    }

    void setLensPlaneImage() {
        if (this.lens == null) {
            return;
        }
        switch (this.model.getTabbedIndex()) {
            case 0: {
                this.lens.setPlaneImage(this.model.getOriginalImage());
                break;
            }
            case 1: {
                this.lens.setPlaneImage(this.model.getGridImage());
                break;
            }
            case 2: {
                BufferedImage image = this.model.getProjectedImage();
                if (image == null) break;
                this.lens.setPlaneImage(image);
            }
        }
    }

    BufferedImage createZoomedLensImage(BufferedImage image) {
        if (this.lens == null) {
            return null;
        }
        try {
            return this.lens.createZoomedImage(image);
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean isLensVisible() {
        if (this.lens != null) {
            return this.lens.isVisible();
        }
        return false;
    }

    boolean hasLensImage() {
        return this.lens != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setLensVisible(boolean b, int historyIndex) {
        boolean firstTime = false;
        if (this.lens == null) {
            if (!b) return;
            firstTime = true;
            this.lens = new LensComponent(this, ImViewerAgent.hasOpenGLSupport());
            this.lens.setXYPixelMicron(this.model.getPixelsSizeX(), this.model.getPixelsSizeY());
            this.lens.addPropertyChangeListener("lensLocation", this.controller);
        } else {
            Browser browser = this.model.getBrowser();
            JComponent c = this.lens.getLensUI();
            browser.removeComponent(c, 0);
            browser.removeComponent(c, 1);
            browser.removeComponent(c, 2);
        }
        if (!b) {
            this.lens.setVisible(b);
            this.repaint();
            return;
        }
        int maxX = this.model.getMaxX();
        int maxY = this.model.getMaxY();
        float f = 1.0f;
        int index = this.model.getTabbedIndex();
        JComponent c = this.lens.getLensUI();
        int width = c.getWidth();
        int height = c.getHeight();
        Point p = this.lens.getLensLocation();
        int lensX = p.x;
        int lensY = p.y;
        if (maxX < width || maxY < height) {
            return;
        }
        if (firstTime) {
            int diffX = maxX - width;
            int diffY = maxY - height;
            lensX = diffX / 2;
            lensY = diffY / 2;
            if (lensX + width > maxX) {
                lensX = diffX;
            }
            if (lensY + height > maxY) {
                lensY = diffY;
            }
        } else {
            switch (historyIndex) {
                case 1: {
                    if (historyIndex == index) break;
                    Point point = this.model.getBrowser().isOnImageInGrid(this.lens.getLensScaledBounds());
                    if (point == null) {
                        int diffX = maxX - width;
                        int diffY = maxY - height;
                        lensX = diffX / 2;
                        lensY = diffY / 2;
                        if (lensX + width > maxX) {
                            lensX = diffX;
                        }
                        if (lensY + height <= maxY) break;
                        lensY = diffY;
                        break;
                    }
                    double r = this.model.getBrowser().getRatio();
                    lensX = (int)((double)point.x / r);
                    lensY = (int)((double)point.y / r);
                    break;
                }
                case 0: 
                case 2: {
                    if (index != 1) break;
                    double r = this.model.getBrowser().getRatio();
                    lensX = (int)((double)lensX * r);
                    lensY = (int)((double)lensY * r);
                }
            }
        }
        if (ImViewerAgent.hasOpenGLSupport()) {
            TextureData image;
            switch (index) {
                default: {
                    f = (float)this.model.getZoomFactor();
                    image = this.model.getImageAsTexture();
                    break;
                }
                case 2: {
                    f = (float)this.model.getZoomFactor();
                    image = this.model.getProjectedImageAsTexture();
                    break;
                }
                case 1: {
                    image = null;
                }
            }
            if (image != null) {
                this.lens.resetLensAsTexture(image, f, lensX, lensY);
            }
        } else {
            BufferedImage img;
            switch (index) {
                default: {
                    f = (float)this.model.getZoomFactor();
                    img = this.model.getOriginalImage();
                    break;
                }
                case 2: {
                    f = (float)this.model.getZoomFactor();
                    img = this.model.getProjectedImage();
                    break;
                }
                case 1: {
                    img = this.model.getGridImage();
                }
            }
            if (img != null) {
                this.lens.resetLens(img, f, lensX, lensY);
            }
        }
        this.model.getBrowser().addComponent(c, index);
        this.scrollLens();
        UIUtilities.setLocationRelativeTo(this, this.lens.getZoomWindow());
        this.lens.setVisible(b);
        this.repaint();
    }

    BufferedImage getZoomedLensImage() {
        if (this.lens == null) {
            return null;
        }
        return this.lens.getZoomedImage();
    }

    void setImageZoomFactor(float factor) {
        if (this.lens == null) {
            return;
        }
        this.lens.setImageZoomFactor(factor);
    }

    void onIconified() {
        if (this.lens == null) {
            return;
        }
        this.lens.setVisible(false);
        this.repaint();
    }

    void showMenu(int menuID) {
        this.showMenu(menuID, this.source, this.location);
    }

    void showMenu(int menuID, Component source, Point location) {
        switch (menuID) {
            case 0: {
                List<ChannelData> data = this.model.getChannelData();
                JPopupMenu menu = new JPopupMenu();
                for (ChannelData d : data) {
                    int index = d.getIndex();
                    ChannelColorMenuItem item = new ChannelColorMenuItem(d.getChannelLabeling(), this.model.getChannelColor(index), index);
                    menu.add(item);
                    item.addPropertyChangeListener(this.controller);
                }
                menu.show(source, location.x, location.y);
            }
        }
    }

    void scrollToNode(Rectangle bounds) {
        if (this.lens == null) {
            return;
        }
        if (!this.lens.isVisible()) {
            return;
        }
        this.model.getBrowser().scrollTo(bounds, true);
    }

    void scrollLens() {
        if (this.lens == null) {
            return;
        }
        this.model.getBrowser().scrollTo(this.lens.getLensScaledBounds(), false);
    }

    void selectTabbedPane(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.tabs.setSelectedIndex(index);
                break;
            }
            default: {
                return;
            }
        }
    }

    void setSelectedPane(int index) {
        JMenuBar menuBar = this.getJMenuBar();
        Component[] items = menuBar.getComponents();
        int j = -1;
        for (int i = 0; i < items.length; ++i) {
            Component item = items[i];
            if (item != this.zoomGridMenu && item != this.zoomMenu) continue;
            j = i;
        }
        if (j != -1) {
            menuBar.remove(j);
        }
        switch (index) {
            case 1: {
                if (j != -1) {
                    menuBar.add((Component)this.zoomGridMenu, j);
                }
                this.setMagnificationStatus(this.model.getBrowser().getGridRatio());
                break;
            }
            default: {
                if (j != -1) {
                    menuBar.add((Component)this.zoomMenu, j);
                }
                this.setMagnificationStatus(this.model.getZoomFactor());
            }
        }
        int oldIndex = this.model.getTabbedIndex();
        this.model.setTabbedIndex(index);
        this.tabs.removeChangeListener(this.controller);
        int n = this.tabs.getTabCount();
        for (int i = 0; i < n; ++i) {
            int tabbedIndex;
            Component c = this.tabs.getComponentAt(i);
            if (!(c instanceof ClosableTabbedPaneComponent) || (tabbedIndex = ((ClosableTabbedPaneComponent)c).getIndex()) != index) continue;
            this.tabs.setSelectedIndex(i);
        }
        this.tabs.addChangeListener(this.controller);
        this.setLeftStatus();
        this.setPlaneInfoStatus();
        this.model.getBrowser().setSelectedPane(index);
        this.setLensVisible(this.isLensVisible(), oldIndex);
        this.maximizeWindow();
    }

    String getSelectedPaneColorModel() {
        return this.controlPane.getSelectedPaneColorModel();
    }

    void maximizeWindow() {
        JComponent c = this.model.getBrowser().getUI();
        c.setBounds(c.getBounds());
    }

    void enableSliders(boolean enable) {
        if (this.model.isPlayingMovie()) {
            switch (this.controller.getMoviePlayer().getMovieIndex()) {
                case 300: {
                    this.controlPane.enableZSliders(false);
                    this.controlPane.enableTSliders(true);
                    break;
                }
                case 301: {
                    this.controlPane.enableZSliders(true);
                    this.controlPane.enableTSliders(false);
                    break;
                }
                case 302: {
                    this.controlPane.enableSliders(false);
                }
            }
        } else {
            this.controlPane.enableSliders(enable);
        }
    }

    void setChannelActive(int index, int uiIndex) {
        this.controlPane.setChannelActive(index, uiIndex);
    }

    List getActiveChannelsInGrid() {
        return this.controlPane.getActiveChannelsInGrid();
    }

    void addHistoryItem(HistoryItem node) {
        if (!this.isHistoryShown() || this.historyUI == null) {
            return;
        }
        this.historyUI.addHistoryItem(node);
    }

    boolean isRendererShown() {
        switch (this.displayMode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean isHistoryShown() {
        switch (this.displayMode) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    Dimension geRestoreSize() {
        return this.restoreSize;
    }

    void showHistory(boolean b) {
        boolean rnd = this.isRendererShown();
        this.displayMode = b ? (rnd ? 3 : 1) : (rnd ? 2 : 0);
        this.historyItem.setSelected(this.isHistoryShown());
        this.toolBar.displayHistory();
        this.layoutComponents(false);
    }

    void showRenderer(boolean fromPreferences, int index) {
        boolean show = !this.isRendererShown();
        boolean b = this.isHistoryShown();
        this.displayMode = show ? (b ? 3 : 2) : (b ? 1 : 0);
        this.metadataItem.setSelected(this.isRendererShown());
        this.rndItem.setSelected(this.isRendererShown());
        this.toolBar.displayRenderer();
        this.layoutComponents(fromPreferences);
        if (show) {
            int v = 2;
            if (index == 4) {
                v = 0;
            }
            this.model.getMetadataViewer().setSelectedTab(v);
        }
    }

    void setCompressionLevel(int compressionLevel) {
        int oldCompression = this.convertCompressionLevel();
        switch (compressionLevel) {
            case 0: {
                this.model.setCompressionLevel(0);
                if (this.lens == null) break;
                this.lens.resetDataBuffered();
                break;
            }
            case 1: {
                if (this.lens != null && oldCompression == 0) {
                    this.lens.resetDataBuffered();
                }
                this.model.setCompressionLevel(1);
                break;
            }
            case 2: {
                if (this.lens != null && oldCompression == 0) {
                    this.lens.resetDataBuffered();
                }
                this.model.setCompressionLevel(2);
            }
        }
    }

    int convertCompressionLevel() {
        return this.convertCompressionLevel(this.model.getCompressionLevel());
    }

    int convertCompressionLevel(int level) {
        switch (level) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    int getUICompressionLevel() {
        return this.toolBar.getUICompressionLevel();
    }

    boolean isImageCompressed() {
        return this.model.isImageCompressed();
    }

    Color getBackgroundColor() {
        Enumeration<AbstractButton> e = this.bgColorGroup.getElements();
        while (e.hasMoreElements()) {
            ColorCheckBoxMenuItem b = (ColorCheckBoxMenuItem)e.nextElement();
            if (!b.isSelected()) continue;
            return b.getColor();
        }
        return null;
    }

    int getScaleBarIndex() {
        if (this.scaleBarGroup == null) {
            return -1;
        }
        Enumeration<AbstractButton> e = this.scaleBarGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.nextElement();
            if (!item.isSelected()) continue;
            return ((UnitBarSizeAction)item.getAction()).getIndex();
        }
        return -1;
    }

    void showUsersList() {
        if (this.usersMenu == null) {
            this.usersMenu = new UsersPopupMenu(this.model);
            this.usersMenu.addPropertyChangeListener(this.controller);
        }
        this.usersMenu.show(this.source, this.location.x, this.location.y);
        this.source = null;
        this.location = null;
    }

    void setLocationAndSource(Component source, Point location) {
        this.source = source;
        this.location = location;
    }

    void setGridMagnificationFactor(double factor) {
        if (this.model.getTabbedIndex() == 1) {
            this.setMagnificationStatus(factor);
        }
        int zoomIndex = ZoomGridAction.getIndex(factor);
        Enumeration<AbstractButton> e = this.zoomingGridGroup.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem b = (JCheckBoxMenuItem)e.nextElement();
            Action a = b.getAction();
            if (!(a instanceof ZoomGridAction)) continue;
            b.removeActionListener(a);
            b.setSelected(((ZoomGridAction)a).getIndex() == zoomIndex);
            b.setAction(a);
        }
        this.controlPane.setGridMagnificationFactor((int)(factor * 10.0));
    }

    void showView(int index) {
        switch (index) {
            case 0: {
                this.tabs.insertClosableComponent(this.viewPanel);
                break;
            }
            case 1: {
                this.tabs.insertClosableComponent(this.gridViewPanel);
                break;
            }
            case 2: {
                this.tabs.insertClosableComponent(this.projectionViewPanel);
            }
        }
        this.tabs.validate();
        this.tabs.repaint();
        this.restoreSize = this.tabs.getSize();
    }

    long getPixelsID() {
        return this.model.getPixelsID();
    }

    boolean hasSettingsToPaste() {
        return this.model.hasRndToPaste();
    }

    void enablePasteButton(boolean b) {
        this.toolBar.enablePasteButton(b);
    }

    void showPlaneInfoDetails(PlaneInfoComponent comp) {
        if (comp == null) {
            return;
        }
        TinyDialog d = new TinyDialog((Frame)this, comp.getContent(), 1);
        d.addPropertyChangeListener("closedDialog", this.controller);
        d.pack();
        Point p = new Point(0, 2 * this.statusBar.getPreferredSize().height);
        this.setCloseAfter(true);
        this.showJDialogAsSheet(d, p, 0);
    }

    void hidePlaneInfoDetails() {
        this.hideAnimation();
    }

    int getMaxZ() {
        return this.model.getMaxZ();
    }

    int getTabbedIndex() {
        return this.model.getTabbedIndex();
    }

    int getProjectionStartZ() {
        return this.controlPane.getProjectionStartZ();
    }

    int getProjectionEndZ() {
        return this.controlPane.getProjectionEndZ();
    }

    int getProjectionStepping() {
        return this.controlPane.getProjectionStepping();
    }

    int getProjectionType() {
        return this.controlPane.getProjectionType();
    }

    String getProjectionTypeName() {
        return this.controlPane.getProjectionTypeName();
    }

    void setStatus(boolean busy) {
        this.toolBar.setStatus(busy);
    }

    void clearHistory() {
        if (this.historyUI != null) {
            this.historyUI.clearHistory();
        }
    }

    ProjectionParam getLastProjRef() {
        return this.model.getLastProjRef();
    }

    void createHistoryItem(ProjectionParam ref) {
    }

    void setMeasurementLaunchingStatus(boolean b) {
        ViewerAction a = this.controller.getAction(ImViewerControl.MEASUREMENT_TOOL);
        a.setEnabled(!b);
        this.toolBar.setMeasurementLaunchingStatus(b);
    }

    void setDefaultScaleBarMenu(int index) {
        this.defaultIndex = index;
    }

    void createGridImage(boolean busy) {
        this.controlPane.createGridImage(busy);
    }

    boolean isSourceDisplayed(Object source) {
        return this.controlPane.isSourceDisplayed(source);
    }

    boolean isSeparateWindow() {
        return this.model.isSeparateWindow();
    }

    void buildOverlays() {
        this.controlPane.buildOverlays();
    }

    void renderOverlays(int index, boolean selected) {
        this.controlPane.renderOverlays(index, selected);
    }

    boolean isOverlayActive() {
        return this.controlPane.isOverlayActive();
    }

    Map<Long, Integer> getSelectedOverlays() {
        return this.controlPane.getSelectedOverlays();
    }

    void onColorModelChanged() {
        this.controlPane.onColorModelChanged();
    }

    boolean isBigImage() {
        return this.model.isBigImage();
    }

    JComponent asComponent() {
        if (this.component != null) {
            return this.component;
        }
        this.component = new JPanel();
        this.component.setLayout(new BorderLayout(0, 0));
        this.component.add((Component)this.toolBar, "North");
        this.component.add((Component)this.mainComponent, "Center");
        return this.component;
    }

    void rebuild() {
        if (this.component == null) {
            return;
        }
        this.component.add((Component)this.statusBar, "South");
        Container c = this.getContentPane();
        this.toolBar.setSeparateWindow();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)this.component, "Center");
    }

    @Override
    public void setOnScreen() {
        if (this.model != null) {
            Browser browser = this.model.getBrowser();
            Rectangle r = null;
            if (browser != null) {
                JComponent comp = browser.getUI();
                Dimension size = comp.getPreferredSize();
                int w = size.width;
                int h = size.height;
                ViewerPreferences pref = ImViewerFactory.getPreferences();
                if (pref != null) {
                    r = pref.getViewerBounds();
                    w = r.width;
                    h = r.height;
                    if (w <= 0) {
                        w = size.width;
                    }
                    if (h <= 0) {
                        h = size.height;
                    }
                }
                if (pref != null) {
                    this.setBounds(r.x, r.y, w, h);
                    this.setVisible(true);
                } else {
                    this.packWindow();
                }
            } else {
                this.packWindow();
            }
            UIUtilities.incrementRelativeToAndShow(this.model.getRequesterBounds(), this);
        } else {
            this.packWindow();
            UIUtilities.incrementRelativeToAndShow(null, this);
        }
    }

    static {
        backgrounds.put(ImagePaintingFactory.DEFAULT_BACKGROUND, "Default background");
        backgrounds.put(Color.WHITE, "White");
        backgrounds.put(Color.BLACK, "Black");
        backgrounds.put(Color.GRAY, "Grey");
        backgrounds.put(Color.LIGHT_GRAY, "Light Grey");
    }
}

