/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class StatusBar
extends JPanel {
    private JLabel leftStatus;
    private JLabel rigthStatus;
    private JComponent centerStatus;
    private JButton statusButton;
    private ImViewerModel model;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.statusButton = new JButton(icons.getIcon(0));
        this.statusButton.setToolTipText("Load the planes information.");
        this.statusButton.setContentAreaFilled(false);
        this.statusButton.setBorder(null);
        this.statusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusBar.this.model.firePlaneInfoRetrieval();
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.statusButton);
        this.leftStatus = new JLabel();
        this.rigthStatus = new JLabel();
        this.centerStatus = new JPanel();
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.statusButton);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.leftStatus);
        this.add(Box.createHorizontalStrut(15));
        this.add(this.centerStatus);
        this.add(UIUtilities.buildComponentPanelRight(this.rigthStatus));
        this.add(Box.createRigidArea(new Dimension(20, 5)));
    }

    StatusBar(ImViewerModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildUI();
    }

    void setLeftStatus(String s) {
        this.leftStatus.setText(s);
    }

    void setRigthStatus(String s) {
        this.rigthStatus.setText(s);
    }

    void setCenterStatus(JComponent comp) {
        this.centerStatus.removeAll();
        if (comp != null) {
            this.centerStatus.add(comp);
            this.revalidate();
            this.repaint();
        }
    }
}

