/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;

public class FileMap {
    private static final FileMap singleton = new FileMap();
    private JFileChooser chooser;

    private FileMap() {
        Registry reg = MeasurementAgent.getRegistry();
        Environment env = (Environment)reg.lookup("/env");
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(env.getOmeroHome()));
    }

    private static IXMLElement findServer(String server, IXMLElement parent) {
        ArrayList<IXMLElement> servers = parent.getChildrenNamed("server");
        for (IXMLElement node : servers) {
            if (!node.getAttribute("name", "").equals(server)) continue;
            return node;
        }
        return null;
    }

    private static IXMLElement findUser(String user, IXMLElement parent) {
        ArrayList<IXMLElement> users = parent.getChildrenNamed("user");
        for (IXMLElement node : users) {
            if (!node.getAttribute("name", "").equals(user)) continue;
            return node;
        }
        return null;
    }

    private static IXMLElement findPixelID(Long pixelsID, IXMLElement parent) {
        ArrayList<IXMLElement> pixels = parent.getChildrenNamed("pixelsid");
        for (IXMLElement node : pixels) {
            if ((long)node.getAttribute("id", -1) != pixelsID) continue;
            return node;
        }
        return null;
    }

    private static void saveNode(IXMLElement fileMap, String server, String user, Long pixelsID, String fileName) {
        IXMLElement pixelsNode;
        IXMLElement userNode;
        IXMLElement serverNode = FileMap.findServer(server, fileMap);
        if (serverNode == null) {
            serverNode = FileMap.createServerNode(server);
            fileMap.addChild(serverNode);
        }
        if ((userNode = FileMap.findUser(user, serverNode)) == null) {
            userNode = FileMap.createUserNode(user);
            serverNode.addChild(userNode);
        }
        if ((pixelsNode = FileMap.findPixelID(pixelsID, userNode)) == null) {
            pixelsNode = FileMap.createPixelsNode(pixelsID);
            userNode.addChild(pixelsNode);
        }
        if (pixelsNode.getChildrenCount() != 0) {
            for (int i = pixelsNode.getChildrenCount() - 1; i >= 0; --i) {
                pixelsNode.removeChildAtIndex(i);
            }
        }
        IXMLElement fileNode = FileMap.createFileNode(fileName);
        pixelsNode.addChild(fileNode);
    }

    private static IXMLElement createServerNode(String server) {
        XMLElement element = new XMLElement("server");
        element.setAttribute("name", server);
        return element;
    }

    private static IXMLElement createUserNode(String user) {
        XMLElement element = new XMLElement("user");
        element.setAttribute("name", user);
        return element;
    }

    private static IXMLElement createPixelsNode(Long pixels) {
        if (pixels == null) {
            return null;
        }
        XMLElement element = new XMLElement("pixelsid");
        element.setAttribute("id", pixels.toString());
        return element;
    }

    private static IXMLElement createFileNode(String fileName) {
        XMLElement element = new XMLElement("file");
        element.setAttribute("filename", fileName);
        return element;
    }

    private static void saveFileMap(IXMLElement fileMap) throws ParsingException {
        BufferedOutputStream out;
        try {
            out = new BufferedOutputStream(new FileOutputStream(FileMap.createFileMap()));
        }
        catch (Exception ex) {
            ParsingException e = new ParsingException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        try {
            new XMLWriter(out).write(fileMap);
        }
        catch (Exception e) {
            new ParsingException(e.getMessage());
        }
    }

    public static IXMLElement getFileMap() throws ParsingException {
        IXMLElement document;
        IXMLParser parser;
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(FileMap.createFileMap()));
            StdXMLReader reader = new StdXMLReader(in);
            parser.setReader(reader);
            document = (IXMLElement)parser.parse();
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            ParsingException e = new ParsingException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        return document;
    }

    public static boolean fileMapExists() {
        Registry reg = MeasurementAgent.getRegistry();
        Environment env = (Environment)reg.lookup("/env");
        String fileName = (String)reg.lookup("/roi/mainFileName");
        String directory = env.getOmeroHome();
        File[] list = FileMap.singleton.chooser.getCurrentDirectory().listFiles();
        String path = directory + File.separator + fileName;
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            File f = list[i];
            if (!f.getAbsolutePath().equals(path)) continue;
            return true;
        }
        return false;
    }

    private static File createFileMap() {
        Registry reg = MeasurementAgent.getRegistry();
        Environment env = (Environment)reg.lookup("/env");
        String fileName = (String)reg.lookup("/roi/mainFileName");
        return new File(env.getOmeroHome(), fileName);
    }

    public static String getSavedFile(String server, String user, Long pixelsID) throws ParsingException {
        if (!FileMap.fileMapExists()) {
            return null;
        }
        IXMLElement fileMap = FileMap.getFileMap();
        IXMLElement node = FileMap.findServer(server, fileMap);
        if (node == null) {
            return null;
        }
        if ((node = FileMap.findUser(user, node)) == null) {
            return null;
        }
        if ((node = FileMap.findPixelID(pixelsID, node)) == null) {
            return null;
        }
        if (node.getChildrenCount() == 0) {
            return null;
        }
        String fileName = (node = node.getFirstChildNamed("file")).getAttribute("filename", "");
        if (fileName == null) {
            return null;
        }
        if (fileName.equals("")) {
            return null;
        }
        return fileName;
    }

    public static void setSavedFile(String server, String user, long pixelsID, String fileName) throws ParsingException {
        IXMLElement fileMap;
        if (FileMap.fileMapExists()) {
            fileMap = FileMap.getFileMap();
        } else {
            fileMap = new XMLElement("pixelset", "http://www.openmicroscopy.org.uk");
            fileMap.setAttribute("version", "1.0");
        }
        FileMap.saveNode(fileMap, server, user, pixelsID, fileName);
        FileMap.saveFileMap(fileMap);
    }
}

