/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationField;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITreeNode;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROITreeTableModel
extends OMETreeTableModel {
    private List<AnnotationField> fields;
    private Map<AnnotationKey, Integer> keyMap = new HashMap<AnnotationKey, Integer>();

    public void setFields(List<AnnotationField> newFields) {
        this.fields = newFields;
        this.updateKeyMap();
    }

    public ROITreeTableModel(ROITreeNode node, Vector<String> columns, List<AnnotationField> fields) {
        super(node, columns);
        this.fields = fields;
        this.updateKeyMap();
    }

    private void updateKeyMap() {
        this.keyMap.clear();
        for (int i = 0; i < this.fields.size(); ++i) {
            this.keyMap.put(this.fields.get(i).getKey(), i);
        }
    }

    public void nodeUpdated(ROITreeNode node) {
        Object[] objects = new Object[]{this.getRoot(), node.getParent()};
        TreePath path = new TreePath(objects);
        this.modelSupport.fireChildChanged(path, node.getParent().getIndex((TreeNode)((Object)node)), (Object)node);
    }

    public void setValueAt(Object value, Object nodeObject, int column) {
        if (nodeObject instanceof ROITreeNode) {
            ROITreeNode node = (ROITreeNode)((Object)nodeObject);
            Object object = node.getUserObject();
            AnnotationField objectField = this.fields.get(column - 1);
            if (object instanceof ROI) {
                ROI roi = (ROI)object;
                roi.setAnnotation(objectField.getKey(), value);
            } else if (object instanceof ROIShape) {
                ROIShape shape = (ROIShape)object;
                shape.setAnnotation(objectField.getKey(), value);
            }
            this.nodeUpdated(node);
        }
    }

    @Override
    public Object getValueAt(Object nodeObject, int column) {
        if (nodeObject instanceof ROITreeNode) {
            ROITreeNode ROITreeNode2 = (ROITreeNode)((Object)nodeObject);
            Object object = ROITreeNode2.getUserObject();
            if (column == 0) {
                return object;
            }
            AnnotationField objectField = this.fields.get(column - 1);
            if (object instanceof ROI) {
                ROI roi = (ROI)object;
                return roi.getAnnotation(objectField.getKey());
            }
            if (object instanceof ROIShape) {
                ROIShape shape = (ROIShape)object;
                return shape.getAnnotation(objectField.getKey());
            }
        }
        return null;
    }

    public int getKeyColumn(AnnotationKey key) {
        return this.keyMap.get(key) + 1;
    }

    public boolean isCellEditable(Object node, int column) {
        return this.fields.get(column - 1).isEditable();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return ROINode.class;
            }
        }
        return this.fields.get(column - 1).getClass();
    }

    public boolean isShapeColumn(int modelIndex) {
        return this.fields.get(modelIndex - 1).getName().equals("Type");
    }
}

