/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.ChannelSummaryModel;
import org.openmicroscopy.shoola.agents.measurement.util.ChannelSummaryTable;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.ChannelSelectionForm;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityModel;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityValuesDialog;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntensityView
extends JPanel
implements ActionListener,
TabPaneInterface,
ChangeListener {
    public static final int INDEX = 4;
    public static final int TEXT_WIDTH = 100;
    public static final int TEXT_HEIGHT = 26;
    public static final int LABEL_WIDTH = 60;
    public static final int LABEL_HEIGHT = 26;
    private Dimension intensityTableSize = new Dimension(300, 300);
    private State state = State.READY;
    private static final String NAME = "Intensity View";
    private static final int SAVE_ACTION = 0;
    private static final int SHOW_TABLE_ACTION = 1;
    private static final int CHANNEL_SELECTION = 2;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private ChannelSelectionForm channelsSelectionForm;
    private Map ROIStats;
    private ChannelSummaryTable channelSummaryTable;
    private ChannelSummaryModel channelSummaryModel;
    private int selectedChannel = -1;
    private String selectedChannelName;
    private JComboBox channelSelection;
    private JButton saveButton;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private Map<Integer, String> channelName = new TreeMap<Integer, String>();
    private Map<Integer, Color> channelColour = new TreeMap<Integer, Color>();
    private Map<Integer, Double> channelSum = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMin = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMax = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMean = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
    private Map<String, Integer> nameMap = new LinkedHashMap<String, Integer>();
    private TreeMap<Coord3D, Map<AnalysisStatsWrapper.StatsType, Map>> shapeStatsList;
    private TreeMap<Coord3D, Map<Integer, Map<Point, Double>>> pixelStats;
    private TreeMap<Coord3D, Map<Integer, Double>> minStats;
    private TreeMap<Coord3D, Map<Integer, Double>> maxStats;
    private TreeMap<Coord3D, Map<Integer, Double>> meanStats;
    private TreeMap<Coord3D, Map<Integer, Double>> stdDevStats;
    private TreeMap<Coord3D, Map<Integer, Double>> sumStats;
    private TreeMap<Coord3D, ROIShape> shapeMap;
    private Coord3D coord;
    private JButton showIntensityTable;
    private ROIShape shape;
    private IntensityValuesDialog intensityDialog;
    private IntensityModel tableModel;

    private void handleSliderReleased() {
        this.stateChanged(null);
    }

    private void initTableModel() {
        Double[][] summaryData = new Double[1][1];
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        rowNames.add("");
        columnNames.add("");
        this.channelSummaryModel = new ChannelSummaryModel(rowNames, columnNames, summaryData);
    }

    private void initComponents() {
        Double[][] data = new Double[1][1];
        this.tableModel = new IntensityModel(data);
        this.initTableModel();
        this.channelSummaryTable = new ChannelSummaryTable(this.channelSummaryModel);
        this.showIntensityTable = new JButton("Intensity Values");
        this.showIntensityTable.setEnabled(false);
        this.showIntensityTable.addActionListener(this);
        this.showIntensityTable.setActionCommand("1");
        this.channelSelection = new JComboBox();
        this.channelSelection.setEnabled(false);
        this.channelSelection.setVisible(false);
        this.channelSelection.addActionListener(this);
        this.channelSelection.setActionCommand("2");
        this.saveButton = new JButton("Export to Excel");
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.saveButton.setEnabled(false);
        this.state = State.READY;
        this.zSlider = new OneKnobSlider();
        this.zSlider.setOrientation(1);
        this.zSlider.setPaintTicks(false);
        this.zSlider.setPaintLabels(false);
        this.zSlider.setMajorTickSpacing(1);
        this.zSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                IntensityView.this.handleSliderReleased();
            }
        });
        this.zSlider.setShowArrows(true);
        this.zSlider.setVisible(false);
        this.zSlider.setEndLabel("Z");
        this.zSlider.setShowEndLabel(true);
        this.tSlider = new OneKnobSlider();
        this.tSlider.setPaintTicks(false);
        this.tSlider.setPaintLabels(false);
        this.tSlider.setMajorTickSpacing(1);
        this.tSlider.setSnapToTicks(true);
        this.tSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                IntensityView.this.handleSliderReleased();
            }
        });
        this.tSlider.setShowArrows(true);
        this.tSlider.setVisible(false);
        this.tSlider.setEndLabel("T");
        this.tSlider.setShowEndLabel(true);
    }

    private void buildGUI() {
        JPanel scrollPanel = new JPanel();
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 0));
        JPanel tPanel = this.tablePanel();
        containerPanel.add(this.zSlider);
        containerPanel.add(tPanel);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        cPanel.add(containerPanel);
        cPanel.add(this.tSlider);
        JPanel buttonPanel = this.createButtonPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 0));
        scrollPanel.add(cPanel);
        scrollPanel.add(buttonPanel);
        scrollPanel.add(Box.createGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.intensityDialog = new IntensityValuesDialog(this.tableModel);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel channelPanel = UIUtilities.buildComponentPanel(this.channelSelection);
        panel.add(channelPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel intensityPanel = UIUtilities.buildComponentPanel(this.showIntensityTable);
        UIUtilities.setDefaultSize(intensityPanel, new Dimension(175, 32));
        panel.add(intensityPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel savePanel = UIUtilities.buildComponentPanel(this.saveButton);
        UIUtilities.setDefaultSize(savePanel, new Dimension(175, 32));
        panel.add(savePanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel tablePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JScrollPane scrollPane = new JScrollPane(this.channelSummaryTable);
        scrollPane.setVerticalScrollBar(scrollPane.createVerticalScrollBar());
        scrollPane.setHorizontalScrollBar(scrollPane.createHorizontalScrollBar());
        panel.add(scrollPane);
        return panel;
    }

    private void clearMaps() {
        if (this.shapeStatsList != null) {
            this.shapeStatsList.clear();
        }
        this.shapeStatsList = null;
        if (this.pixelStats != null) {
            this.pixelStats.clear();
        }
        this.pixelStats = null;
        if (this.shapeMap != null) {
            this.shapeMap.clear();
        }
        this.shapeMap = null;
        if (this.maxStats != null) {
            this.maxStats.clear();
        }
        this.maxStats = null;
        if (this.meanStats != null) {
            this.meanStats.clear();
        }
        this.meanStats = null;
        if (this.minStats != null) {
            this.minStats.clear();
        }
        this.minStats = null;
        if (this.sumStats != null) {
            this.sumStats.clear();
        }
        this.sumStats = null;
        if (this.stdDevStats != null) {
            this.stdDevStats.clear();
        }
        this.stdDevStats = null;
    }

    private void clearAllValues() {
        this.channelSelection.removeAllItems();
    }

    private void createComboBox() {
        Object[][] channelCols = new Object[this.channelName.size()][2];
        List<ChannelData> metadata = this.model.getMetadata();
        Iterator<ChannelData> i = metadata.iterator();
        int index = 0;
        while (i.hasNext()) {
            ChannelData channelData = i.next();
            int channel = channelData.getIndex();
            if (!this.channelName.containsKey(channel)) continue;
            channelCols[index] = new Object[]{this.channelColour.get(channel), this.channelName.get(channel)};
            ++index;
        }
        this.channelSelection.setModel(new DefaultComboBoxModel((E[])channelCols));
        this.channelSelection.setRenderer(new ColorListRenderer());
        this.selectedChannel = this.selectedChannelName != null ? (this.nameMap.containsKey(this.selectedChannelName) ? this.nameMap.get(this.selectedChannelName) : 0) : 0;
        if (this.selectedChannel >= this.channelSelection.getItemCount() || this.selectedChannel < 0) {
            return;
        }
        this.channelSelection.setSelectedIndex(this.selectedChannel);
        this.channelSelection.setEnabled(true);
    }

    private void populateData(Coord3D coord, int channel) {
        this.channelSummaryTable.setVisible(true);
        this.interpretResults(coord, channel);
        this.populateChannelSummaryTable(coord);
    }

    private void populateChannelSummaryTable(Coord3D coord) {
        ArrayList<String> statNames = new ArrayList<String>();
        ArrayList<String> channelNames = new ArrayList<String>();
        ROIFigure fig = this.shape.getFigure();
        int count = 0;
        statNames.add("Min");
        statNames.add("Max");
        statNames.add("Sum");
        statNames.add("Mean");
        statNames.add("Std Dev.");
        statNames.add("NumPixels");
        if (this.areaFigure(fig)) {
            this.addAreaStats(statNames);
        } else if (this.lineFigure(fig)) {
            this.addLineStats(statNames);
        } else if (this.pointFigure(fig)) {
            this.addPointStats(statNames);
        }
        Iterator<Integer> channelIterator = this.channelName.keySet().iterator();
        while (channelIterator.hasNext()) {
            channelNames.add(this.channelName.get(channelIterator.next()));
        }
        Double[][] data = new Double[this.channelName.size()][statNames.size()];
        channelIterator = this.channelName.keySet().iterator();
        count = 0;
        while (channelIterator.hasNext()) {
            int channel = channelIterator.next();
            this.populateSummaryColumn(fig, data, channel, count);
            ++count;
        }
        this.channelSummaryModel = new ChannelSummaryModel(statNames, channelNames, data);
        this.channelSummaryTable.setModel(this.channelSummaryModel);
    }

    private void populateSummaryColumn(ROIFigure fig, Double[][] data, int channel, int count) {
        data[count][0] = this.channelMin.get(channel);
        data[count][1] = this.channelMax.get(channel);
        data[count][2] = this.channelSum.get(channel);
        data[count][3] = this.channelMean.get(channel);
        data[count][4] = this.channelStdDev.get(channel);
        data[count][5] = fig.getPoints().size();
        if (this.areaFigure(fig)) {
            this.addValuesForAreaFigure(fig, data, channel, count);
        } else if (this.lineFigure(fig)) {
            this.addValuesForLineFigure(fig, data, channel, count);
        } else if (this.pointFigure(fig)) {
            this.addValuesForPointFigure(fig, data, channel, count);
        }
    }

    private void addValuesForAreaFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        data[count][6] = AnnotationKeys.AREA.get(fig.getROIShape());
        data[count][7] = fig.getBounds().getX();
        data[count][8] = fig.getBounds().getY();
        data[count][9] = AnnotationKeys.WIDTH.get(fig.getROIShape());
        data[count][10] = AnnotationKeys.HEIGHT.get(fig.getROIShape());
        data[count][11] = AnnotationKeys.CENTREX.get(fig.getROIShape());
        data[count][12] = AnnotationKeys.CENTREY.get(fig.getROIShape());
    }

    private void addValuesForLineFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        data[count][6] = AnnotationKeys.STARTPOINTX.get(this.shape);
        data[count][7] = AnnotationKeys.STARTPOINTY.get(this.shape);
        data[count][8] = AnnotationKeys.ENDPOINTX.get(this.shape);
        data[count][9] = AnnotationKeys.ENDPOINTY.get(this.shape);
        data[count][10] = AnnotationKeys.CENTREX.get(this.shape);
        data[count][11] = AnnotationKeys.CENTREY.get(this.shape);
    }

    private void addValuesForPointFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        data[count][6] = AnnotationKeys.CENTREX.get(this.shape);
        data[count][7] = AnnotationKeys.CENTREY.get(this.shape);
    }

    private void addAreaStats(List<String> statNames) {
        statNames.add("Area");
        statNames.add("X Coord");
        statNames.add("Y Coord");
        statNames.add("Width");
        statNames.add("Height");
        statNames.add("X Centre");
        statNames.add("Y Centre");
    }

    private void addLineStats(List<String> statNames) {
        statNames.add("X1 Coord");
        statNames.add("Y1 Coord");
        statNames.add("X2 Coord");
        statNames.add("Y2 Coord");
        statNames.add("X Centre");
        statNames.add("Y Centre");
    }

    private void addPointStats(List<String> statNames) {
        statNames.add("X Centre");
        statNames.add("Y Centre");
    }

    private void interpretResults(Coord3D coord, int channel) {
        Map<Point, Double> pixels = this.pixelStats.get(coord).get(channel);
        if (pixels == null) {
            return;
        }
        Iterator<Point> pixelIterator = pixels.keySet().iterator();
        if (!pixelIterator.hasNext()) {
            return;
        }
        Point point2 = pixelIterator.next();
        double minX = point2.getX();
        double maxX = point2.getX();
        double minY = point2.getY();
        double maxY = point2.getY();
        while (pixelIterator.hasNext()) {
            point2 = pixelIterator.next();
            minX = Math.min(minX, point2.getX());
            maxX = Math.max(maxX, point2.getX());
            minY = Math.min(minY, point2.getY());
            maxY = Math.max(maxY, point2.getY());
        }
        int sizeX = (int)(maxX - minX) + 1;
        int sizeY = (int)(maxY - minY + 1.0);
        Double[][] data = new Double[sizeX][sizeY];
        for (Point point2 : pixels.keySet()) {
            int x = (int)(point2.getX() - minX);
            int y = (int)(point2.getY() - minY);
            if (x >= sizeX || y >= sizeY) continue;
            Double value = pixels.containsKey(point2) ? pixels.get(point2) : new Double(0.0);
            data[x][y] = value;
        }
        this.channelMin = this.minStats.get(coord);
        this.channelMax = this.maxStats.get(coord);
        this.channelMean = this.meanStats.get(coord);
        this.channelStdDev = this.stdDevStats.get(coord);
        this.channelSum = this.sumStats.get(coord);
        this.tableModel = new IntensityModel(data);
        this.shape = this.shapeMap.get(coord);
        this.intensityDialog.setModel(this.tableModel);
    }

    private boolean areaFigure(ROIFigure fig) {
        MeasureBezierFigure bFig;
        if (fig instanceof MeasureEllipseFigure || fig instanceof MeasureRectangleFigure) {
            return true;
        }
        return fig instanceof MeasureBezierFigure && (bFig = (MeasureBezierFigure)fig).isClosed();
    }

    private boolean lineFigure(ROIFigure fig) {
        MeasureBezierFigure bFig;
        if (fig instanceof MeasureLineFigure || fig instanceof MeasureLineConnectionFigure) {
            return true;
        }
        return fig instanceof MeasureBezierFigure && !(bFig = (MeasureBezierFigure)fig).isClosed();
    }

    private boolean pointFigure(ROIFigure fig) {
        return fig instanceof MeasurePointFigure;
    }

    private void saveResults() {
        List<Integer> channels;
        this.channelsSelectionForm = new ChannelSelectionForm(this.channelName);
        FileChooser chooser = this.view.createSaveToExcelChooser();
        chooser.addComponentToControls(this.channelsSelectionForm);
        int results = chooser.showDialog();
        if (results != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        if (!file.getAbsolutePath().endsWith("xls")) {
            String fileName = file.getAbsolutePath() + "." + "xls";
            file = new File(fileName);
        }
        if ((channels = this.channelsSelectionForm.getUserSelection()) == null || channels.size() == 0) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Results", " Please select at least a channel.");
            this.view.setStatus("No Channel selected to output.");
            return;
        }
        try {
            BufferedImage originalImage;
            ExcelWriter writer = new ExcelWriter(file.getAbsolutePath());
            writer.openFile();
            writer.createSheet("Channel Summary");
            Iterator<Coord3D> coordMapIterator = this.shapeMap.keySet().iterator();
            int n = channels.size();
            if (this.channelSummarySelected(channels)) {
                this.outputSummary(writer, this.shapeMap);
            }
            if ((originalImage = this.model.getRenderedImage()) != null) {
                BufferedImage image = Factory.copyBufferedImage(originalImage);
                this.model.setAttributes(MeasurementAttributes.SHOWID, true);
                this.model.getDrawingView().print(image.getGraphics());
                this.model.setAttributes(MeasurementAttributes.SHOWID, false);
                try {
                    writer.addImageToWorkbook("ThumbnailImage", image);
                }
                catch (Exception e) {
                    // empty catch block
                }
                int col = writer.getMaxColumn(0);
                writer.writeImage(0, col + 1, 256, 256, "ThumbnailImage");
            }
            if (this.channelSummarySelected(channels) && channels.size() != 1) {
                while (coordMapIterator.hasNext()) {
                    Coord3D currentCoord = coordMapIterator.next();
                    for (int i = 0; i < n; ++i) {
                        Integer channel = channels.get(i);
                        if (channel == ChannelSelectionForm.SUMMARYVALUE || !this.nameMap.containsKey(this.channelName.get(channel))) continue;
                        int rowIndex = 0;
                        writer.createSheet("Channel Number " + this.channelName.get(channel));
                        this.writeHeader(writer, rowIndex, currentCoord);
                        channel = this.nameMap.get(this.channelName.get(channel));
                        this.writeData(writer, rowIndex, currentCoord, channel);
                    }
                }
            }
            writer.close();
        }
        catch (Exception e) {
            Logger logger = MeasurementAgent.getRegistry().getLogger();
            logger.error((Object)this, "Cannot save ROI results: " + e.toString());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            String message = "An error occurred while trying to save the data.\nPlease try again.";
            if (e instanceof NumberFormatException) {
                message = "We only support the British/American style of representing numbers,\nusing a decimal point rather than a comma.";
            }
            un.notifyInfo("Save Results", message);
            return;
        }
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
    }

    private void printSummaryHeader(ExcelWriter writer, int rowIndex) {
        writer.writeElement(rowIndex, 0, "channel");
        writer.writeElement(rowIndex, 1, "zsection");
        writer.writeElement(rowIndex, 2, "time");
        for (int y = 0; y < this.channelSummaryTable.getRowCount(); ++y) {
            writer.writeElement(rowIndex, 3 + y, this.channelSummaryTable.getValueAt(y, 0));
        }
    }

    private void outputSummary(ExcelWriter writer, TreeMap<Coord3D, ROIShape> shapeMap) {
        int rowIndex = 0;
        this.printSummaryHeader(writer, rowIndex);
        ++rowIndex;
        Coord3D start = shapeMap.firstKey();
        Coord3D end = shapeMap.lastKey();
        ArrayList<Integer> channels = new ArrayList<Integer>(this.channelName.keySet());
        for (Integer c : channels) {
            for (int z = start.getZSection(); z <= end.getZSection(); ++z) {
                for (int t = start.getTimePoint(); t <= end.getTimePoint(); ++t) {
                    Coord3D coord = new Coord3D(z, t);
                    this.populateData(coord, c);
                    this.outputSummaryRow(writer, rowIndex, c, z, t);
                    ++rowIndex;
                }
            }
        }
    }

    private void outputSummaryRow(ExcelWriter writer, int rowIndex, Integer channel, int z, int t) {
        writer.writeElement(rowIndex, 0, this.channelName.get(channel));
        writer.writeElement(rowIndex, 1, z + "");
        writer.writeElement(rowIndex, 2, t + "");
        for (int y = 0; y < this.channelSummaryTable.getRowCount(); ++y) {
            int col = this.getColumn(this.channelName.get(channel));
            if (col == -1) continue;
            String v = (String)this.channelSummaryTable.getValueAt(y, col);
            if (v.contains(".") && v.contains(",")) {
                v = v.replace(".", "");
                v = v.replace(",", ".");
            }
            writer.writeElement(rowIndex, 3 + y, new Double(v));
        }
    }

    private int getColumn(String name) {
        for (int i = 0; i < this.channelSummaryModel.getColumnCount(); ++i) {
            if (!this.channelSummaryModel.getColumnName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean channelSummarySelected(List<Integer> selection) {
        for (Integer value : selection) {
            if (value != ChannelSelectionForm.SUMMARYVALUE) continue;
            return true;
        }
        return false;
    }

    private void writeHeader(ExcelWriter writer, int rowIndex, Coord3D currentCoord) {
        writer.writeElement(rowIndex, 0, "Image ");
        writer.writeElement(rowIndex, 1, this.model.getImageName());
        writer.writeElement(++rowIndex, 0, "Z ");
        writer.writeElement(rowIndex, 1, currentCoord.getZSection() + 1);
        writer.writeElement(++rowIndex, 0, "T ");
        writer.writeElement(rowIndex, 1, currentCoord.getTimePoint() + 1);
        ++rowIndex;
    }

    private void writeData(ExcelWriter writer, int rowIndex, Coord3D coord, int channel) {
        this.populateData(coord, channel);
        writer.writeTableToSheet(rowIndex, 0, this.tableModel);
    }

    private void showIntensityResults() {
        UIUtilities.setLocationRelativeToAndSizeToWindow(this, (Component)this.intensityDialog, this.intensityTableSize);
    }

    IntensityView(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.selectedChannelName = "";
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(27);
    }

    void onFigureRemoved() {
        this.channelSelection.setEnabled(false);
        this.showIntensityTable.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.channelSelection.setVisible(false);
        this.channelSummaryTable.setVisible(false);
    }

    void displayAnalysisResults() {
        List<String> names;
        if (this.state == State.ANALYSING) {
            return;
        }
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            return;
        }
        this.state = State.ANALYSING;
        this.channelSelection.setVisible(true);
        this.clearMaps();
        this.shapeStatsList = new TreeMap(new Coord3D());
        this.pixelStats = new TreeMap(new Coord3D());
        this.shapeMap = new TreeMap(new Coord3D());
        this.minStats = new TreeMap(new Coord3D());
        this.maxStats = new TreeMap(new Coord3D());
        this.meanStats = new TreeMap(new Coord3D());
        this.sumStats = new TreeMap(new Coord3D());
        this.stdDevStats = new TreeMap(new Coord3D());
        Iterator j = this.ROIStats.entrySet().iterator();
        this.channelName = new TreeMap<Integer, String>();
        this.nameMap = new LinkedHashMap<String, Integer>();
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minT = Integer.MAX_VALUE;
        int maxT = Integer.MIN_VALUE;
        this.clearAllValues();
        List<ChannelData> metadata = this.model.getMetadata();
        while (j.hasNext()) {
            Map.Entry entry = j.next();
            this.shape = (ROIShape)entry.getKey();
            Coord3D c3D = this.shape.getCoord3D();
            minT = Math.min(minT, c3D.getTimePoint());
            maxT = Math.max(maxT, c3D.getTimePoint());
            minZ = Math.min(minZ, c3D.getZSection());
            maxZ = Math.max(maxZ, c3D.getZSection());
            this.shapeMap.put(c3D, this.shape);
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                this.state = State.READY;
                return;
            }
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)entry.getValue());
            this.shapeStatsList.put(c3D, shapeStats);
            this.minStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MIN));
            this.maxStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MAX));
            this.meanStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MEAN));
            this.sumStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.SUM));
            this.stdDevStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.STDDEV));
            this.pixelStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.PIXEL_PLANEPOINT2D));
            this.channelName.clear();
            this.nameMap.clear();
            this.channelColour.clear();
            Iterator<ChannelData> i = metadata.iterator();
            names = new ArrayList<String>();
            while (i.hasNext()) {
                ChannelData channelData = i.next();
                int channel = channelData.getIndex();
                if (!this.model.isChannelActive(channel)) continue;
                String name = channelData.getChannelLabeling();
                if (names.contains(name)) {
                    name = name + " " + channel;
                }
                this.channelName.put(channel, name);
                this.nameMap.put(this.channelName.get(channel), channel);
                this.channelColour.put(channel, (Color)this.model.getActiveChannels().get(channel));
            }
        }
        if (this.channelName.size() != this.channelColour.size() || this.nameMap.size() == 0) {
            this.createComboBox();
            names = this.channelSummaryModel.getRowNames();
            ArrayList<String> channelNames = new ArrayList<String>();
            Double[][] data = new Double[this.channelName.size()][names.size()];
            this.channelSummaryModel = new ChannelSummaryModel(names, channelNames, data);
            this.channelSummaryTable.setModel(this.channelSummaryModel);
            this.saveButton.setEnabled(false);
            this.showIntensityTable.setEnabled(false);
            if (this.intensityDialog != null) {
                this.intensityDialog.setVisible(false);
            }
            this.state = State.READY;
            return;
        }
        this.saveButton.setEnabled(true);
        this.showIntensityTable.setEnabled(true);
        ++maxZ;
        ++minZ;
        ++maxT;
        ++minT;
        this.createComboBox();
        Object[] nameColour = (Object[])this.channelSelection.getSelectedItem();
        String string = (String)nameColour[1];
        this.selectedChannel = this.nameMap.get(string);
        this.zSlider.setMaximum(maxZ);
        this.zSlider.setMinimum(minZ);
        this.tSlider.setMaximum(maxT);
        this.tSlider.setMinimum(minT);
        this.zSlider.setVisible(maxZ != minZ);
        this.tSlider.setVisible(maxT != minT);
        this.tSlider.setValue(this.model.getCurrentView().getTimePoint() + 1);
        this.zSlider.setValue(this.model.getCurrentView().getZSection() + 1);
        this.coord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        this.shape = this.shapeMap.get(this.coord);
        this.populateData(this.coord, this.selectedChannel);
        this.saveButton.setEnabled(this.tableModel.getRowCount() > 0);
        this.state = State.READY;
    }

    void onFigureSelected() {
        Set<Figure> selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (selectedFigures == null || selectedFigures.size() == 0) {
            int row = this.tableModel.getRowCount();
            this.showIntensityTable.setEnabled(row > 0);
            this.channelSelection.setEnabled(row > 0);
        } else {
            int size = 0;
            size = this.channelSelection.getModel().getSize();
            this.channelSelection.setEnabled(size > 0);
            this.showIntensityTable.setEnabled(size > 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.state == State.ANALYSING) {
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 2: {
                JComboBox cb = (JComboBox)e.getSource();
                Object[] nameColour = (Object[])cb.getSelectedItem();
                String string = (String)nameColour[1];
                if (!this.nameMap.containsKey(string)) {
                    return;
                }
                this.selectedChannelName = string;
                int channel = this.nameMap.get(string);
                if (channel == -1) break;
                Coord3D newCoord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
                this.populateData(newCoord, channel);
                this.repaint();
                break;
            }
            case 0: {
                this.saveResults();
                break;
            }
            case 1: {
                this.showIntensityResults();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.zSlider == null || this.tSlider == null || this.coord == null || this.state != State.READY) {
            return;
        }
        Coord3D thisCoord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        if (this.coord.equals(thisCoord)) {
            return;
        }
        if (!this.pixelStats.containsKey(thisCoord)) {
            return;
        }
        Object[] nameColour = (Object[])this.channelSelection.getSelectedItem();
        String string = (String)nameColour[1];
        if (!this.nameMap.containsKey(string)) {
            this.state = State.READY;
            return;
        }
        this.selectedChannelName = string;
        int channel = this.nameMap.get(string);
        if (channel == -1) {
            return;
        }
        if (!this.pixelStats.get(thisCoord).containsKey(channel)) {
            return;
        }
        this.state = State.ANALYSING;
        this.populateData(thisCoord, channel);
        this.repaint();
        if (this.shape != null) {
            this.view.selectFigure(this.shape.getFigure());
        }
        this.state = State.READY;
    }

    @Override
    public int getIndex() {
        return 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ANALYSING,
        READY;

    }
}

