/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ROIData;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerComponent
extends AbstractComponent
implements MeasurementViewer {
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;

    private void postEvent(int index) {
        MeasurementToolLoaded response = new MeasurementToolLoaded(MeasurementViewerFactory.getRequest(this.model.getPixelsID()), this.model.getDrawingView(), index);
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        bus.post(response);
    }

    private FileChooser createChooserDialog(int type) {
        String word = "Save ";
        if (type == 0) {
            word = "Load ";
        }
        String title = word + "the ROI File";
        String text = word + "the ROI data in the file associate with the image.";
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(new XMLFilter());
        FileChooser chooser = new FileChooser(this.view, type, title, text, filters, false, true);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String s = FileMap.getSavedFile(this.model.getServerName(), this.model.getUserName(), this.model.getPixelsID());
            if (s != null) {
                File savedFile = new File(s);
                chooser.setCurrentDirectory(savedFile);
                chooser.setSelectedFile(savedFile);
            } else if (type == 1) {
                s = this.model.getImageName();
                File savedFile = new File(s);
                chooser.setSelectedFile(savedFile.getName());
            }
        }
        catch (ParsingException e) {
            // empty catch block
        }
        return chooser;
    }

    MeasurementViewerComponent(MeasurementViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MeasurementViewerControl();
        this.view = new MeasurementViewerUI(model.getImageTitle());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this, this.controller, this.model);
    }

    MeasurementViewerModel getModel() {
        return this.model;
    }

    void saveAndDiscard() {
        this.model.saveROIToServer(false);
        this.model.saveWorkflowToServer(false);
        this.discard();
    }

    void onROIDeleted(long imageID) {
        this.model.onROIDeleted(imageID);
    }

    @Override
    public void activate() {
        this.activate(this.model.getMeasurements(), this.model.isHCSData());
    }

    @Override
    public void activate(List<FileAnnotationData> measurements, boolean HCSData) {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                double f = this.model.getMagnification();
                Dimension d = new Dimension((int)((double)this.model.getSizeX() * f), (int)((double)this.model.getSizeY() * f));
                UIUtilities.setDefaultSize(this.model.getDrawingView(), d);
                this.model.getDrawingView().setSize(d);
                this.model.setHCSData(HCSData);
                if (HCSData) {
                    if (measurements == null) {
                        this.model.setHCSData(false);
                        this.model.fireLoadWorkflow();
                        this.model.fireLoadROIServerOrClient(false);
                        break;
                    }
                    this.model.fireLoadROIFromServer(measurements);
                    break;
                }
                this.model.fireLoadWorkflow();
                this.model.fireLoadROIServerOrClient(false);
                break;
            }
            case 6: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (!this.view.isVisible()) {
                    this.postEvent(0);
                }
                this.view.deIconify();
                this.view.setVisible(true);
            }
        }
    }

    @Override
    public JFrame getUI() {
        return this.view;
    }

    @Override
    public void discard() {
        if (this.model.getState() != 6) {
            this.view.setVisible(false);
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public void setDataChanged() {
        this.model.notifyDataChanged(true);
        this.firePropertyChange("roiChanged", false, true);
        this.fireStateChange();
    }

    @Override
    public void cancel() {
        this.model.cancel();
        this.view.setReadyStatus();
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setROI(InputStream input) {
        block11: {
            if (this.model.getState() != 3) {
                return;
            }
            if (input == null) {
                try {
                    this.model.setROI(input);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.view.rebuildManagerTable();
                this.view.updateDrawingArea();
                this.view.setReadyStatus();
                this.fireStateChange();
                this.postEvent(0);
                return;
            }
            Registry reg = MeasurementAgent.getRegistry();
            Logger log = reg.getLogger();
            try {
                boolean valid = this.model.setROI(input);
                if (valid) break block11;
                reg.getUserNotifier().notifyInfo("ROI", "The ROI are not compatible with the image.");
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                this.fireStateChange();
                return;
            }
            catch (Exception e) {
                if (e instanceof ParsingException) {
                    log.error((Object)this, "Cannot parse the ROI for " + this.model.getImageID());
                }
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                return;
            }
        }
        this.view.rebuildManagerTable();
        this.view.updateDrawingArea();
        this.view.setReadyStatus();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setMagnifiedPlane(int defaultZ, int defaultT, double magnification) {
        int z = this.model.getDefaultZ();
        int t = this.model.getDefaultT();
        double f = this.model.getMagnification();
        if (z == defaultZ && t == defaultT) {
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        } else {
            this.model.setPlane(defaultZ, defaultT);
            Drawing drawing = this.model.getDrawing();
            drawing.removeDrawingListener(this.controller);
            drawing.clear();
            ShapeList list = null;
            try {
                list = this.model.getShapeList();
            }
            catch (Exception e) {
                this.view.handleROIException(e, "Cannot retrieve the ROI");
            }
            this.view.setStatus("");
            if (list != null) {
                TreeMap<Long, ROIShape> map = list.getList();
                for (ROIShape shape : map.values()) {
                    if (shape == null) continue;
                    drawing.add(shape.getFigure());
                    shape.getFigure().addFigureListener(this.controller);
                }
            }
            this.model.getDrawingView().setDrawing(drawing);
            drawing.addDrawingListener(this.controller);
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        }
    }

    @Override
    public void close() {
        if (this.model.getState() == 6) {
            return;
        }
        this.postEvent(1);
        if (this.model.isHCSData()) {
            List<FileAnnotationData> list = this.model.getMeasurements();
            if (list == null || list.size() == 0) {
                this.view.setVisible(false);
            } else {
                this.discard();
            }
        } else {
            this.view.setVisible(false);
        }
    }

    @Override
    public void iconified(boolean b) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method shouldn't be invoked in the DISCARDED state:" + this.model.getState());
        }
        this.view.setVisible(b);
    }

    @Override
    public void loadROI() {
        FileChooser chooser = this.createChooserDialog(0);
        if (chooser.showDialog() != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.model.fireROILoading(f.getAbsolutePath());
        this.fireStateChange();
        this.view.updateDrawingArea();
    }

    @Override
    public void saveROI() {
        FileChooser chooser = this.createChooserDialog(1);
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String s = file.getAbsolutePath();
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (!s.endsWith("xml")) {
            String fileName = s + "." + "xml";
            file = new File(fileName);
        }
        this.saveBackROI(file.getAbsolutePath());
    }

    @Override
    public void saveROIToServer() {
        if (!this.isImageWritable()) {
            return;
        }
        List<ROI> l = this.model.getROIToDelete();
        if (l != null && l.size() > 0) {
            ArrayList<DeletableObject> objects = new ArrayList<DeletableObject>();
            for (ROI roi : l) {
                if (roi.isClientSide()) continue;
                ROIData data = new ROIData();
                data.setId(roi.getID());
                data.setImage(this.model.getImage().asImage());
                objects.add(new DeletableObject((DataObject)data));
            }
            if (objects.size() == 0) {
                this.model.saveROIToServer(true);
                this.model.saveWorkflowToServer(true);
            } else {
                IconManager icons = IconManager.getInstance();
                DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(45), objects);
                p.setImageID(this.model.getImageID());
                p.setFailureIcon(icons.getIcon(44));
                UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
                un.notifyActivity(p);
            }
        } else {
            this.model.saveROIToServer(true);
            this.model.saveWorkflowToServer(true);
        }
    }

    @Override
    public void figureAttributeChanged(AttributeKey key, ROIFigure figure) {
        this.model.figureAttributeChanged(key, figure);
    }

    @Override
    public void showROIAssistant() {
        this.view.showROIAssistant();
    }

    @Override
    public void showROIAssistant(ROI roi) {
        this.view.showROIAssistant(roi);
    }

    @Override
    public void showMeasurementsInMicrons(boolean inMicrons) {
        this.model.showMeasurementsInMicrons(inMicrons);
        this.view.updateDrawingArea();
        this.view.refreshResultsTable();
    }

    @Override
    public void setActiveChannels(Map activeChannels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(activeChannels);
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        Collection collection = this.getSelectedFigures();
        if (collection.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)collection.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = figure.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setActiveChannelsColor(Map channels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(channels);
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        Collection collection = this.getSelectedFigures();
        if (collection.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)collection.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = figure.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setStatsShapes(Map result) {
        int state = this.model.getState();
        if (state != 4) {
            MeasurementAgent.getRegistry().getLogger().debug((Object)this, "This method can only be invoked in the ANALYSE_SHAPE state: " + state);
            return;
        }
        if (result == null || result.size() == 0) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Sets stats results", "No result to display.");
            return;
        }
        this.model.setAnalysisResults(result);
        this.view.displayAnalysisResults();
        this.fireStateChange();
    }

    @Override
    public void analyseShapeList(List<ROIShape> shapeList) {
        if (shapeList == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA or LOADING_ROI state: " + state);
            }
            case 4: {
                return;
            }
        }
        if (!this.validShapeList(shapeList)) {
            return;
        }
        if (this.model.getActiveChannels().size() == 0) {
            this.view.displayAnalysisResults();
        } else {
            this.model.fireAnalyzeShape(shapeList);
            this.fireStateChange();
        }
    }

    private boolean validShapeList(List<ROIShape> shapeList) {
        for (ROIShape shape : shapeList) {
            if (!(shape.getFigure() instanceof MeasureTextFigure)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public void attachListeners(List<ROI> roiList) {
        for (int i = 0; i < roiList.size(); ++i) {
            ROI roi = roiList.get(i);
            for (ROIShape shape : roi.getShapes().values()) {
                shape.getFigure().addFigureListener(this.controller);
            }
        }
    }

    @Override
    public void createSingleFigure(boolean createSingleFig) {
        this.view.createSingleFigure(createSingleFig);
    }

    private void saveBackROI(String path) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.saveROI(path, false);
        }
        catch (ParsingException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        un.notifyInfo("Save ROI", "The Regions of Interests have been successfully saved. ");
        this.firePropertyChange("roiChanged", false, true);
    }

    @Override
    public void toFront() {
        if (this.model.getState() == 6) {
            return;
        }
        this.controller.toFront();
    }

    @Override
    public void setIconImage(BufferedImage thumbnail) {
        if (this.model.getState() == 6) {
            return;
        }
    }

    @Override
    public void setRndImage(Object rndImage) {
        if (this.model.getState() == 6) {
            return;
        }
        this.model.setRenderedImage(rndImage);
    }

    @Override
    public boolean hasROIToSave() {
        if (this.model.getState() == 6) {
            return false;
        }
        return this.model.hasROIToSave();
    }

    @Override
    public void setServerROI(Collection result) {
        if (this.model.getState() != 3) {
            throw new IllegalArgumentException("The method can only be invoked in the LOADING_ROI state.");
        }
        try {
            if (result != null) {
                this.model.setServerROI(result, true);
            }
        }
        catch (Exception e) {
            String s = "Cannot convert server ROI into UI objects:";
            MeasurementAgent.getRegistry().getLogger().error((Object)this, s + e);
        }
        this.view.layoutUI();
        this.view.updateDrawingArea();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public boolean isHCSData() {
        return this.model.isHCSData();
    }

    @Override
    public String getViewTitle() {
        return this.model.getImageTitle();
    }

    @Override
    public void setLoadingFromServerClient(Collection result) {
        if (this.model.getState() != 3) {
            throw new IllegalArgumentException("The method can only be invoked in the LOADING_ROI state.");
        }
        try {
            ROIResult roiResult;
            Iterator i;
            boolean hasResult = false;
            if (result != null && (i = result.iterator()).hasNext() && (roiResult = (ROIResult)i.next()).getROIs().size() != 0) {
                hasResult = true;
            }
            if (!hasResult) {
                this.model.fireROILoading(null);
                return;
            }
            this.model.setServerROI(result, false);
        }
        catch (Exception e) {
            String s = "Cannot convert server ROI into UI objects:";
            MeasurementAgent.getRegistry().getLogger().error((Object)this, s + e);
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Load ROI", "Cannot display the ROI.");
        }
        this.view.rebuildManagerTable();
        this.view.updateDrawingArea();
        this.view.setReadyStatus();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setUpdateROIComponent(Collection result) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.removeAllROI();
        }
        catch (NoSuchROIException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        this.model.fireLoadROIServerOrClient(false);
    }

    @Override
    public void createWorkflow() {
        this.view.createWorkflow();
    }

    @Override
    public void setWorkflow(String workflowNamespace) {
        workflowNamespace = this.view.getWorkflowFromDisplay(workflowNamespace);
        this.model.setWorkflow(workflowNamespace);
        this.view.updateWorkflow();
    }

    @Override
    public void setKeyword(List<String> keyword) {
        this.model.setKeyword(keyword);
    }

    @Override
    public boolean isImageWritable() {
        if (this.model.getState() == 6) {
            return false;
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        long id = exp.getId();
        boolean b = EditorUtil.isUserOwner(this.model.getRefObject(), id);
        if (b) {
            return b;
        }
        int level = MeasurementAgent.getRegistry().getAdminService().getPermissionLevel();
        switch (level) {
            case 102: 
            case 104: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.view.getTitle();
    }

    @Override
    public void setWorkflowList(List<WorkflowData> workflows) {
        for (WorkflowData workflow : workflows) {
            this.model.addWorkflow(workflow);
        }
        this.view.addedWorkflow();
    }

    @Override
    public void deleteAllROIs() {
        if (!this.isImageWritable()) {
            return;
        }
        List<ROIData> list = this.model.getROIData();
        ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
        for (ROIData roi : list) {
            if (roi.getId() <= 0L) continue;
            l.add(new DeletableObject((DataObject)roi));
        }
        ExperimenterData exp = MeasurementAgent.getUserDetails();
        try {
            List<ROIFigure> figures = this.model.removeAllROI(exp.getId());
            this.view.deleteROIs(figures);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Delete ROI");
            msg.print(e);
            MeasurementAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        if (l.size() == 0) {
            return;
        }
        IconManager icons = IconManager.getInstance();
        DeleteActivityParam p = new DeleteActivityParam(icons.getIcon(45), l);
        p.setFailureIcon(icons.getIcon(44));
        UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
        un.notifyActivity(p);
    }

    @Override
    public boolean hasROIToDelete() {
        if (this.model.getState() == 6) {
            return false;
        }
        return this.model.hasROIToDelete();
    }
}

