/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import org.openmicroscopy.shoola.agents.events.iviewer.RendererUnloadedEvent;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;

public class RenderingControlLoader
extends EditorLoader {
    public static final int LOAD = 0;
    public static final int RELOAD = 1;
    public static final int RESET = 2;
    private long pixelsID;
    private int index;
    private CallHandle handle;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    public RenderingControlLoader(Editor viewer, long pixelsID, int index) {
        super(viewer);
        this.checkIndex(index);
        this.pixelsID = pixelsID;
        this.index = index;
    }

    public void load() {
        this.handle = this.imView.loadRenderingControl(this.pixelsID, this.index, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Loading Rendering data", "The image could not be opened. \nThe image is not a valid image.");
        this.viewer.setRenderingControl(null);
        this.registry.getEventBus().post(new RendererUnloadedEvent(this.pixelsID));
    }

    public void handleResult(Object result) {
        switch (this.index) {
            case 0: 
            case 1: {
                this.viewer.setRenderingControl((RenderingControl)result);
                break;
            }
        }
    }
}

