/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailLoader
extends MetadataLoader {
    private static final int STANDARD_WIDTH = 96;
    private static final int STANDARD_HEIGHT = 96;
    private ImageData image;
    private Set<Long> userIDs;
    private CallHandle handle;
    private Map<Long, BufferedImage> thumbnails;

    public ThumbnailLoader(MetadataViewer viewer, ImageData image, Set<Long> userIDs) {
        super(viewer);
        this.image = image;
        this.userIDs = userIDs;
        this.thumbnails = new HashMap<Long, BufferedImage>();
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadThumbnails(this.image, this.userIDs, 96, 96, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            this.thumbnails.put(td.getUserID(), td.getThumbnail());
        }
        if (this.thumbnails.size() == this.userIDs.size()) {
            this.viewer.setThumbnails(this.thumbnails, this.image.getId());
        }
    }

    @Override
    public void handleNullResult() {
    }
}

