/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.ChannelAcquisitionComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.ImageAcquisitionComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.InstrumentComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.OriginalMetadataComponent;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;
import pojos.FileAnnotationData;
import pojos.ImageAcquisitionData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AcquisitionDataUI
extends JPanel
implements PropertyChangeListener {
    static final String SHOW_UNSET = "Show unset fields";
    static final String HIDE_UNSET = "Hide unset fields";
    static final String BOOLEAN_YES = "Yes";
    static final String BOOLEAN_NO = "No";
    static final List<String> UNSET_ENUM = new ArrayList<String>();
    private static final String DEFAULT_CHANNEL_TEXT = "";
    private EditorControl controller;
    private EditorModel model;
    private EditorUI view;
    private ImageAcquisitionComponent imageAcquisition;
    private InstrumentComponent instrument;
    private Map<JXTaskPane, ChannelData> channelAcquisitionPanes;
    private JXTaskPane imagePane;
    private JXTaskPane instrumentPane;
    private JXTaskPane originalMetadataPane;
    private List<ChannelAcquisitionComponent> channelComps;
    private JPanel container;
    private GridBagConstraints constraints;
    private OriginalMetadataComponent originalMetadata;
    private JXTaskPane companionFilesPane;
    private boolean init;
    private JPanel docPane;

    private void initComponents() {
        this.container = new JPanel();
        this.channelComps = new ArrayList<ChannelAcquisitionComponent>();
        this.channelAcquisitionPanes = new LinkedHashMap<JXTaskPane, ChannelData>();
        this.imageAcquisition = new ImageAcquisitionComponent(this, this.model);
        this.imageAcquisition.addPropertyChangeListener(this);
        this.imagePane = EditorUtil.createTaskPane("Image");
        this.imagePane.add((Component)this.imageAcquisition);
        this.imagePane.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        this.instrument = new InstrumentComponent(this, this.model);
        this.instrumentPane = EditorUtil.createTaskPane("Microscope");
        this.instrumentPane.add((Component)this.instrument);
        this.instrumentPane.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        this.originalMetadataPane = EditorUtil.createTaskPane("Original Metadata");
        this.originalMetadataPane.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        this.originalMetadata = new OriginalMetadataComponent(this.model);
        this.originalMetadataPane.add((Component)this.originalMetadata);
        this.companionFilesPane = EditorUtil.createTaskPane("Companion Files");
        this.docPane = new JPanel();
        this.docPane.setLayout(new BoxLayout(this.docPane, 1));
        this.docPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.companionFilesPane.add((Component)this.docPane);
    }

    private void buildGUI() {
        this.container.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.container.setLayout(new GridBagLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BorderLayout(0, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(0, 2, 2, 0);
        this.constraints.weightx = 1.0;
        this.container.add((Component)this.companionFilesPane, this.constraints);
        ++this.constraints.gridy;
        this.container.add((Component)this.originalMetadataPane, this.constraints);
        ++this.constraints.gridy;
        this.container.add((Component)this.instrumentPane, this.constraints);
        ++this.constraints.gridy;
        this.container.add((Component)this.imagePane, this.constraints);
        this.add((Component)this.container, "North");
    }

    private void layoutUI() {
        int n;
        if (!this.init) {
            this.buildGUI();
            this.init = true;
        }
        if ((n = this.container.getComponentCount()) == 0) {
            return;
        }
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == this.imagePane || comps[i] == this.instrumentPane || comps[i] == this.originalMetadataPane || comps[i] == this.companionFilesPane) continue;
            this.container.remove(comps[i]);
        }
        this.constraints.gridy = 4;
        Iterator<JXTaskPane> i = this.channelAcquisitionPanes.keySet().iterator();
        while (i.hasNext()) {
            ++this.constraints.gridy;
            this.container.add((Component)i.next(), this.constraints);
        }
        this.revalidate();
        this.repaint();
    }

    AcquisitionDataUI(EditorUI view, EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.init = false;
    }

    void attachListener(Map<String, DataComponent> map) {
        for (Map.Entry<String, DataComponent> entry : map.entrySet()) {
            entry.getValue().attachListener(this.controller);
        }
    }

    boolean hasDataToSave(Map<String, DataComponent> map) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<String, DataComponent> entry : map.entrySet()) {
            DataComponent comp = entry.getValue();
            if (!comp.isDirty()) continue;
            return true;
        }
        return false;
    }

    JLabelButton formatUnsetFieldsControl() {
        JLabelButton button = new JLabelButton(SHOW_UNSET);
        Font font = button.getFont();
        int sizeLabel = font.getSize() - 2;
        button.setFont(font.deriveFont(2, sizeLabel));
        button.setBackground(UIUtilities.BACKGROUND_COLOR);
        button.setForeground(UIUtilities.HYPERLINK_COLOR);
        return button;
    }

    void format(JComponent comp, String title) {
        if (comp == null) {
            return;
        }
        if (title == null) {
            title = DEFAULT_CHANNEL_TEXT;
        }
        comp.setBorder(BorderFactory.createTitledBorder(title));
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        comp.setLayout(new GridBagLayout());
    }

    JComponent replaceCombobox(JComboBox box) {
        JLabel l = new JLabel();
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        if (box != null) {
            l.setFont(box.getFont());
            l.setText(box.getSelectedItem().toString());
        }
        return l;
    }

    void layoutFields(JPanel pane, JComponent button, Map<String, DataComponent> fields, boolean shown) {
        pane.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        Set<Map.Entry<String, DataComponent>> set = fields.entrySet();
        Iterator<Map.Entry<String, DataComponent>> i = set.iterator();
        c.gridy = 0;
        while (i.hasNext()) {
            c.gridx = 0;
            Map.Entry<String, DataComponent> entry = i.next();
            DataComponent comp = entry.getValue();
            if (!comp.isSetField() && !shown) continue;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            pane.add((Component)comp.getLabel(), c);
            ++c.gridx;
            pane.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            pane.add((Component)comp.getArea(), c);
        }
        if (c.gridy != 0) {
            ++c.gridy;
        }
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        if (button != null) {
            pane.add((Component)button, c);
        }
    }

    Boolean convertToBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (BOOLEAN_YES.equals(value)) {
            return Boolean.TRUE;
        }
        if (BOOLEAN_NO.equals(value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    void setChannelData() {
        Map channels = this.model.getChannelData();
        this.channelAcquisitionPanes.clear();
        this.channelComps.clear();
        if (channels != null) {
            for (ChannelData channel : channels.keySet()) {
                ChannelAcquisitionComponent comp = new ChannelAcquisitionComponent(this, this.model, channel);
                comp.setChannelColor((Color)channels.get(channel));
                JXTaskPane p = EditorUtil.createTaskPane(DEFAULT_CHANNEL_TEXT + channel.getChannelLabeling());
                p.setIcon(comp.getIcon());
                p.add((Component)comp);
                p.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
                this.channelAcquisitionPanes.put(p, channel);
                this.channelComps.add(comp);
            }
        }
        this.layoutUI();
    }

    void onChannelColorChanged(int index) {
        for (ChannelAcquisitionComponent comp : this.channelComps) {
            if (comp.getChannelIndex() != index) continue;
            comp.setChannelColor(this.model.getChannelColor(index));
            comp.repaint();
            break;
        }
    }

    void setImageAcquisitionData() {
        this.imageAcquisition.setImageAcquisitionData();
    }

    void setInstrumentData() {
        this.instrument.setInstrumentData();
    }

    void setChannelAcquisitionData(int index) {
        Iterator<ChannelAcquisitionComponent> i = this.channelComps.iterator();
        while (i.hasNext()) {
            i.next().setChannelAcquisitionData(index);
        }
    }

    void setPlaneInfo(int index) {
        Iterator<ChannelAcquisitionComponent> i = this.channelComps.iterator();
        while (i.hasNext()) {
            i.next().setPlaneInfo(index);
        }
    }

    void setRootObject(boolean load) {
        this.instrument.setRootObject();
        this.imageAcquisition.setRootObject();
        this.channelAcquisitionPanes.clear();
        this.originalMetadata.clear();
        this.layoutUI();
        this.repaint();
        if (!this.imagePane.isCollapsed() && load) {
            this.controller.loadImageAcquisitionData();
        }
        if (!this.instrumentPane.isCollapsed() && load) {
            this.controller.loadInstrumentData();
        }
        this.originalMetadataPane.setCollapsed(true);
        if (MetadataViewerAgent.isBinaryAvailable()) {
            this.originalMetadataPane.setVisible(!(this.model.getRefObject() instanceof WellSampleData));
        } else {
            this.originalMetadataPane.setVisible(false);
        }
    }

    boolean hasDataToSave() {
        return false;
    }

    List<Object> prepareDataToSave() {
        ArrayList<Object> data = new ArrayList<Object>();
        if (!this.hasDataToSave()) {
            return data;
        }
        ImageAcquisitionData object = this.imageAcquisition.prepareDataToSave();
        if (object != null) {
            data.add(object);
        }
        Iterator<ChannelAcquisitionComponent> i = this.channelComps.iterator();
        while (i.hasNext()) {
            List<Object> objects = i.next().prepareDataToSave();
            if (objects.size() <= 0) continue;
            data.addAll(objects);
        }
        return data;
    }

    void loadPlaneInfo(int index) {
        if (this.model.getChannelPlaneInfo(index) == null) {
            this.model.firePlaneInfoLoading(index, 0);
            this.view.setStatus(true);
        }
    }

    void layoutCompanionFiles() {
        Collection list;
        boolean b = this.model.getOriginalMetadata() == null || !MetadataViewerAgent.isBinaryAvailable();
        this.originalMetadataPane.setVisible(!b);
        if (b) {
            this.originalMetadataPane.setCollapsed(true);
        }
        if ((list = this.model.getCompanionFiles()) == null || list.size() == 0) {
            this.companionFilesPane.setVisible(false);
            this.revalidate();
            this.repaint();
            return;
        }
        this.companionFilesPane.setVisible(true);
        Iterator i = list.iterator();
        this.docPane.removeAll();
        while (i.hasNext()) {
            this.docPane.add(new DocComponent(i.next(), this.model, false));
        }
        this.revalidate();
        this.repaint();
    }

    void refresh() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (!"collapsed".equals(name)) {
            return;
        }
        Object src = evt.getSource();
        if (src == this.imagePane) {
            this.controller.loadImageAcquisitionData();
        } else if (src == this.instrumentPane) {
            this.controller.loadInstrumentData();
        } else if (src == this.originalMetadataPane) {
            if (MetadataViewerAgent.isBinaryAvailable()) {
                FileAnnotationData f = this.model.getOriginalMetadata();
                if (f != null && !this.originalMetadata.isMetadataLoaded()) {
                    this.model.loadFile(f, this.originalMetadata);
                } else if (f == null) {
                    this.originalMetadataPane.setCollapsed(true);
                }
            }
        } else {
            ChannelData channel = this.channelAcquisitionPanes.get(src);
            this.controller.loadChannelAcquisitionData(channel);
        }
    }

    static {
        UNSET_ENUM.add("Other");
        UNSET_ENUM.add("Unknown");
        UNSET_ENUM.add("Not Set");
    }
}

