/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import pojos.DataObject;
import pojos.TextualAnnotationData;

class TextualAnnotationComponent
extends JPanel {
    private OMEWikiComponent area;
    private TextualAnnotationData data;
    private EditorModel model;

    private void initialize() {
        this.area = new OMEWikiComponent(false);
        this.area.setEnabled(false);
        this.area.setOpaque(true);
        this.area.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.area.setText(this.data.getText());
        String owner = this.model.formatOwner((DataObject)this.data);
        String date = this.model.formatDate((DataObject)this.data);
        TitledLineBorder border = new TitledLineBorder(owner + " " + date);
        border.setTitleFont(this.area.getFont().deriveFont(1));
        this.setBorder(border);
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.area);
    }

    TextualAnnotationComponent(EditorModel model, TextualAnnotationData data) {
        this.data = data;
        this.model = model;
        this.initialize();
        this.buildGUI();
    }

    void setAreaColor(Color color) {
        this.setBackground(color);
        ((TitledLineBorder)this.getBorder()).setLineColor(color);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setBackground(color);
        }
        this.area.setBackground(color);
    }
}

