/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewCanvas;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewToolBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import pojos.ChannelData;

public class DomainPane
extends ControlPane
implements ActionListener,
ChangeListener,
MouseWheelListener {
    static final int MIN_GAMMA = 1;
    static final int MAX_GAMMA = 40;
    static final int DEFAULT_GAMMA = 10;
    static final int MIN_BIT_DEPTH = 1;
    static final int MAX_BIT_DEPTH = 8;
    static final int DEFAULT_BIT_DEPTH = 8;
    private static final Border SELECTION_BORDER = BorderFactory.createLineBorder(Color.BLACK, 3);
    private static final int FACTOR = 10;
    private static final int FAMILY = 0;
    private static final int CHANNEL = 1;
    private static final Dimension VBOX = new Dimension(1, 10);
    private static final String ADVANCED_OPTIONS = "Advanced";
    private static final String Z_SLIDER_DESCRIPTION = "Select a z-section.";
    private static final String T_SLIDER_DESCRIPTION = "Select a timepoint.";
    private static final String LITEIME_SLIDER_DESCRIPTION = "Select a bin.";
    private static final String Z_SLIDER_TIPSTRING = "Z";
    private static final String T_SLIDER_TIPSTRING = "T";
    private static final String LIFETIME_SLIDER_TIPSTRING = "L";
    private JComboBox familyBox;
    private List<ChannelButton> channelList;
    private JPanel channelButtonPanel;
    private OneKnobSlider gammaSlider;
    private OneKnobSlider bitDepthSlider;
    private JTextField gammaLabel;
    private JTextField bitDepthLabel;
    private JCheckBox noiseReduction;
    private JButton histogramButton;
    private GraphicsPane graphicsPane;
    private JXTaskPane taskPane;
    private JButton colorModel;
    private OneKnobSlider lifetimeSlider;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private PreviewCanvas canvas;
    private JComboBox channelsBox;
    private PreviewToolBar previewToolBar;

    private void initSlider(OneKnobSlider slider, int max, int v, String toolTip, String endLabel) {
        slider.setEnabled(max > 0);
        slider.setBackground(UIUtilities.BACKGROUND_COLOR);
        slider.setVisible(max != 0);
        slider.setMaximum(max);
        slider.setValue(v);
        slider.addChangeListener(this);
        slider.addMouseWheelListener(this);
        slider.setToolTipText(toolTip);
        slider.setEndLabel(endLabel);
        slider.setShowEndLabel(true);
        slider.setShowTipLabel(true);
        if (max > 0 && max <= 10) {
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(1);
        }
    }

    private void mouseWheelMovedZ(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
            }
        }
        if (this.previewToolBar != null) {
            this.previewToolBar.setSelectedPlane();
        }
    }

    private void mouseWheelMovedT(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxT()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
            }
        }
        if (this.previewToolBar != null) {
            this.previewToolBar.setSelectedPlane();
        }
    }

    private void initComponents() {
        this.taskPane = EditorUtil.createTaskPane(ADVANCED_OPTIONS);
        this.graphicsPane = new GraphicsPane(this.model, this.controller);
        this.familyBox = new JComboBox<Object>(this.model.getFamilies().toArray());
        this.familyBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        String family = this.model.getFamily();
        this.familyBox.setSelectedItem(family);
        this.familyBox.addActionListener(this);
        this.familyBox.setActionCommand("0");
        double k = this.model.getCurveCoefficient();
        this.gammaSlider = new OneKnobSlider(0, 1, 40, (int)(k * 10.0));
        this.gammaSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaSlider.setShowArrows(false);
        this.gammaSlider.setEnabled(family.equals("exponential") || family.equals("polynomial"));
        this.gammaSlider.addChangeListener(this);
        this.gammaSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                double v = (double)DomainPane.this.gammaSlider.getValue() / 10.0;
                DomainPane.this.gammaLabel.setText("" + v);
                DomainPane.this.firePropertyChange("gamma", new Double(DomainPane.this.model.getCurveCoefficient()), new Double(v));
            }
        });
        this.gammaLabel = new JTextField("" + k);
        this.gammaLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaLabel.setEnabled(false);
        this.gammaLabel.setEditable(false);
        int v = this.model.getBitResolution();
        this.bitDepthSlider = new OneKnobSlider(0, 1, 8, this.convertBitResolution(v));
        this.bitDepthSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthSlider.setShowArrows(false);
        this.bitDepthSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int v = DomainPane.this.convertUIBitResolution(DomainPane.this.bitDepthSlider.getValue());
                DomainPane.this.bitDepthLabel.setText("" + v);
                DomainPane.this.firePropertyChange("bit_resolution", DomainPane.this.model.getBitResolution(), v);
            }
        });
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel = new JTextField("" + v);
        this.bitDepthLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthLabel.setEnabled(false);
        this.bitDepthLabel.setEditable(false);
        this.noiseReduction = new JCheckBox();
        this.noiseReduction.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.noiseReduction.setSelected(this.model.isNoiseReduction());
        this.noiseReduction.setAction(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.histogramButton = new JButton(this.controller.getAction(RendererControl.HISTOGRAM));
        this.colorModel = new JButton(this.controller.getAction(RendererControl.COLOR_MODEL));
        this.colorModel.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.colorModel);
        this.colorModel.setVisible(false);
        this.channelList = new ArrayList<ChannelButton>();
        if (this.model.isGeneralIndex()) {
            int maxZ = this.model.getMaxZ() - 1;
            int maxT = this.model.getMaxT() - 1;
            this.zSlider = new OneKnobSlider(1, 0, 1, 0);
            this.zSlider.setEnabled(false);
            this.tSlider = new OneKnobSlider(0, 0, 1, 0);
            this.tSlider.setEnabled(false);
            this.initSlider(this.tSlider, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
            this.initSlider(this.zSlider, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
            this.canvas = new PreviewCanvas();
            this.canvas.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ActionEvent event = new ActionEvent(e.getSource(), e.getID(), "");
                        DomainPane.this.controller.getAction(RendererControl.VIEW).actionPerformed(event);
                    }
                }
            });
            this.previewToolBar = new PreviewToolBar(this.controller, this.model);
        }
        if (!this.model.isNumerousChannel()) {
            this.channelButtonPanel = this.createChannelButtons();
        } else {
            this.lifetimeSlider = new OneKnobSlider(0, 0, 1, 0);
            this.lifetimeSlider.setEnabled(false);
            int maxBin = this.model.getMaxLifetimeBin() - 1;
            this.initSlider(this.lifetimeSlider, maxBin, this.model.getSelectedBin(), LITEIME_SLIDER_DESCRIPTION, LIFETIME_SLIDER_TIPSTRING);
            this.lifetimeSlider.setPaintTicks(false);
            this.channelButtonPanel = new JPanel();
            this.channelButtonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        }
        if (this.previewToolBar != null) {
            this.previewToolBar.setSelectedPlane();
        }
        if (this.model.getChannelData().size() > 1) {
            this.channelsBox = new JComboBox();
            this.populateChannels();
            this.channelsBox.setRenderer(new ColorListRenderer());
            this.channelsBox.setActionCommand("1");
        }
    }

    private void populateChannels() {
        if (this.channelsBox == null) {
            return;
        }
        List<ChannelData> channels = this.model.getChannelData();
        Object[][] channelCols = new Object[channels.size()][2];
        Iterator<ChannelData> i = channels.iterator();
        int index = 0;
        int selected = 0;
        while (i.hasNext()) {
            ChannelData data = i.next();
            channelCols[index] = new Object[]{this.model.getChannelColor(data.getIndex()), data.getChannelLabeling()};
            if (data.getIndex() == this.model.getSelectedChannel()) {
                selected = index;
            }
            ++index;
        }
        this.channelsBox.setModel(new DefaultComboBoxModel((E[])channelCols));
        this.channelsBox.removeActionListener(this);
        this.channelsBox.setSelectedIndex(selected);
        this.channelsBox.addActionListener(this);
    }

    private void resetBitResolution() {
        int v = this.model.getBitResolution();
        this.bitDepthSlider.removeChangeListener(this);
        this.bitDepthSlider.setValue(this.convertBitResolution(v));
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel.setText("" + v);
        this.bitDepthLabel.repaint();
    }

    private JPanel createChannelButtons() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        List<ChannelData> data = this.model.getChannelData();
        boolean gs = this.model.isGreyScale();
        p.add(Box.createRigidArea(VBOX));
        Dimension dMax = ChannelButton.DEFAULT_MIN_SIZE;
        Iterator<ChannelData> i = data.iterator();
        List<Integer> active = this.model.getActiveChannels();
        while (i.hasNext()) {
            ChannelData d = i.next();
            int j = d.getIndex();
            ChannelButton item = new ChannelButton("" + d.getChannelLabeling(), this.model.getChannelColor(j), j);
            Dimension dim = item.getPreferredSize();
            if (dim.width > dMax.width) {
                dMax = new Dimension(dim.width, dMax.height);
            }
            item.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.channelList.add(item);
            item.setSelected(active.contains(j));
            item.setGrayedOut(gs);
            item.addPropertyChangeListener(this.controller);
            p.add(item);
            p.add(Box.createRigidArea(VBOX));
        }
        Iterator<ChannelButton> index = this.channelList.iterator();
        while (index.hasNext()) {
            index.next().setPreferredSize(dMax);
        }
        JPanel controls = new JPanel();
        controls.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        controls.setBackground(UIUtilities.BACKGROUND_COLOR);
        if (this.model.isGeneralIndex()) {
            this.colorModel.setVisible(true);
            JToolBar bar = new JToolBar(1);
            bar.setBackground(this.colorModel.getBackground());
            bar.setFloatable(false);
            bar.setRollover(true);
            bar.setBorder(null);
            bar.add(this.colorModel);
            c.anchor = 10;
            controls.add((Component)bar, c);
            c.gridy += 2;
            c.anchor = 17;
        }
        if (this.channelList.size() > 10) {
            controls.add((Component)new JScrollPane(p), c);
        } else {
            controls.add((Component)p, c);
        }
        JPanel content = UIUtilities.buildComponentPanel(controls);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        return content;
    }

    private JPanel buildChannelGraphicsPanel() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BorderLayout());
        if (this.model.isGeneralIndex()) {
            p.add((Component)this.buildViewerPane(), "West");
            p.add((Component)this.graphicsPane, "South");
            JPanel bar = new JPanel();
            bar.setBackground(UIUtilities.BACKGROUND_COLOR);
            bar.setLayout(new BoxLayout(bar, 1));
            bar.add(this.previewToolBar);
            bar.add(new JSeparator());
            JPanel content = new JPanel();
            content.setLayout(new BorderLayout());
            content.setBackground(UIUtilities.BACKGROUND_COLOR);
            content.add((Component)bar, "North");
            content.add((Component)p, "Center");
            return content;
        }
        p.add((Component)this.graphicsPane, "Center");
        return p;
    }

    private JPanel buildViewerPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        if (this.channelButtonPanel != null) {
            p.add((Component)this.channelButtonPanel, c);
            ++c.gridx;
        }
        p.add((Component)this.zSlider, c);
        ++c.gridx;
        p.add((Component)this.canvas, c);
        ++c.gridy;
        if (this.tSlider.isVisible()) {
            p.add((Component)this.tSlider, c);
        }
        if (this.lifetimeSlider != null && this.lifetimeSlider.isVisible()) {
            p.add((Component)this.lifetimeSlider, c);
        }
        return p;
    }

    private void updateSlider(JSlider slider, int v) {
        slider.removeChangeListener(this);
        slider.setValue(v);
        slider.addChangeListener(this);
        if (this.previewToolBar != null) {
            this.previewToolBar.setSelectedPlane();
        }
    }

    private JPanel buildSliderPane(JSlider slider, JTextField field) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(slider);
        p.add(field);
        return UIUtilities.buildComponentPanel(p);
    }

    private void addComponent(GridBagConstraints c, String l, JComponent comp, JPanel p) {
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        if (l != null && l.length() > 0) {
            p.add((Component)new JLabel(l), c);
            ++c.gridx;
            p.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
        }
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        p.add((Component)comp, c);
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        JPanel comp = this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Brightness", this.graphicsPane.getCodomainSlider(), p);
        ++c.gridy;
        comp = this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Bit Depth", comp, p);
        ++c.gridy;
        this.addComponent(c, "", this.noiseReduction, p);
        c.gridx = 0;
        ++c.gridy;
        comp = new SeparatorPane();
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)comp, c);
        ++c.gridy;
        if (this.channelsBox != null) {
            comp = UIUtilities.buildComponentPanel(this.channelsBox);
            comp.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.addComponent(c, "Channels", comp, p);
            ++c.gridy;
        }
        comp = UIUtilities.buildComponentPanel(this.familyBox);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Map", comp, p);
        ++c.gridy;
        comp = this.buildSliderPane(this.gammaSlider, this.gammaLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Gamma", comp, p);
        return p;
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildChannelGraphicsPanel());
        if (!this.model.isGeneralIndex()) {
            this.taskPane.add((Component)this.buildControlsPane());
            p.add((Component)this.taskPane);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)p, "North");
    }

    private int convertUIBitResolution(int uiValue) {
        switch (uiValue) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
        }
        return 255;
    }

    private int convertBitResolution(int value) {
        switch (value) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 31: {
                return 5;
            }
            case 63: {
                return 6;
            }
            case 127: {
                return 7;
            }
        }
        return 8;
    }

    private void resetGamma(double k) {
        this.gammaSlider.removeChangeListener(this);
        this.gammaSlider.setValue((int)(k * 10.0));
        this.gammaSlider.addChangeListener(this);
        this.gammaLabel.setText("" + k);
    }

    private void mouseWheelMovedLifetime(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultT() - e.getWheelRotation();
            int bin = this.lifetimeSlider.getValue();
            if (up) {
                if (v <= this.model.getMaxLifetimeBin()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getDefaultT(), bin);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getDefaultT(), bin);
            }
        }
    }

    protected String getPaneName() {
        return "Mapping";
    }

    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(67);
    }

    protected String getPaneDescription() {
        return "Define the mapping context for the pixels intensity values.";
    }

    protected int getPaneIndex() {
        return 0;
    }

    protected void resetDefaultRndSettings() {
        this.setInputInterval();
        this.setInputRange(false);
        this.setSelectedChannel();
        this.setCodomainInterval();
        this.resetBitResolution();
        int n = this.model.getMaxC();
        for (int i = 0; i < n; ++i) {
            this.setChannelColor(i);
        }
        this.resetGamma(this.model.getCurveCoefficient());
        this.setZSection(this.model.getDefaultZ());
        this.setTimepoint(this.model.getDefaultT());
    }

    protected void onStateChange(boolean b) {
        if (this.familyBox != null) {
            this.familyBox.setEnabled(b);
        }
        if (this.gammaSlider != null) {
            String family = this.model.getFamily();
            this.gammaSlider.setEnabled(b);
            this.gammaSlider.setEnabled(family.equals("exponential") || family.equals("polynomial"));
        }
        if (this.bitDepthSlider != null) {
            this.bitDepthSlider.setEnabled(b);
        }
        if (this.noiseReduction != null) {
            this.noiseReduction.setEnabled(b);
        }
        if (this.channelList != null) {
            Iterator<ChannelButton> i = this.channelList.iterator();
            while (i.hasNext()) {
                i.next().setEnabled(b);
            }
        }
        this.graphicsPane.onStateChange(b);
    }

    protected void switchRndControl() {
    }

    DomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        this.graphicsPane.setSelectedChannel();
        Iterator<ChannelButton> i = this.channelList.iterator();
        List<Integer> active = this.model.getActiveChannels();
        int c = this.model.getSelectedChannel();
        boolean gs = this.model.isGreyScale();
        while (i.hasNext()) {
            ChannelButton btn = i.next();
            int index = btn.getChannelIndex();
            btn.setSelected(active.contains(index));
            if (index == c && !this.model.isGeneralIndex()) {
                btn.setBorder(SELECTION_BORDER);
            }
            btn.setGrayedOut(gs);
            btn.setColor(this.model.getChannelColor(index));
        }
    }

    void setInputInterval() {
        this.graphicsPane.setInputInterval();
    }

    void setInputRange(boolean booleanValue) {
        this.graphicsPane.setInputRange(booleanValue);
    }

    void setCodomainInterval() {
        this.graphicsPane.setCodomainInterval();
    }

    void setChannelColor(int index) {
        Iterator<ChannelButton> i = this.channelList.iterator();
        boolean gs = this.model.isGreyScale();
        while (i.hasNext()) {
            ChannelButton btn = i.next();
            if (index != btn.getChannelIndex()) continue;
            btn.setColor(this.model.getChannelColor(index));
            if (!gs) continue;
            btn.setGrayedOut(gs);
        }
        this.graphicsPane.setChannelColor(index);
        if (this.channelsBox != null) {
            this.populateChannels();
        }
    }

    void setColorModelChanged() {
        boolean gs = this.model.isGreyScale();
        int selected = this.model.getSelectedChannel();
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelButton btn = this.channelList.get(i);
            int index = btn.getChannelIndex();
            btn.setColor(this.model.getChannelColor(index));
            btn.setGrayedOut(gs);
            btn.setSelected(this.model.isChannelActive(index));
            if (index != selected || this.model.isGeneralIndex()) continue;
            btn.setBorder(SELECTION_BORDER);
        }
        this.graphicsPane.setColorModelChanged();
    }

    void onCurveChange() {
        String f = this.model.getFamily();
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.graphicsPane.onCurveChange();
    }

    void setTimepoint(int t) {
        if (this.tSlider != null) {
            this.updateSlider(this.tSlider, t);
        }
    }

    void setZSection(int z) {
        if (this.zSlider != null) {
            this.updateSlider(this.zSlider, z);
        }
    }

    boolean isSourceDisplayed(Object source) {
        Iterator<ChannelButton> i = this.channelList.iterator();
        while (i.hasNext()) {
            if (i.next() != source) continue;
            return true;
        }
        return false;
    }

    void renderPreview() {
        if (this.canvas == null) {
            return;
        }
        BufferedImage img = this.model.renderImage();
        if (img == null) {
            return;
        }
        Dimension d = this.model.getPreviewDimension();
        img = Factory.scaleBufferedImage(img, d.width, d.height);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        this.canvas.setImage(img);
    }

    void displayViewedBy(List results) {
        this.graphicsPane.displayViewedBy(results);
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.gammaSlider)) {
            this.gammaLabel.setText("" + (double)this.gammaSlider.getValue() / 10.0);
        } else if (source.equals(this.bitDepthSlider)) {
            this.bitDepthLabel.setText("" + this.convertUIBitResolution(this.bitDepthSlider.getValue()));
        } else if (source.equals(this.tSlider) || source.equals(this.zSlider)) {
            this.controller.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue());
        } else if (source.equals(this.lifetimeSlider)) {
            this.controller.setSelectedXYPlane(this.model.getDefaultZ(), this.model.getDefaultT(), this.lifetimeSlider.getValue());
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        index = Integer.parseInt(e.getActionCommand());
        try {
            switch (index) {
                case 0: {
                    String f = (String)((JComboBox)e.getSource()).getSelectedItem();
                    this.firePropertyChange("family", this.model.getFamily(), f);
                    break;
                }
                case 1: {
                    int v = this.channelsBox.getSelectedIndex();
                    List<ChannelData> channels = this.model.getChannelData();
                    ChannelData data = channels.get(v);
                    this.controller.setChannelSelection(data.getIndex(), this.model.isChannelActive(data.getIndex()));
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source == this.zSlider && this.zSlider.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSlider && this.tSlider.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.lifetimeSlider && this.lifetimeSlider.isEnabled()) {
            this.mouseWheelMovedLifetime(e);
        }
    }
}

