/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.rnd.ChannelSlider;
import org.openmicroscopy.shoola.agents.metadata.rnd.GraphicsPaneUI;
import org.openmicroscopy.shoola.agents.metadata.rnd.PreviewControlBar;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.util.ViewedByItem;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;
import pojos.ChannelData;

class GraphicsPane
extends JPanel
implements PropertyChangeListener {
    static final double RATIO = 0.2;
    private TwoKnobsSlider codomainSlider;
    private TextualTwoKnobsSlider domainSlider;
    private JLabel maxLabel;
    private JLabel minLabel;
    private GraphicsPaneUI uiDelegate;
    protected RendererModel model;
    protected RendererControl controller;
    private boolean paintVertical;
    private boolean paintHorizontal;
    private int horizontalLine = -1;
    private int verticalLine = -1;
    private List<ChannelSlider> sliders;
    private PreviewControlBar controlsBar;
    private JXTaskPane viewedBy;

    private String formatValue(double value) {
        if (this.model.getRoundFactor() == 1) {
            return "" + (int)value;
        }
        return UIUtilities.formatToDecimal(value);
    }

    private void initDomainSlider() {
        int highestBound;
        int max;
        double range;
        int f = this.model.getRoundFactor();
        int s = (int)(this.model.getWindowStart() * (double)f);
        int e = (int)(this.model.getWindowEnd() * (double)f);
        int absMin = (int)(this.model.getLowestValue() * (double)f);
        int absMax = (int)(this.model.getHighestValue() * (double)f);
        int min = (int)(this.model.getGlobalMin() * (double)f);
        int lowestBound = (int)((double)min - (range = (double)((max = (int)(this.model.getGlobalMax() * (double)f)) - min) * 0.2));
        if (lowestBound < absMin) {
            lowestBound = absMin;
        }
        if ((highestBound = (int)((double)max + range)) > absMax) {
            highestBound = absMax;
        }
        this.domainSlider.setValues(max, min, highestBound, lowestBound, max, min, s, e, f);
        if (this.model.getMaxC() > 10) {
            this.domainSlider.setInterval(min, max);
        }
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.viewedBy = new JXTaskPane();
        this.viewedBy.setCollapsed(true);
        this.viewedBy.setVisible(false);
        Font font = this.viewedBy.getFont();
        this.viewedBy.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        this.viewedBy.setTitle("Viewed by");
        this.viewedBy.setIcon(icons.getIcon(104));
        this.controlsBar = new PreviewControlBar(this.controller, this.model);
        this.uiDelegate = new GraphicsPaneUI(this, this.model);
        this.codomainSlider = new TwoKnobsSlider(0, 255, this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.codomainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.codomainSlider.setPaintLabels(false);
        this.codomainSlider.setPaintEndLabels(false);
        this.codomainSlider.setPaintTicks(false);
        this.codomainSlider.setColourGradients(Color.BLACK, Color.WHITE);
        this.codomainSlider.addPropertyChangeListener(this);
        this.domainSlider = new TextualTwoKnobsSlider();
        this.domainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.initDomainSlider();
        this.domainSlider.getSlider().setPaintLabels(false);
        this.domainSlider.getSlider().setPaintEndLabels(false);
        this.domainSlider.getSlider().setPaintTicks(false);
        this.domainSlider.addPropertyChangeListener(this);
        this.maxLabel = new JLabel(this.formatValue(this.model.getGlobalMax()));
        this.minLabel = new JLabel(this.formatValue(this.model.getGlobalMin()));
        this.maxLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.minLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.sliders = new ArrayList<ChannelSlider>();
        if (!this.model.isNumerousChannel()) {
            List<ChannelData> channels = this.model.getChannelData();
            Iterator<ChannelData> i = channels.iterator();
            int columns = 0;
            while (i.hasNext()) {
                ChannelSlider slider = new ChannelSlider(this, this.model, this.controller, i.next());
                columns = Math.max(columns, slider.getColumns());
                this.sliders.add(slider);
            }
            Iterator<ChannelSlider> j = this.sliders.iterator();
            while (j.hasNext()) {
                j.next().setColumns(columns);
            }
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -1.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        if (this.model.isGeneralIndex()) {
            this.add((Component)this.buildGeneralPane(), "0, 0");
        } else {
            this.add((Component)this.buildPane(), "0, 0");
            this.add((Component)this.buildGeneralPane(), "0, 2");
        }
    }

    private JPanel buildGeneralPane() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        if (this.model.isGeneralIndex()) {
            content.add((Component)new JSeparator(), c);
            ++c.gridy;
        }
        content.add((Component)this.controlsBar, c);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            ++c.gridy;
            content.add((Component)i.next(), c);
        }
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        content.add((Component)this.viewedBy, c);
        return content;
    }

    private JPanel buildGraphicsPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        int knobWidth = this.domainSlider.getSlider().getKnobWidth();
        int knobHeight = this.domainSlider.getSlider().getKnobHeight();
        int width = this.codomainSlider.getPreferredSize().width;
        double[][] size = new double[][]{{width, (double)knobWidth / 2.0, -1.0, (double)knobWidth / 2.0}, {(double)knobHeight / 2.0, -1.0, (double)knobHeight / 2.0, (double)knobHeight + 2.0, -2.0, 5.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.add((Component)this.codomainSlider, "0, 0, 0, 2");
        p.add((Component)this.uiDelegate, "2, 1");
        p.add((Component)this.domainSlider.getSlider(), "1, 3, 3, 3");
        p.add((Component)this.controlsBar, "0, 4, 3, 4");
        return p;
    }

    private JPanel buildPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.codomainSlider);
        return p;
    }

    private JPanel buildFieldsControls() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 10.0, -1.0}, {-2.0, 5.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        JPanel panel = this.buildFieldsPanel("Min", this.minLabel, "Start", this.domainSlider.getFieldComponent(0));
        p.add((Component)panel, "0, 0");
        panel = this.buildFieldsPanel("Max", this.maxLabel, "End", this.domainSlider.getFieldComponent(1));
        p.add((Component)panel, "2, 0");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.add(p);
        return content;
    }

    private JPanel buildFieldsPanel(String txt1, JLabel l, String txt2, JComponent f) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 5.0, -2.0}, {-2.0, 5.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        JLabel label = new JLabel();
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setText(txt1);
        p.add((Component)label, "0, 0");
        p.add((Component)l, "2, 0");
        label = new JLabel();
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setText(txt2);
        p.add((Component)label, "0, 2");
        p.add((Component)f, "2, 2");
        return p;
    }

    GraphicsPane(RendererModel model, RendererControl controller) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        for (ChannelSlider slider : this.sliders) {
            slider.setSelectedChannel();
        }
    }

    void setInputInterval() {
        for (ChannelSlider slider : this.sliders) {
            int f = this.model.getRoundFactor(slider.getIndex());
            int s = (int)(this.model.getWindowStart(slider.getIndex()) * (double)f);
            int e = (int)(this.model.getWindowEnd(slider.getIndex()) * (double)f);
            slider.setInterval(s, e);
        }
    }

    void setInputRange(boolean booleanValue) {
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            i.next().setInputRange(booleanValue);
        }
    }

    void setCodomainInterval() {
        this.codomainSlider.setInterval(this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.onCurveChange();
    }

    void onCurveChange() {
        this.uiDelegate.invalidate();
        this.uiDelegate.repaint();
    }

    boolean isPaintLine() {
        return this.paintVertical() || this.paintHorizontal();
    }

    boolean isLiveUpdate() {
        return this.controlsBar.isLiveUpdate();
    }

    boolean paintVertical() {
        return this.paintVertical;
    }

    boolean paintHorizontal() {
        return this.paintHorizontal;
    }

    int getHorizontalLine() {
        return this.horizontalLine;
    }

    int getVerticalLine() {
        return this.verticalLine;
    }

    int getPartialMinimum() {
        return this.domainSlider.getSlider().getPartialMinimum();
    }

    int getPartialMaximum() {
        return this.domainSlider.getSlider().getPartialMaximum();
    }

    void onStateChange(boolean b) {
        if (this.codomainSlider != null) {
            this.codomainSlider.setEnabled(b);
        }
        if (this.domainSlider != null) {
            this.domainSlider.setEnabled(b);
        }
    }

    void setColorModelChanged() {
        if (this.sliders == null || this.sliders.size() == 0) {
            return;
        }
        Iterator<ChannelSlider> i = this.sliders.iterator();
        while (i.hasNext()) {
            i.next().setColorModelChanged();
        }
    }

    void setChannelColor(int index) {
        if (this.sliders != null && this.sliders.size() > 0) {
            for (ChannelSlider slider : this.sliders) {
                if (slider.getIndex() != index) continue;
                slider.setChannelColor();
                break;
            }
        }
        this.repaint();
    }

    void displayViewedBy(List results) {
        if (results == null) {
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator i = results.iterator();
        JPanel row = null;
        int index = 0;
        int maxPerRow = 2;
        while (i.hasNext()) {
            ViewedByItem item = (ViewedByItem)i.next();
            if (index == 0) {
                row = new JPanel();
                row.setBackground(UIUtilities.BACKGROUND_COLOR);
                row.setLayout(new FlowLayout(0));
                row.add(item);
                ++index;
                continue;
            }
            if (index == maxPerRow) {
                row.add(item);
                p.add(row);
                index = 0;
                continue;
            }
            row.add(item);
            ++index;
        }
        if (index > 0) {
            p.add(row);
        }
        this.viewedBy.removeAll();
        JPanel content = UIUtilities.buildComponentPanel(p);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.viewedBy.add((Component)content);
        this.viewedBy.setVisible(true);
        this.viewedBy.setCollapsed(false);
    }

    JComponent getCodomainSlider() {
        return this.codomainSlider;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        if (!this.controlsBar.isLiveUpdate()) {
            if ("knobReleased".equals(name)) {
                this.paintHorizontal = false;
                this.paintVertical = false;
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    int s = this.codomainSlider.getStartValue();
                    int e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            }
            if ("leftMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = (int)(this.domainSlider.getStartValue() * (double)this.domainSlider.getRoundingFactor());
                    this.paintHorizontal = false;
                    this.paintVertical = true;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getEndValue();
                    this.paintHorizontal = true;
                    this.paintVertical = false;
                    this.onCurveChange();
                }
            } else if ("rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = (int)(this.domainSlider.getEndValue() * (double)this.domainSlider.getRoundingFactor());
                    this.horizontalLine = -1;
                    this.paintHorizontal = false;
                    this.paintVertical = true;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getStartValue();
                    this.verticalLine = -1;
                    this.paintHorizontal = true;
                    this.paintVertical = false;
                    this.onCurveChange();
                }
            }
        } else {
            int e;
            int s;
            this.paintHorizontal = false;
            this.paintVertical = false;
            if ("leftMoved".equals(name) || "rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValue();
                    e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            }
            if ("knobReleased".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue());
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValue();
                    e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e);
                    this.onCurveChange();
                }
            }
        }
    }
}

