/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import omero.model.PlaneInfo;
import omero.romio.PlaneDef;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTaskPane;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.ChannelComponent;
import org.openmicroscopy.shoola.agents.metadata.util.FigureComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.ui.ChannelButton;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.DrawingComponent;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.slider.GridSlider;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;
import pojos.ChannelData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.TagAnnotationData;

public class FigureDialog
extends JDialog
implements ActionListener,
ChangeListener,
DocumentListener,
PropertyChangeListener {
    public static final int SPLIT = 0;
    public static final int SPLIT_ROI = 1;
    public static final int MOVIE = 2;
    public static final int THUMBNAILS = 3;
    public static final int ROI_MOVIE = 4;
    public static final String CREATE_FIGURE_PROPERTY = "createFigure";
    public static final String CLOSE_FIGURE_PROPERTY = "closeFigure";
    public static final int CLOSE = 0;
    public static final int SAVE = 1;
    private static final int SCALE_BAR = 2;
    private static final int ARRANGE_BY_TAGS = 3;
    private static final int PROJECTION = 4;
    private static final int ZOOM_FACTOR = 5;
    private static final int COLOR_SELECTION = 7;
    private static final int DOWNLOAD = 8;
    private static final int VIEW = 9;
    private static final int MAX_CELLS = 20;
    private static final String FRAMES_TEXT = "Number of frames: ";
    private static final String MAGNIFICATION_TEXT = "Magnification x";
    private static final String PROJECTION_DESCRIPTION = "Select the type of projection.";
    private static final String ITEMS_PER_ROW_TEXT = "Images per row";
    private static final int ITEMS_PER_ROW = 10;
    private static final int MAX_HEIGHT = 150;
    private static final double STROKE_WIDTH = 2.5;
    private static final String[] ROW_NAMES = new String[3];
    private static final String[] MAGNIFICATION;
    private static final int ZOOM_100 = 0;
    private static final int ZOOM_200 = 1;
    private static final int ZOOM_300 = 2;
    private static final int ZOOM_400 = 3;
    private static final int ZOOM_500 = 4;
    private static final int ZOOM_AUTO = 5;
    private static final int SIZE_24 = 0;
    private static final int SIZE_32 = 1;
    private static final int SIZE_48 = 2;
    private static final int SIZE_64 = 3;
    private static final int SIZE_96 = 4;
    private static final int SIZE_128 = 5;
    private static final int SIZE_160 = 6;
    private static final String[] SIZE_OPTIONS;
    private JTextField nameField;
    private TextualTwoKnobsSlider zRange;
    private JButton closeButton;
    private JButton saveButton;
    private JComboBox formats;
    private JComboBox projectionTypesBox;
    private JRadioButton splitPanelColor;
    private JRadioButton splitPanelGrey;
    private Map<Integer, Integer> projectionTypes;
    private JSpinner projectionFrequency;
    private JComboBox rowName;
    private Map<Integer, FigureComponent> components;
    private int option;
    private Renderer renderer;
    private PlaneDef pDef;
    private int thumbnailWidth;
    private int thumbnailHeight;
    private NumericalTextField widthField;
    private NumericalTextField heightField;
    private NumericalTextField scaleBar;
    private JCheckBox showScaleBar;
    private JComboBox colorBox;
    private int dialogType;
    private PixelsData pixels;
    private JXTaskPane channelsPane;
    private ROIComponent roiComponent;
    private DrawingComponent drawingComponent;
    private Dimension size;
    private JComboBox zoomBox;
    private JComboBox sizeBox;
    private NumericalTextField numberPerRow;
    private JRadioButton displayedObjects;
    private JRadioButton selectedObjects;
    private Class type;
    private JCheckBox arrangeByTags;
    private JCheckBox includeUntagged;
    private JPanel thumbnailsPane;
    private Map<JCheckBox, TagAnnotationData> tagsSelection;
    private ViewerSorter sorter;
    private JPanel selectedTags;
    private List<JCheckBox> selection;
    private JSpinner movieFrequency;
    private GridSlider movieSlider;
    private JRadioButton planeSelection;
    private JRadioButton projectionBox;
    private JComboBox timesBox;
    private JLabel generalLabel;
    private LensComponent lens;
    private BufferedImage mergeUnscaled;
    private Rectangle2D roiBox;
    private FigureComponent mergedComponent;
    private RndProxyDef rndDef;
    private List<ROI> displayedROIs;
    private double scalingFactor;
    private JPopupMenu optionMenu;
    private JButton menuButton;

    private void checkBinaryAvailability() {
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            this.saveButton.setEnabled(false);
        }
    }

    private JPopupMenu createOptionMenu() {
        if (this.optionMenu != null) {
            return this.optionMenu;
        }
        this.optionMenu = new JPopupMenu();
        this.optionMenu.add(this.createButton("Download", 8));
        this.optionMenu.add(this.createButton("View", 9));
        return this.optionMenu;
    }

    private JButton createButton(String text, int actionID) {
        JButton b = new JButton(text);
        b.setActionCommand("" + actionID);
        b.addActionListener(this);
        b.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(b);
        return b;
    }

    private String getSelectedColor() {
        int index = this.colorBox.getSelectedIndex();
        Map<Color, String> m = EditorUtil.COLORS_BAR;
        Iterator<Map.Entry<Color, String>> i = m.entrySet().iterator();
        int j = 0;
        String c = null;
        while (i.hasNext()) {
            Map.Entry<Color, String> entry = i.next();
            if (j == index) {
                c = entry.getValue();
            }
            ++j;
        }
        return c;
    }

    private Color getColor() {
        int index = this.colorBox.getSelectedIndex();
        Map<Color, String> m = EditorUtil.COLORS_BAR;
        Iterator<Map.Entry<Color, String>> i = m.entrySet().iterator();
        int j = 0;
        Color c = null;
        while (i.hasNext()) {
            Map.Entry<Color, String> entry = i.next();
            if (j == index) {
                c = entry.getKey();
            }
            ++j;
        }
        return c;
    }

    private void modifyROIDisplay() {
        if (this.displayedROIs == null) {
            return;
        }
        Color c = this.getColor();
        if (c == null) {
            return;
        }
        for (ROI roi : this.displayedROIs) {
            TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
            for (Map.Entry<Coord3D, ROIShape> entry : shapes.entrySet()) {
                ROIShape shape = entry.getValue();
                ROIFigure fig = shape.getFigure();
                AttributeKeys.STROKE_WIDTH.set(fig, (Double)2.5);
                AttributeKeys.STROKE_COLOR.set(fig, c);
            }
        }
    }

    private void setFactor() {
        int v = this.zoomBox.getSelectedIndex();
        if (v == 5) {
            int h = (Integer)this.heightField.getValueAsNumber();
            float f = (float)h / (float)this.roiBox.getHeight();
            float ff = (float)((double)Math.round(f * 100.0f) / 100.0);
            this.lens.setZoomFactor(ff);
            this.generalLabel.setText(MAGNIFICATION_TEXT + ff);
        } else {
            this.generalLabel.setText(MAGNIFICATION_TEXT + ++v);
            this.lens.setZoomFactor(v);
        }
    }

    private void setLensFactor() {
        this.setFactor();
        Iterator<Map.Entry<Integer, FigureComponent>> k = this.components.entrySet().iterator();
        List<Integer> active = this.renderer.getActiveChannels();
        while (k.hasNext()) {
            Map.Entry<Integer, FigureComponent> entry = k.next();
            int j = entry.getKey();
            FigureComponent fc = entry.getValue();
            this.lens.setPlaneImage(this.renderer.createSingleChannelImage(true, j, this.pDef));
            BufferedImage img = this.lens.getZoomedImage();
            if (img == null) continue;
            int w = img.getWidth() * this.size.width / this.pixels.getSizeX();
            int h = img.getHeight() * this.size.height / this.pixels.getSizeY();
            if (w == 0 || h == 0) continue;
            fc.setOriginalImage(Factory.scaleBufferedImage(img, w, h));
            fc.setCanvasSize(w, h);
            fc.revalidate();
            if (active.contains(j)) continue;
            fc.resetImage(true);
        }
    }

    private void layoutSelectedTags(JCheckBox selectedTag) {
        this.selectedTags.removeAll();
        if (this.selection == null) {
            this.selection = new ArrayList<JCheckBox>();
        }
        if (this.selection.contains(selectedTag)) {
            this.selection.remove(selectedTag);
        } else {
            this.selection.add(selectedTag);
        }
        Iterator<JCheckBox> i = this.selection.iterator();
        int index = 1;
        while (i.hasNext()) {
            JCheckBox box = i.next();
            JLabel label = new JLabel();
            TagAnnotationData tag = this.tagsSelection.get(box);
            label.setText(index + ". " + tag.getTagValue());
            this.selectedTags.add(label);
            ++index;
        }
        this.selectedTags.revalidate();
        this.selectedTags.repaint();
    }

    private BufferedImage getMergedImage() {
        this.mergeUnscaled = this.renderer.renderPlane(this.pDef);
        return this.scaleImage(this.mergeUnscaled);
    }

    private BufferedImage scaleImage(BufferedImage image) {
        return Factory.scaleBufferedImage(image, this.size.width, this.size.height);
    }

    private BufferedImage getChannelImage(int index, boolean scale) {
        if (this.renderer.isChannelActive(index)) {
            if (this.renderer.isMappedImageRGB(this.renderer.getActiveChannels())) {
                DataBuffer buf = !scale ? this.mergeUnscaled.getRaster().getDataBuffer() : this.mergedComponent.getDisplayedImage().getRaster().getDataBuffer();
                if (this.renderer.isColorComponent(0, index)) {
                    if (!scale) {
                        return Factory.createBandImage(buf, this.mergeUnscaled.getWidth(), this.mergeUnscaled.getHeight(), 0xFF0000, 0, 0);
                    }
                    return Factory.createBandImage(buf, this.size.width, this.size.height, 0xFF0000, 0, 0);
                }
                if (this.renderer.isColorComponent(1, index)) {
                    if (!scale) {
                        return Factory.createBandImage(buf, this.mergeUnscaled.getWidth(), this.mergeUnscaled.getHeight(), 0, 65280, 0);
                    }
                    return Factory.createBandImage(buf, this.size.width, this.size.height, 0, 65280, 0);
                }
                if (this.renderer.isColorComponent(2, index)) {
                    if (!scale) {
                        return Factory.createBandImage(buf, this.mergeUnscaled.getWidth(), this.mergeUnscaled.getHeight(), 0, 0, 255);
                    }
                    return Factory.createBandImage(buf, this.size.width, this.size.height, 0, 0, 255);
                }
            } else {
                if (!scale) {
                    this.renderer.createSingleChannelImage(true, index, this.pDef);
                }
                return this.scaleImage(this.renderer.createSingleChannelImage(true, index, this.pDef));
            }
        }
        if (!scale) {
            return this.renderer.createSingleChannelImage(true, index, this.pDef);
        }
        return this.scaleImage(this.renderer.createSingleChannelImage(true, index, this.pDef));
    }

    private void initialize() {
        this.size = Factory.computeThumbnailSize(this.thumbnailWidth, this.thumbnailHeight, this.pixels.getSizeX(), this.pixels.getSizeY());
        if (this.pDef == null) {
            this.initPlane(this.renderer.getDefaultZ(), this.renderer.getDefaultT());
        }
    }

    private double getMagnificationFactor() {
        int maxY = this.pixels.getSizeY();
        int maxX = this.pixels.getSizeX();
        if (maxX > this.thumbnailWidth || maxY > this.thumbnailHeight) {
            double ratioX = (double)this.thumbnailWidth / (double)maxX;
            double ratioY = (double)this.thumbnailHeight / (double)maxY;
            if (ratioX < ratioY) {
                return ratioX;
            }
            return ratioY;
        }
        return -1.0;
    }

    private void initChannelComponents() {
        int j;
        this.initialize();
        this.components = new LinkedHashMap<Integer, FigureComponent>();
        if (this.dialogType == 1) {
            this.initChannelComponentsForROI();
            return;
        }
        List<ChannelData> data = this.renderer.getChannelData();
        List<Integer> active = this.renderer.getActiveChannels();
        Iterator<ChannelData> k = data.iterator();
        ArrayList<ChannelButton> buttons = new ArrayList<ChannelButton>();
        while (k.hasNext()) {
            ChannelData d = k.next();
            j = d.getIndex();
            ChannelButton comp = new ChannelButton("", this.renderer.getChannelColor(j), j, active.contains(j));
            comp.setPreferredSize(FigureComponent.DEFAULT_SIZE);
            buttons.add(comp);
            comp.addPropertyChangeListener(this);
        }
        this.mergedComponent = new FigureComponent(this, buttons);
        this.mergedComponent.setCanvasSize(this.thumbnailWidth, this.thumbnailHeight);
        this.mergedComponent.setOriginalImage(this.getMergedImage());
        for (ChannelData d : data) {
            j = d.getIndex();
            FigureComponent split = new FigureComponent(this, this.renderer.getChannelColor(j), d.getChannelLabeling(), j);
            split.setSelected(true);
            split.setOriginalImage(this.getChannelImage(j, true));
            split.setCanvasSize(this.thumbnailWidth, this.thumbnailHeight);
            if (!active.contains(j)) {
                split.resetImage(true);
            }
            this.components.put(j, split);
        }
    }

    private void initChannelComponentsForROI() {
        ChannelData d;
        this.zoomBox = new JComboBox<String>(MAGNIFICATION);
        this.zoomBox.setActionCommand("5");
        this.zoomBox.addActionListener(this);
        DrawingCanvasView canvasView = this.drawingComponent.getDrawingView();
        this.scalingFactor = this.getMagnificationFactor();
        if (this.scalingFactor != -1.0) {
            canvasView.setScaleFactor(this.scalingFactor);
        }
        try {
            DefaultDrawing drawing = this.drawingComponent.getDrawing();
            TreeMap<Long, ROI> map = this.roiComponent.getROIMap();
            if (map != null && map.size() > 0) {
                for (ROI roi : map.values()) {
                    TreeMap<Coord3D, ROIShape> shapesMap = roi.getShapes();
                    for (Map.Entry<Coord3D, ROIShape> entry : shapesMap.entrySet()) {
                        Coord3D c = entry.getKey();
                        ROIShape shape = entry.getValue();
                        if (shape == null || this.roiBox != null) continue;
                        this.roiBox = shape.getBoundingBox();
                        drawing.add(shape.getFigure());
                        this.initPlane(c.getZSection(), c.getTimePoint());
                    }
                }
            }
            int rw = (int)this.roiBox.getWidth();
            int rh = (int)this.roiBox.getHeight();
            this.lens = new LensComponent((JFrame)this.getOwner(), false, rw, rh);
            this.lens.setLensLocation((int)this.roiBox.getX(), (int)this.roiBox.getY());
            this.setFactor();
            canvasView.setDrawing(drawing);
        }
        catch (Exception e) {
            // empty catch block
        }
        List<Integer> active = this.renderer.getActiveChannels();
        List<ChannelData> data = this.renderer.getChannelData();
        Iterator<ChannelData> k = data.iterator();
        ArrayList<ChannelButton> buttons = new ArrayList<ChannelButton>();
        while (k.hasNext()) {
            d = k.next();
            int j = d.getIndex();
            ChannelButton comp = new ChannelButton("", this.renderer.getChannelColor(j), j, active.contains(j));
            comp.setPreferredSize(FigureComponent.DEFAULT_SIZE);
            buttons.add(comp);
            comp.addPropertyChangeListener(this);
        }
        this.mergedComponent = new FigureComponent(this, buttons);
        this.mergedComponent.setCanvasSize(this.thumbnailWidth, this.thumbnailHeight);
        this.mergedComponent.setOriginalImage(this.getMergedImage());
        this.mergedComponent.addToView(canvasView);
        k = data.iterator();
        int w = (int)this.roiBox.getWidth() * this.size.width / this.pixels.getSizeX();
        int h = (int)this.roiBox.getHeight() * this.size.height / this.pixels.getSizeY();
        while (k.hasNext()) {
            d = k.next();
            int j = d.getIndex();
            FigureComponent split = new FigureComponent(this, this.renderer.getChannelColor(j), d.getChannelLabeling(), j);
            split.setSelected(true);
            this.lens.setPlaneImage(this.renderer.createSingleChannelImage(true, j, this.pDef));
            BufferedImage img = this.lens.getZoomedImage();
            if (img != null) {
                w = img.getWidth() * this.size.width / this.pixels.getSizeX();
                if ((img = Factory.scaleBufferedImage(img, w, h = img.getHeight() * this.size.height / this.pixels.getSizeY())) != null) {
                    w = img.getWidth();
                    h = img.getHeight();
                    split.setOriginalImage(img);
                    split.setCanvasSize(w, h);
                }
                if (!active.contains(j)) {
                    split.resetImage(true);
                }
            }
            this.components.put(j, split);
        }
    }

    private void initPlane(int z, int t) {
        this.pDef = new PlaneDef();
        this.pDef.t = t;
        this.pDef.z = z;
        this.pDef.slice = 0;
    }

    private void initComponents(String name) {
        int v;
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(108));
        this.menuButton.setText("Script");
        this.menuButton.setHorizontalTextPosition(2);
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Object src = e.getSource();
                if (src instanceof Component) {
                    Point p = e.getPoint();
                    FigureDialog.this.createOptionMenu().show((Component)src, p.x, p.y);
                }
            }
        });
        this.sorter = new ViewerSorter();
        this.closeButton = new JButton("Cancel");
        this.closeButton.setToolTipText(UIUtilities.formatToolTipText("Close the window."));
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
        this.saveButton = new JButton("Create");
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Create a figure."));
        this.saveButton.setActionCommand("1");
        this.saveButton.addActionListener(this);
        this.nameField = new JTextField();
        String s = UIUtilities.removeFileExtension(name);
        if (s != null) {
            this.nameField.setText(s);
            this.saveButton.setEnabled(true);
            this.checkBinaryAvailability();
        }
        this.nameField.getDocument().addDocumentListener(this);
        Map<Integer, String> map = FigureParam.FORMATS;
        String[] f = new String[map.size()];
        Iterator<Map.Entry<Serializable, String>> i = map.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Map.Entry<Integer, String> entry = i.next();
            v = entry.getKey();
            f[v] = entry.getValue();
            if (v == 1) {
                // empty if block
            }
            index = v;
        }
        this.formats = new JComboBox<String>(f);
        this.formats.setSelectedIndex(index);
        this.showScaleBar = new JCheckBox("Scale Bar");
        this.showScaleBar.setFont(this.showScaleBar.getFont().deriveFont(1));
        this.showScaleBar.setActionCommand("2");
        this.showScaleBar.addActionListener(this);
        this.scaleBar = new NumericalTextField();
        this.scaleBar.setText("5");
        this.colorBox = new JComboBox();
        Map<Color, String> colors = EditorUtil.COLORS_BAR;
        Object[][] cols = new Object[colors.size()][2];
        int k = 0;
        for (Map.Entry<Serializable, String> entry : colors.entrySet()) {
            cols[k] = new Object[]{entry.getKey(), entry.getValue()};
            ++k;
        }
        this.colorBox.setModel(new DefaultComboBoxModel((E[])cols));
        this.colorBox.setSelectedIndex(cols.length - 1);
        this.colorBox.setRenderer(new ColorListRenderer());
        this.colorBox.setActionCommand("7");
        this.colorBox.addActionListener(this);
        this.showScaleBar.setSelected(false);
        this.scaleBar.setEnabled(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FigureDialog.this.close();
            }
        });
        this.rowName = new JComboBox<String>(ROW_NAMES);
        ButtonGroup optionsGroups = new ButtonGroup();
        this.displayedObjects = new JRadioButton("Displayed Images");
        this.selectedObjects = new JRadioButton("Selected Images");
        optionsGroups.add(this.displayedObjects);
        optionsGroups.add(this.selectedObjects);
        this.selectedObjects.setSelected(true);
        if (this.dialogType == 3) {
            this.includeUntagged = new JCheckBox("Include all thumbnails");
            this.includeUntagged.setToolTipText("Include all remaining thumbnails not selected by Tags.");
            this.includeUntagged.setHorizontalTextPosition(2);
            this.includeUntagged.setFont(this.includeUntagged.getFont().deriveFont(1));
            this.arrangeByTags = new JCheckBox("Select by Tag");
            this.arrangeByTags.setToolTipText("Arrange the thumbnails by Tags");
            this.arrangeByTags.setHorizontalTextPosition(2);
            this.arrangeByTags.setFont(this.arrangeByTags.getFont().deriveFont(1));
            this.arrangeByTags.addActionListener(this);
            this.arrangeByTags.setActionCommand("3");
            this.sizeBox = new JComboBox<String>(SIZE_OPTIONS);
            this.sizeBox.setSelectedIndex(4);
            this.numberPerRow = new NumericalTextField(1.0, 100.0);
            this.numberPerRow.setColumns(3);
            this.numberPerRow.setText("10");
            return;
        }
        this.numberPerRow = new NumericalTextField(1.0, 100.0);
        this.numberPerRow.setColumns(3);
        this.numberPerRow.setText("10");
        this.projectionBox = new JRadioButton("Z-projection");
        this.projectionBox.addChangeListener(this);
        this.planeSelection = new JRadioButton("Last-viewed Z-section");
        this.planeSelection.addChangeListener(this);
        this.planeSelection.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.projectionBox);
        group.add(this.planeSelection);
        this.thumbnailHeight = 96;
        this.thumbnailWidth = 96;
        int maxZ = this.pixels.getSizeZ();
        this.zRange = new TextualTwoKnobsSlider(1, maxZ, 1, maxZ);
        this.zRange.layoutComponents();
        this.zRange.setEnabled(maxZ > 1);
        String[] names = new String[ProjectionParam.PROJECTIONS.size()];
        k = 0;
        i = ProjectionParam.PROJECTIONS.entrySet().iterator();
        this.projectionTypes = new HashMap<Integer, Integer>();
        while (i.hasNext()) {
            Map.Entry<Serializable, String> entry = i.next();
            int j = (Integer)entry.getKey();
            this.projectionTypes.put(k, j);
            names[k] = entry.getValue();
            ++k;
        }
        this.projectionTypesBox = new JComboBox<String>(names);
        this.projectionTypesBox.setToolTipText(PROJECTION_DESCRIPTION);
        this.projectionFrequency = new JSpinner(new SpinnerNumberModel(1, 1, maxZ + 1, 1));
        ButtonGroup g = new ButtonGroup();
        this.splitPanelGrey = new JRadioButton("Grey");
        this.splitPanelColor = new JRadioButton("Color");
        this.splitPanelColor.addChangeListener(this);
        this.splitPanelGrey.addChangeListener(this);
        g.add(this.splitPanelGrey);
        g.add(this.splitPanelColor);
        this.splitPanelColor.setSelected(true);
        int maxT = this.pixels.getSizeT();
        this.movieFrequency = new JSpinner(new SpinnerNumberModel(1, 1, maxT + 1, 1));
        this.movieFrequency.addChangeListener(this);
        this.widthField = new NumericalTextField(0.0, (double)this.pixels.getSizeX());
        this.widthField.setColumns(5);
        this.widthField.setText("" + this.pixels.getSizeX());
        this.heightField = new NumericalTextField(0.0, (double)this.pixels.getSizeY());
        this.heightField.setColumns(5);
        this.heightField.setText("" + this.pixels.getSizeY());
        this.widthField.getDocument().addDocumentListener(this);
        this.heightField.getDocument().addDocumentListener(this);
        this.movieSlider = new GridSlider(maxT, 1);
        this.movieSlider.addPropertyChangeListener("columnSelection", this);
        this.setProjectionSelected(false);
        map = FigureParam.TIMES;
        f = new String[map.size()];
        for (Map.Entry<Serializable, String> entry : map.entrySet()) {
            v = (Integer)entry.getKey();
            f[v] = entry.getValue();
        }
        this.timesBox = new JComboBox<String>(f);
        switch (this.dialogType) {
            case 2: {
                this.generalLabel = new JLabel(FRAMES_TEXT + maxT + "/" + maxT);
                break;
            }
            case 1: {
                this.generalLabel = new JLabel(MAGNIFICATION_TEXT);
                break;
            }
            default: {
                this.generalLabel = new JLabel();
            }
        }
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        String text = null;
        switch (this.dialogType) {
            case 3: {
                text = "Create a thumbnail Figure.";
                break;
            }
            case 0: 
            case 1: {
                text = "Create a Split View Figure.";
                break;
            }
            case 2: {
                text = "Create a Movie Figure.";
            }
        }
        TitlePanel tp = new TitlePanel("Create Figure", text, "The figure will be saved to the server.", icons.getIcon(81));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(5, 5));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.closeButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.saveButton);
        bar.add(Box.createHorizontalStrut(20));
        JPanel all = new JPanel();
        all.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        all.setLayout(new BoxLayout(all, 0));
        all.add(UIUtilities.buildComponentPanel(this.menuButton));
        all.add(UIUtilities.buildComponentPanelRight(bar));
        return all;
    }

    private JPanel buildDimensionComponent() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)UIUtilities.setTextFont("Panel Width: "), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        p.add((Component)this.widthField, c);
        ++c.gridx;
        p.add((Component)new JLabel("pixels"), c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)UIUtilities.setTextFont("Panel Height: "), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        p.add((Component)this.heightField, c);
        ++c.gridx;
        p.add((Component)new JLabel("pixels"), c);
        return UIUtilities.buildComponentPanel(p);
    }

    private void setProjectionSelected(boolean selected) {
        this.projectionTypesBox.setEnabled(selected);
        this.projectionFrequency.setEnabled(selected);
        this.zRange.setEnabled(selected);
        this.planeSelection.setEnabled(!selected);
    }

    private JPanel buildProjectionComponent() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        JPanel content = new JPanel();
        content.add(this.planeSelection);
        content.add(this.projectionBox);
        p.add((Component)UIUtilities.buildComponentPanel(content, 0, 0), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        p.add((Component)UIUtilities.setTextFont("Intensity"), c);
        ++c.gridx;
        p.add((Component)this.projectionTypesBox, c);
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)UIUtilities.setTextFont("Every n-th slice"), c);
        ++c.gridx;
        p.add((Component)UIUtilities.buildComponentPanel(this.projectionFrequency), c);
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)UIUtilities.setTextFont("Z-sections Range"), c);
        ++c.gridx;
        p.add((Component)UIUtilities.buildComponentPanel(this.zRange), c);
        return UIUtilities.buildComponentPanel(p);
    }

    private void onProjectionSelectionChanged() {
        boolean b = this.projectionBox.isSelected();
        if (this.projectionTypesBox != null) {
            this.projectionTypesBox.setEnabled(b);
        }
        if (this.projectionFrequency != null) {
            this.projectionFrequency.setEnabled(b);
        }
        if (this.zRange != null) {
            this.zRange.setEnabled(b);
        }
    }

    private JPanel buildTypeComponent() {
        JPanel p = new JPanel();
        double[][] tl = new double[][]{{-2.0, -2.0, -2.0, -2.0, -1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])tl));
        int i = 0;
        p.add((Component)UIUtilities.setTextFont("Name"), "0, " + i + "");
        p.add((Component)this.nameField, "1, " + i + ", 4, " + i);
        p.add((Component)UIUtilities.setTextFont("Format"), "0, " + (i += 2) + "");
        p.add((Component)this.formats, "1, " + i);
        if (this.dialogType == 3) {
            p.add((Component)UIUtilities.setTextFont("Thumbnails Size"), "0, " + (i += 2) + "");
            p.add((Component)UIUtilities.buildComponentPanel(this.sizeBox), "1, " + i);
            p.add((Component)UIUtilities.setTextFont(ITEMS_PER_ROW_TEXT), "0, " + (i += 2) + "");
            p.add((Component)UIUtilities.buildComponentPanel(this.numberPerRow), "1, " + i);
        } else {
            p.add((Component)UIUtilities.setTextFont("Image Label"), "0, " + (i += 2) + "");
            p.add((Component)this.rowName, "1, " + i);
            p.add((Component)this.showScaleBar, "0, " + (i += 2));
            p.add((Component)this.scaleBar, "1, " + i);
            p.add((Component)new JLabel("microns"), "2, " + i);
            p.add((Component)UIUtilities.setTextFont("Overlay"), "0, " + (i += 2));
            p.add((Component)UIUtilities.buildComponentPanel(this.colorBox), "1, " + i);
        }
        if (ImageData.class.equals((Object)this.type)) {
            p.add((Component)UIUtilities.setTextFont("Made of"), "0, " + (i += 2) + "," + " LEFT, TOP");
            JPanel controls = new JPanel();
            controls.setLayout(new BoxLayout(controls, 1));
            controls.add(this.displayedObjects);
            controls.add(this.selectedObjects);
            p.add((Component)UIUtilities.buildComponentPanel(controls), "1, " + i);
        }
        switch (this.dialogType) {
            case 0: {
                break;
            }
            case 2: {
                if (this.pixels.getSizeT() <= 1) break;
                p.add((Component)new JSeparator(), "0, " + ++i + ", 4, " + i);
                p.add((Component)this.buildMovieComponent(), "0, " + ++i + ", 4, " + i);
            }
        }
        return p;
    }

    private JPanel buildComponents() {
        JPanel p = new JPanel();
        double[] columns = new double[this.components.size() + 1];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = -2.0;
        }
        double[] rows = new double[]{-1.0};
        p.setLayout((LayoutManager)new TableLayout(columns, rows));
        Iterator<Map.Entry<Integer, FigureComponent>> i = this.components.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Map.Entry<Integer, FigureComponent> entry = i.next();
            FigureComponent comp = entry.getValue();
            p.add((Component)comp, index + ", 0, LEFT, TOP");
            ++index;
        }
        p.add((Component)this.mergedComponent, index + ", 0, LEFT, TOP");
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return p;
    }

    private JPanel buildChannelsComponent() {
        JPanel p = new JPanel();
        Iterator<Integer> i = this.components.keySet().iterator();
        while (i.hasNext()) {
            p.add(this.components.get(i.next()));
        }
        JPanel splitPanel = new JPanel();
        splitPanel.add(UIUtilities.setTextFont("Split Panel"));
        splitPanel.add(this.splitPanelColor);
        splitPanel.add(this.splitPanelGrey);
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0}};
        controls.setLayout((LayoutManager)new TableLayout((double[][])size));
        controls.add((Component)splitPanel, "0, 0, LEFT, CENTER");
        controls.add((Component)this.buildComponents(), "0, 2, LEFT, CENTER");
        if (this.dialogType == 1) {
            JPanel zoomPanel = new JPanel();
            zoomPanel.setLayout(new BoxLayout(zoomPanel, 0));
            zoomPanel.add(UIUtilities.setTextFont("Zoom"));
            zoomPanel.add(this.zoomBox);
            JPanel pc = new JPanel();
            pc.setLayout(new BoxLayout(pc, 1));
            pc.add(zoomPanel);
            pc.add(UIUtilities.buildComponentPanel(this.generalLabel));
            JPanel splitControls = new JPanel();
            splitControls.setLayout(new BoxLayout(splitControls, 0));
            splitControls.add(pc);
            splitControls.add(this.buildDimensionComponent());
            controls.add((Component)UIUtilities.buildComponentPanel(splitControls), "0, 4");
        } else {
            controls.add((Component)this.buildDimensionComponent(), "0, 4");
        }
        return controls;
    }

    private JPanel buildMovieComponent() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)UIUtilities.setTextFont(ITEMS_PER_ROW_TEXT), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        p.add((Component)UIUtilities.buildComponentPanel(this.numberPerRow), c);
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)UIUtilities.setTextFont("Time-point frequency"), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.movieFrequency);
        pane.add(Box.createHorizontalStrut(5));
        pane.add(this.generalLabel);
        p.add((Component)UIUtilities.buildComponentPanel(pane), c);
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)UIUtilities.setTextFont("Selected Time-points"), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        if (this.pixels.getSizeT() <= 20) {
            p.add((Component)this.movieSlider, c);
        } else {
            JScrollPane sp = new JScrollPane(this.movieSlider);
            Dimension ds = this.movieSlider.getPreferredSize();
            sp.getViewport().setPreferredSize(new Dimension(20 * GridSlider.CELL_SIZE.width, ds.height));
            p.add((Component)sp, c);
        }
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        p.add((Component)UIUtilities.setTextFont("Time units"), c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        p.add((Component)UIUtilities.buildComponentPanel(this.timesBox), c);
        controls.add(UIUtilities.buildComponentPanel(p));
        controls.add(this.buildDimensionComponent());
        return controls;
    }

    private JPanel buildBody() {
        if (this.dialogType == 3) {
            return this.buildThumbnailsPane();
        }
        double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0, -2.0}};
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        p.setLayout((LayoutManager)new TableLayout((double[][])tl));
        JXTaskPane pane = EditorUtil.createTaskPane("General");
        pane.setCollapsed(false);
        pane.add((Component)this.buildTypeComponent());
        int i = 0;
        p.add((Component)pane, "0, " + i);
        if (this.pixels.getSizeZ() > 1 && this.dialogType != 1) {
            pane = EditorUtil.createTaskPane("Z-section Selection");
            pane.add((Component)this.buildProjectionComponent());
            p.add((Component)pane, "0, " + ++i);
        }
        if (this.dialogType != 2) {
            this.channelsPane = EditorUtil.createTaskPane("Channels selection");
            this.channelsPane.setCollapsed(false);
            this.channelsPane.add((Component)this.buildDefaultPane());
            p.add((Component)this.channelsPane, "0, " + ++i);
        }
        return p;
    }

    private JPanel buildThumbnailsPane() {
        this.thumbnailsPane = new JPanel();
        this.thumbnailsPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0}};
        this.thumbnailsPane.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.thumbnailsPane.add((Component)this.buildTypeComponent(), "0, 0");
        return this.thumbnailsPane;
    }

    private JPanel buildDefaultPane() {
        JPanel p = new JPanel();
        JXBusyLabel label = new JXBusyLabel();
        label.setBusy(true);
        p.add((Component)label);
        return p;
    }

    private void close() {
        if (this.renderer != null) {
            this.renderer.resetSettings(this.rndDef, false);
        }
        this.option = 0;
        this.firePropertyChange(CLOSE_FIGURE_PROPERTY, (Object)false, (Object)true);
        this.setVisible(false);
        this.dispose();
    }

    private void collectParam(FigureParam p) {
        Number n;
        if (this.mergedComponent != null) {
            p.setMergedLabel(this.mergedComponent.isChannelsName());
        }
        p.setSelectedObjects(this.selectedObjects.isSelected());
        p.setWidth((Integer)this.widthField.getValueAsNumber());
        p.setHeight((Integer)this.heightField.getValueAsNumber());
        p.setSplitGrey(this.splitPanelGrey.isSelected());
        int scale = -1;
        if (this.showScaleBar.isSelected() && (n = this.scaleBar.getValueAsNumber()) != null) {
            scale = n.intValue();
        }
        p.setScaleBar(scale);
        p.setColor(this.getSelectedColor());
        if (this.projectionBox.isSelected()) {
            p.setZStart((int)this.zRange.getStartValue() - 1);
            p.setZEnd((int)this.zRange.getEndValue() - 1);
            p.setStepping((Integer)this.projectionFrequency.getValue());
            p.setProjectionType(this.projectionTypes.get(this.projectionTypesBox.getSelectedIndex()));
        } else {
            p.setZStart(-1);
            p.setZEnd(-1);
            p.setStepping(1);
            p.setProjectionType(ProjectionParam.MAXIMUM_INTENSITY);
        }
    }

    private FigureParam saveSplitFigure() {
        LinkedHashMap<Integer, String> split = new LinkedHashMap<Integer, String>();
        ArrayList<Integer> splitActive = new ArrayList<Integer>();
        for (Map.Entry<Integer, FigureComponent> entry : this.components.entrySet()) {
            FigureComponent comp = entry.getValue();
            split.put(entry.getKey(), comp.getLabel());
            if (!comp.isSelected()) continue;
            splitActive.add(entry.getKey());
        }
        LinkedHashMap<Integer, Color> merge = new LinkedHashMap<Integer, Color>();
        List<Integer> active = this.renderer.getActiveChannels();
        Iterator<Object> i = active.iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            merge.put(index, this.renderer.getChannelColor(index));
        }
        String name = this.nameField.getText().trim();
        int format = this.formats.getSelectedIndex();
        int label = this.rowName.getSelectedIndex();
        FigureParam p = new FigureParam(format, name, split, merge, label);
        p.setSplitActive(splitActive);
        this.collectParam(p);
        return p;
    }

    private FigureParam saveROIFigure() {
        LinkedHashMap<Integer, String> split = new LinkedHashMap<Integer, String>();
        ArrayList<Integer> splitActive = new ArrayList<Integer>();
        for (Map.Entry<Integer, FigureComponent> entry : this.components.entrySet()) {
            FigureComponent comp = entry.getValue();
            split.put(entry.getKey(), comp.getLabel());
            if (!comp.isSelected()) continue;
            splitActive.add(entry.getKey());
        }
        LinkedHashMap<Integer, Color> merge = new LinkedHashMap<Integer, Color>();
        List<Integer> active = this.renderer.getActiveChannels();
        Iterator<Object> i = active.iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            merge.put(index, this.renderer.getChannelColor(index));
        }
        String name = this.nameField.getText().trim();
        int format = this.formats.getSelectedIndex();
        int label = this.rowName.getSelectedIndex();
        FigureParam p = new FigureParam(format, name, split, merge, label);
        p.setSplitActive(splitActive);
        p.setIndex(1);
        this.collectParam(p);
        double zoom = 0.0;
        switch (this.zoomBox.getSelectedIndex()) {
            case 0: {
                zoom = 1.0;
                break;
            }
            case 1: {
                zoom = 2.0;
                break;
            }
            case 2: {
                zoom = 3.0;
                break;
            }
            case 3: {
                zoom = 4.0;
                break;
            }
            case 4: {
                zoom = 5.0;
            }
        }
        p.setMagnificationFactor(zoom);
        return p;
    }

    private FigureParam saveMovieFigure() {
        String name = this.nameField.getText().trim();
        int format = this.formats.getSelectedIndex();
        int label = this.rowName.getSelectedIndex();
        FigureParam p = new FigureParam(format, name, label);
        p.setIndex(3);
        p.setTime(this.timesBox.getSelectedIndex());
        p.setTimepoints(this.sorter.sort(this.movieSlider.getSelectedCells()));
        Number n = this.numberPerRow.getValueAsNumber();
        if (n != null && n instanceof Integer) {
            p.setHeight((Integer)n);
        }
        this.collectParam(p);
        return p;
    }

    private FigureParam saveThumbnailsFigure() {
        String name = this.nameField.getText().trim();
        int format = this.formats.getSelectedIndex();
        FigureParam p = new FigureParam(format, name);
        p.setIndex(2);
        int width = 96;
        switch (this.sizeBox.getSelectedIndex()) {
            case 0: {
                width = 24;
                break;
            }
            case 1: {
                width = 32;
                break;
            }
            case 2: {
                width = 48;
                break;
            }
            case 3: {
                width = 64;
                break;
            }
            case 4: {
                width = 96;
                break;
            }
            case 5: {
                width = 128;
                break;
            }
            case 6: {
                width = 160;
            }
        }
        Number n = this.numberPerRow.getValueAsNumber();
        if (n != null && n instanceof Integer) {
            p.setHeight((Integer)n);
        }
        p.setWidth(width);
        p.setSelectedObjects(this.selectedObjects.isSelected());
        if (this.includeUntagged != null) {
            p.setIncludeUntagged(this.includeUntagged.isSelected());
        }
        if (this.arrangeByTags.isSelected() && this.selection != null && this.selection.size() > 0) {
            Iterator<JCheckBox> i = this.selection.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                JCheckBox box = i.next();
                TagAnnotationData tag = this.tagsSelection.get(box);
                ids.add(tag.getId());
            }
            p.setTags(ids);
        }
        return p;
    }

    private void save() {
        FigureParam p = null;
        switch (this.dialogType) {
            case 0: {
                p = this.saveSplitFigure();
                break;
            }
            case 1: {
                p = this.saveROIFigure();
                break;
            }
            case 2: {
                p = this.saveMovieFigure();
                break;
            }
            case 3: {
                p = this.saveThumbnailsFigure();
            }
        }
        this.close();
        if (p != null) {
            this.firePropertyChange(CREATE_FIGURE_PROPERTY, null, p);
        }
    }

    private void handleText() {
        String text = this.nameField.getText();
        this.saveButton.setEnabled(text != null && text.trim().length() != 0);
        switch (this.dialogType) {
            case 0: 
            case 1: {
                this.saveButton.setEnabled(this.renderer != null);
            }
        }
        this.checkBinaryAvailability();
    }

    private void handleDimensionChange(NumericalTextField field) {
        Integer n = (Integer)field.getValueAsNumber();
        if (n == null) {
            return;
        }
        int v = n * this.pixels.getSizeX() / this.pixels.getSizeY();
        if (field == this.widthField) {
            Document doc = this.heightField.getDocument();
            doc.removeDocumentListener(this);
            this.heightField.setText("" + v);
            doc.addDocumentListener(this);
        } else {
            Document doc = this.widthField.getDocument();
            doc.removeDocumentListener(this);
            this.widthField.setText("" + v);
            doc.addDocumentListener(this);
        }
        this.setMergedImageForSplitROI(this.mergeUnscaled);
    }

    private void setMergedImageForSplitROI(BufferedImage image) {
        if (this.dialogType != 1) {
            return;
        }
        int w = (Integer)this.widthField.getValueAsNumber();
        if (w <= 0) {
            return;
        }
        int h = (Integer)this.heightField.getValueAsNumber();
        if (h <= 0) {
            return;
        }
        int x = w * this.thumbnailWidth / this.pixels.getSizeX();
        int y = w * this.thumbnailHeight / this.pixels.getSizeY();
        if (x == 0 || y == 0) {
            return;
        }
        this.mergedComponent.setOriginalImage(Factory.scaleBufferedImage(image, x, y));
        Dimension d = new Dimension(x, y);
        DrawingCanvasView canvasView = this.drawingComponent.getDrawingView();
        double r = (double)w / (double)this.pixels.getSizeX();
        double f = this.scalingFactor * r;
        if (f != -1.0) {
            canvasView.setScaleFactor(f, d);
        }
        if (this.zoomBox.getSelectedIndex() == 5) {
            this.setLensFactor();
        }
        this.mergedComponent.setCanvasSize(x, y);
    }

    private String getScriptName() {
        switch (this.dialogType) {
            case 0: {
                return "/omero/figure_scripts/Split_View_Figure.py";
            }
            case 1: {
                return "/omero/figure_scripts/ROI_Split_Figure.py";
            }
            case 2: {
                return "/omero/figure_scripts/Movie_Figure.py";
            }
            case 3: {
                return "/omero/figure_scripts/Thumbnail_Figure.py";
            }
        }
        return "";
    }

    public static boolean needPixels(int index) {
        switch (index) {
            case 3: {
                return false;
            }
        }
        return true;
    }

    public FigureDialog(JFrame owner, String name, PixelsData pixels, int index, Class type) {
        super((Frame)owner, true);
        this.type = type;
        this.pixels = pixels;
        this.dialogType = index;
        this.initComponents(name);
        this.buildGUI();
        this.setSize(500, 700);
    }

    BufferedImage createSingleGreyScaleImage(int channel) {
        return this.scaleImage(this.renderer.createSingleChannelImage(false, channel, this.pDef));
    }

    void setChannelSelection(int channel, boolean active, boolean merged) {
        this.renderer.setActive(channel, active);
        if (this.dialogType == 1) {
            this.setMergedImageForSplitROI(this.getMergedImage());
        } else {
            this.mergedComponent.setOriginalImage(this.getMergedImage());
        }
        List<Integer> actives = this.renderer.getActiveChannels();
        for (ChannelButton cb : this.mergedComponent.getChannels()) {
            int v = cb.getChannelIndex();
            cb.setSelected(actives.contains(v));
        }
        FigureComponent comp = this.components.get(channel);
        switch (this.dialogType) {
            case 0: 
            case 1: {
                boolean grey = this.splitPanelGrey.isSelected();
                if (active) {
                    if (grey) {
                        comp.resetImage(grey);
                    } else {
                        comp.resetImage(!active);
                    }
                } else {
                    comp.resetImage(!active);
                }
                if (merged) break;
                comp.setSelected(active);
            }
        }
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("No renderer.");
        }
        this.renderer = renderer;
        this.rndDef = renderer.getRndSettingsCopy();
        this.channelsPane.removeAll();
        switch (this.dialogType) {
            case 0: 
            case 1: {
                this.initChannelComponents();
                this.channelsPane.add((Component)this.buildChannelsComponent());
                this.saveButton.setEnabled(true);
                this.checkBinaryAvailability();
                this.pack();
            }
        }
    }

    public void setTags(Collection tags) {
        if (tags == null || tags.size() == 0) {
            return;
        }
        if (this.thumbnailsPane == null) {
            return;
        }
        JPanel p = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.tagsSelection = new LinkedHashMap<JCheckBox, TagAnnotationData>();
        List l = this.sorter.sort(tags);
        Iterator i = l.iterator();
        JPanel tagPane = new JPanel();
        tagPane.setLayout(new BoxLayout(tagPane, 1));
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FigureDialog.this.layoutSelectedTags((JCheckBox)e.getSource());
            }
        };
        while (i.hasNext()) {
            TagAnnotationData tag = (TagAnnotationData)i.next();
            JCheckBox box = new JCheckBox(tag.getTagValue());
            box.setEnabled(false);
            box.addActionListener(listener);
            this.tagsSelection.put(box, tag);
            tagPane.add(box);
        }
        this.selectedTags = new JPanel();
        this.selectedTags.setLayout(new BoxLayout(this.selectedTags, 1));
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(UIUtilities.buildComponentPanel(this.arrangeByTags));
        controls.add(UIUtilities.buildComponentPanel(this.includeUntagged));
        p.add((Component)controls, "0, 0, LEFT, TOP");
        p.add((Component)this.selectedTags, "0, 1, LEFT, TOP");
        JScrollPane pane = new JScrollPane(tagPane);
        Dimension d = pane.getPreferredSize();
        pane.setPreferredSize(new Dimension(d.width, 150));
        p.add((Component)pane, "1, 0, 1, 1");
        this.thumbnailsPane.add((Component)p, "0, 1");
        this.thumbnailsPane.revalidate();
        this.thumbnailsPane.repaint();
    }

    public boolean setROIs(Collection rois) {
        if (rois == null) {
            return false;
        }
        this.drawingComponent = new DrawingComponent();
        this.drawingComponent.getDrawingView().setScaleFactor(1.0);
        this.roiComponent = new ROIComponent();
        Iterator r = rois.iterator();
        int count = 0;
        try {
            long userID = MetadataViewerAgent.getUserDetails().getId();
            while (r.hasNext()) {
                ROIResult result = (ROIResult)r.next();
                Collection list = result.getROIs();
                if (list.size() > 0) {
                    ++count;
                }
                this.displayedROIs = this.roiComponent.loadROI(result.getFileID(), list, true, userID);
                this.modifyROIDisplay();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return count != 0;
    }

    public void setParentRef(Object parentRef) {
        if (parentRef instanceof DatasetData) {
            this.nameField.setText(((DatasetData)parentRef).getName());
        }
    }

    public void setPlaneInfo(Collection planes) {
        if (planes == null) {
            return;
        }
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        Iterator i = planes.iterator();
        String value = "";
        while (i.hasNext()) {
            PlaneInfo pi = (PlaneInfo)i.next();
            Map<String, Object> details = EditorUtil.transformPlaneInfo(pi);
            List notSet = (List)details.get("NotSet");
            if (notSet.contains("DeltaT")) continue;
            value = EditorUtil.formatTimeInSeconds((Double)details.get("DeltaT"));
            values.put(pi.getTheT().getValue(), value);
        }
        this.movieSlider.setCellNames(values);
    }

    public int centerDialog() {
        UIUtilities.centerAndShow(this);
        return this.option;
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.scaleBar.setEnabled(this.showScaleBar.isSelected());
                break;
            }
            case 3: {
                boolean b = this.arrangeByTags.isSelected();
                Iterator<JCheckBox> i = this.tagsSelection.keySet().iterator();
                while (i.hasNext()) {
                    i.next().setEnabled(b);
                }
                break;
            }
            case 4: {
                this.setProjectionSelected(this.projectionBox.isSelected());
                break;
            }
            case 5: {
                this.setLensFactor();
                break;
            }
            case 7: {
                this.modifyROIDisplay();
                break;
            }
            case 8: {
                this.firePropertyChange("downloadSelectedScript", null, this.getScriptName());
                break;
            }
            case 9: {
                this.firePropertyChange("viewSelectedScript", null, this.getScriptName());
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.nameField.getDocument()) {
            this.handleText();
        } else if (doc == this.widthField.getDocument()) {
            this.handleDimensionChange(this.widthField);
        } else {
            this.handleDimensionChange(this.heightField);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.nameField.getDocument()) {
            this.handleText();
        } else if (doc == this.widthField.getDocument()) {
            this.handleDimensionChange(this.widthField);
        } else {
            this.handleDimensionChange(this.heightField);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("channelSelected".equals(name)) {
            Map map = (Map)evt.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Integer index = (Integer)entry.getKey();
                this.setChannelSelection(index, (Boolean)entry.getValue(), true);
            }
        } else if ("channelSelection".equals(name)) {
            ChannelComponent c = (ChannelComponent)evt.getNewValue();
            this.setChannelSelection(c.getChannelIndex(), c.isActive(), true);
        } else if ("columnSelection".equals(name)) {
            int maxT = this.pixels.getSizeT();
            this.generalLabel.setText(FRAMES_TEXT + this.movieSlider.getNumberOfSelectedCells() + "/" + maxT);
            this.generalLabel.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.projectionBox || src == this.planeSelection) {
            this.onProjectionSelectionChanged();
            return;
        }
        switch (this.dialogType) {
            case 0: 
            case 1: {
                if (src != this.splitPanelGrey) break;
                boolean grey = this.splitPanelGrey.isSelected();
                if (this.components == null) {
                    return;
                }
                Iterator<Integer> i = this.components.keySet().iterator();
                List<Integer> active = this.renderer.getActiveChannels();
                while (i.hasNext()) {
                    Integer index = i.next();
                    FigureComponent comp = this.components.get(index);
                    if (grey) {
                        comp.resetImage(grey);
                        continue;
                    }
                    if (active.contains(index)) {
                        comp.resetImage(grey);
                        continue;
                    }
                    comp.resetImage(!grey);
                }
                break;
            }
            case 2: {
                if (src != this.movieFrequency) break;
                Integer value = (Integer)this.movieFrequency.getValue();
                this.movieSlider.selectCells(value);
                this.generalLabel.setText(FRAMES_TEXT + this.movieSlider.getNumberOfSelectedCells() + "/" + this.pixels.getSizeT());
                this.generalLabel.repaint();
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    static {
        FigureDialog.ROW_NAMES[0] = "Image's name";
        FigureDialog.ROW_NAMES[1] = "Datasets";
        FigureDialog.ROW_NAMES[2] = "Tags";
        MAGNIFICATION = new String[6];
        FigureDialog.MAGNIFICATION[0] = "100%";
        FigureDialog.MAGNIFICATION[1] = "200%";
        FigureDialog.MAGNIFICATION[2] = "300%";
        FigureDialog.MAGNIFICATION[3] = "400%";
        FigureDialog.MAGNIFICATION[4] = "500%";
        FigureDialog.MAGNIFICATION[5] = "Zoom To Fit";
        SIZE_OPTIONS = new String[7];
        FigureDialog.SIZE_OPTIONS[0] = "24x24";
        FigureDialog.SIZE_OPTIONS[1] = "32x32";
        FigureDialog.SIZE_OPTIONS[2] = "48x48";
        FigureDialog.SIZE_OPTIONS[3] = "64x64";
        FigureDialog.SIZE_OPTIONS[4] = "96x96";
        FigureDialog.SIZE_OPTIONS[5] = "128x128";
        FigureDialog.SIZE_OPTIONS[6] = "160x160";
    }
}

