/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.ExperimenterData;

public class AdminCreator
extends DataTreeViewerLoader {
    private AdminObject object;
    private CallHandle handle;

    public AdminCreator(TreeViewer viewer, AdminObject object) {
        super(viewer);
        if (object == null) {
            throw new IllegalArgumentException("No object");
        }
        this.object = object;
    }

    public void load() {
        switch (this.object.getIndex()) {
            case 0: {
                this.handle = this.adminView.createGroup(this.object, this);
                break;
            }
            case 1: {
                this.handle = this.adminView.createExperimenters(this.object, this);
                break;
            }
            case 4: {
                this.handle = this.adminView.resetExperimentersPassword(this.object, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        switch (this.object.getIndex()) {
            case 0: 
            case 1: {
                this.viewer.refreshTree();
                break;
            }
            case 4: {
                List l = (List)result;
                if (l.size() == 0) break;
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                Iterator i = l.iterator();
                String s = "";
                while (i.hasNext()) {
                    ExperimenterData exp = (ExperimenterData)i.next();
                    s = s + exp.getUserName() + "\n";
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("The password could not be reset for ");
                buffer.append("the following experimenters:\n");
                buffer.append(s);
                un.notifyInfo("Reset password", buffer.toString());
            }
        }
    }
}

