/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

public class BrowserManageAction
extends BrowserAction
implements MouseListener {
    public static final int NEW_TAGS = 0;
    public static final int NEW_CONTAINERS = 1;
    public static final int NEW_ADMIN = 2;
    private static final String DESCRIPTION_CONTAINERS = "Create new Project, Dataset or Screen.";
    private static final String DESCRIPTION_TAGS = "Create new Tag Set or Tag";
    private static final String DESCRIPTION_ADMIN = "Create new Group or User.";
    private Point point;
    private int index;

    private void checkIndex(int index) {
        IconManager im = IconManager.getInstance();
        switch (index) {
            case 1: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_CONTAINERS));
                break;
            }
            case 0: {
                this.putValue("SmallIcon", im.getIcon(69));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAGS));
                break;
            }
            case 2: {
                this.putValue("SmallIcon", im.getIcon(11));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_ADMIN));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private void handleExperimenter(TreeImageDisplay display) {
        if (display == null) {
            this.setEnabled(true);
        } else {
            Object ho = display.getUserObject();
            long id = TreeViewerAgent.getUserDetails().getId();
            if (ho instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)ho;
                this.setEnabled(exp.getId() == id);
            }
        }
    }

    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (this.model.getBrowserType() == 107) {
            this.setEnabled(TreeViewerAgent.isAdministrator());
            return;
        }
        if (selectedDisplay == null) {
            this.handleExperimenter(this.model.getLastSelectedDisplay());
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ExperimenterData) {
            this.handleExperimenter(selectedDisplay);
            return;
        }
        this.setEnabled(this.model.isUserOwner(ho));
    }

    public BrowserManageAction(Browser model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        this.setEnabled(true);
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (this.point == null) {
            this.point = me.getPoint();
        }
        if (source instanceof Component && this.isEnabled()) {
            switch (this.index) {
                case 0: {
                    this.model.showMenu(4, (Component)source, this.point);
                    break;
                }
                case 1: {
                    if (this.model.getBrowserType() == 100) {
                        this.model.showMenu(3, (Component)source, this.point);
                        break;
                    }
                    this.model.showMenu(8, (Component)source, this.point);
                    break;
                }
                case 2: {
                    this.model.showMenu(6, (Component)source, this.point);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

