/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.util.PasswordDialog;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

public class BrowserPasswordResetAction
extends BrowserAction {
    private static final String DESCRIPTION = "Resets the password of the selected experimenters.";

    protected void onStateChange() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (this.model.getBrowserType() != 107) {
                    this.setEnabled(false);
                    break;
                }
                this.onDisplayChange(this.model.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.isAdministrator() || selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (this.model.getBrowserType() != 107) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selectedDisplay.getUserObject() instanceof ExperimenterData);
    }

    public BrowserPasswordResetAction(Browser model) {
        super(model);
        this.setEnabled(false);
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(122));
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
    }

    public void actionPerformed(ActionEvent e) {
        JFrame f = TreeViewerAgent.getRegistry().getTaskBar().getFrame();
        PasswordDialog d = new PasswordDialog(f);
        d.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("resetPassword".equals(evt.getPropertyName())) {
                    String value = (String)evt.getNewValue();
                    BrowserPasswordResetAction.this.model.resetPassword(value);
                }
            }
        });
        UIUtilities.centerAndShow(d);
    }
}

