/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class CreateAction
extends TreeViewerAction {
    private static final String NAME = "New...";
    private static final String NAME_DATASET = "New Dataset...";
    private static final String NAME_TAG = "New Tag...";
    private static final String NAME_IMAGE = "New...";
    private static final String DESCRIPTION_TAG = "Create a new Tag and add it to the selected Tag Set.";
    private static final String DESCRIPTION_DATASET = "Create a new Dataset and add it to the selected Project.";
    private static final String DESCRIPTION_IMAGE = "Import the selected images.";
    private static final String DESCRIPTION = "Create a new element.";
    private int nodeType;
    private boolean chooser;

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        this.chooser = true;
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(11));
        Browser browser = this.model.getSelectedBrowser();
        if (selectedDisplay == null || browser == null) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes.length > 1) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.isUserOwner(ho));
            this.name = NAME_DATASET;
            this.nodeType = 1;
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
        } else if (ho instanceof ScreenData || ho instanceof DatasetData) {
            this.setEnabled(false);
            this.nodeType = 5;
            this.putValue("SmallIcon", im.getIcon(90));
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else if (ho instanceof TagAnnotationData) {
            String ns = ((TagAnnotationData)ho).getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.setEnabled(this.model.isUserOwner(ho));
                this.nodeType = 2;
                this.putValue("SmallIcon", im.getIcon(69));
                this.name = NAME_TAG;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG));
            } else {
                this.setEnabled(false);
                this.name = "New...";
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            }
        } else if (ho instanceof ImageData) {
            this.setEnabled(false);
            this.nodeType = 5;
            this.putValue("SmallIcon", im.getIcon(90));
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else {
            this.setEnabled(false);
            this.name = "New...";
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public CreateAction(TreeViewer model) {
        super(model);
        this.name = "New...";
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(11));
    }

    public void actionPerformed(ActionEvent e) {
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType, this.chooser);
        cmd.execute();
    }
}

