/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.FileAnnotationData;
import pojos.ImageData;

public class DownloadAction
extends TreeViewerAction {
    private static final String NAME = "Download...";
    private static final String DESCRIPTION = "Download the selected files.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(false);
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof FileAnnotationData) {
            this.setEnabled(true);
        } else if (ho instanceof ImageData) {
            ImageData img = (ImageData)ho;
            this.setEnabled(img.isArchived());
        }
    }

    public DownloadAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(108));
    }

    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay node = browser.getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        TreeImageDisplay[] l = browser.getSelectedDisplays();
        Object ho = node.getUserObject();
        String name = null;
        String text = "file";
        if (ho instanceof FileAnnotationData) {
            name = ((FileAnnotationData)ho).getFileName();
        } else if (ho instanceof ImageData) {
            text = "image";
            name = ((ImageData)ho).getName();
        }
        if (name == null) {
            return;
        }
        if (l.length > 1) {
            text = text + "s";
        }
        JFrame f = TreeViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the " + text + ".", null, true);
        chooser.setSelectedFileFull(name);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(109));
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File folder = (File)evt.getNewValue();
                    if (folder == null) {
                        folder = UIUtilities.getDefaultFolder();
                    }
                    DownloadAction.this.model.download(folder);
                }
            }
        });
        chooser.centerDialog();
    }
}

