/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class RefreshTreeAction
extends TreeViewerAction {
    private static final String NAME = "Refresh current tree";
    private static final String DESCRIPTION = "Refresh the tree.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(true);
            }
        }
    }

    public RefreshTreeAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(10));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.refreshTree();
    }
}

