/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;

public abstract class TreeViewerAction
extends AbstractAction
implements ChangeListener,
PropertyChangeListener {
    protected TreeViewer model;
    protected String name;
    protected String description;

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
    }

    protected void onBrowserStateChange(Browser browser) {
    }

    protected void onBrowserSelection(Browser browser) {
    }

    protected void onDisplayMode() {
    }

    protected void onDataImport() {
    }

    public TreeViewerAction(TreeViewer model) {
        this.setEnabled(false);
        if (model == null) {
            throw new IllegalArgumentException("no TreeViewer");
        }
        this.model = model;
        model.addPropertyChangeListener(this);
        Map browsers = model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener("selectedTreeNodeDisplay", this);
            browser.addChangeListener(this);
        }
    }

    public String getActionName() {
        if (this.name == null || this.name.length() == 0) {
            return (String)this.getValue("Name");
        }
        return this.name;
    }

    public String getActionDescription() {
        if (this.description == null || this.description.length() == 0) {
            return (String)this.getValue("ShortDescription");
        }
        return this.description;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selectedBrowser".equals(name)) {
            this.onBrowserSelection((Browser)evt.getNewValue());
        } else if ("searchMode".equals(name)) {
            int displayMode = (Integer)evt.getNewValue();
            switch (displayMode) {
                case 101: {
                    this.setEnabled(true);
                    break;
                }
                case 100: {
                    this.setEnabled(true);
                    Browser browser = this.model.getSelectedBrowser();
                    TreeImageDisplay v = null;
                    if (browser != null) {
                        v = browser.getLastSelectedDisplay();
                    }
                    this.onBrowserStateChange(browser);
                    this.onDisplayChange(v);
                }
            }
            this.onDisplayMode();
        } else if ("onComponentStateChanged".equals(name) || "groupChanged".equals(name) || "selection".equals(name) || "selectedTreeNodeDisplay".equals(name)) {
            Browser browser = this.model.getSelectedBrowser();
            TreeImageDisplay v = null;
            if (browser != null) {
                v = browser.getLastSelectedDisplay();
            }
            this.onDisplayChange(v);
        } else if ("importImages".equals(name)) {
            this.onDataImport();
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof Browser) {
            this.onBrowserStateChange((Browser)source);
        }
    }
}

