/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.util.DataPane;
import org.openmicroscopy.shoola.agents.treeviewer.util.ExperimenterPane;
import org.openmicroscopy.shoola.agents.treeviewer.util.GroupPane;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.GroupData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final String CREATE_ADMIN_PROPERTY = "createAdmin";
    static final String ENABLE_SAVE_PROPERTY = "enableSave";
    private static final String TITLE_GROUP = "Create Group";
    private static final String TITLE_EXPERIMENTER = "Create Experimenter";
    private static final String TEXT_GROUP = "Create a new group";
    private static final String TEXT_EXPERIMENTER = "Create a new Experimenter.";
    private static final int CANCEL = 0;
    private static final int SAVE = 1;
    private JButton cancel;
    private JButton save;
    private Class type;
    private Object parent;
    private DataPane body;

    private void initComponents() {
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("0");
        this.cancel.addActionListener(this);
        this.save = new JButton("Create");
        this.save.setActionCommand("1");
        this.save.addActionListener(this);
        this.save.setEnabled(false);
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isExistingObject(String name, boolean group) {
        AdminService svc = TreeViewerAgent.getRegistry().getAdminService();
        try {
            if (group) {
                return svc.lookupGroup(name) != null;
            }
            return svc.lookupExperimenter(name) != null;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void notifyUser(boolean group) {
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        StringBuffer text = new StringBuffer();
        if (group) {
            text.append("This Group name already exists.");
        } else {
            text.append("This Experimenter name already exists.");
        }
        text.append("\nPlease choose another name.");
        un.notifyInfo("Admin Error", text.toString());
    }

    private void save() {
        AdminObject object = null;
        if (this.body instanceof GroupPane) {
            object = ((GroupPane)this.body).getObjectToSave();
        } else if (this.body instanceof ExperimenterPane) {
            ExperimenterPane pane = (ExperimenterPane)this.body;
            Map<ExperimenterData, UserCredentials> m = pane.getObjectToSave();
            if (m.size() == 0) {
                return;
            }
            object = new AdminObject(m, 1);
            object.setGroups(pane.getSelectedGroups());
        }
        if (object == null) {
            return;
        }
        boolean b = false;
        switch (object.getIndex()) {
            case 0: {
                b = this.isExistingObject(object.getGroup().getName(), true);
                if (b) {
                    this.notifyUser(true);
                    return;
                }
                Map<ExperimenterData, UserCredentials> map = object.getExperimenters();
                if (map == null) break;
                Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = map.entrySet().iterator();
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                while (i.hasNext()) {
                    String password;
                    Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
                    UserCredentials uc = entry.getValue();
                    b = this.isExistingObject(uc.getUserName(), false);
                    if (b || (password = uc.getPassword()) != null && password.length() != 0) continue;
                    StringBuffer text = new StringBuffer();
                    text.append("No Password set for the new Experimenter.");
                    text.append("\nPlease enter one.");
                    un.notifyInfo("Admin Error", text.toString());
                    return;
                }
                break;
            }
            case 1: {
                Map<ExperimenterData, UserCredentials> map = object.getExperimenters();
                for (Map.Entry<ExperimenterData, UserCredentials> entry : map.entrySet()) {
                    UserCredentials uc = entry.getValue();
                    b = this.isExistingObject(uc.getUserName(), false);
                    if (!b) continue;
                    this.notifyUser(false);
                    return;
                }
                break;
            }
        }
        this.firePropertyChange(CREATE_ADMIN_PROPERTY, null, object);
        this.cancel();
    }

    private void setProperties(Class type) {
        this.setModal(true);
        if (GroupData.class.equals((Object)type)) {
            this.setTitle(TITLE_GROUP);
        } else if (ExperimenterData.class.equals((Object)type)) {
            this.setTitle(TITLE_EXPERIMENTER);
        } else {
            new IllegalArgumentException("Type not supported/");
        }
    }

    private TitlePanel createHeader() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = null;
        if (GroupData.class.equals((Object)this.type)) {
            tp = new TitlePanel(this.getTitle(), TEXT_GROUP, icons.getIcon(113));
        } else if (ExperimenterData.class.equals((Object)this.type)) {
            String text = TEXT_EXPERIMENTER;
            if (this.parent instanceof GroupData) {
                text = text + ((GroupData)this.parent).getName();
            }
            tp = new TitlePanel(this.getTitle(), text, icons.getIcon(56));
        }
        return tp;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.save);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        bar.add(this.cancel);
        bar.add(Box.createRigidArea(UIUtilities.H_SPACER_SIZE));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        c.add((Component)((Object)this.createHeader()), "North");
        c.add((Component)this.body, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public AdminDialog(JFrame owner, Class type, Object parent, Collection<DataObject> groups) {
        super(owner);
        this.setProperties(type);
        this.type = type;
        this.parent = parent;
        if (ExperimenterData.class.equals((Object)type)) {
            ArrayList<DataObject> selected = null;
            if (parent instanceof GroupData) {
                DataObject p = (DataObject)parent;
                selected = new ArrayList<DataObject>();
                selected.add(p);
                Iterator<DataObject> i = groups.iterator();
                DataObject toRemove = null;
                while (i.hasNext()) {
                    DataObject data = i.next();
                    if (data.getId() != p.getId()) continue;
                    toRemove = data;
                    break;
                }
                if (toRemove != null) {
                    groups.remove(toRemove);
                }
            }
            this.body = new ExperimenterPane(true, groups, selected);
        } else if (GroupData.class.equals((Object)type)) {
            this.body = new GroupPane();
        }
        this.body.addPropertyChangeListener(this);
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.cancel();
                break;
            }
            case 1: {
                this.save();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (ENABLE_SAVE_PROPERTY.equals(name)) {
            this.save.setEnabled((Boolean)evt.getNewValue());
        }
    }
}

