/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.CppFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JavaFilter;
import org.openmicroscopy.shoola.util.filter.file.MatlabFilter;
import org.openmicroscopy.shoola.util.filter.file.PythonFilter;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUploaderDialog
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String UPLOAD_SCRIPT_PROPERTY = "uploadScript";
    private static final String SEPARATOR = ", ";
    private static final Dimension H_SPACER_SIZE = new Dimension(3, 10);
    private static final String TITLE = "Upload Script";
    private static final String TEXT = "Select the script to upload";
    private static final int SAVE = 0;
    private static final int CANCEL = 1;
    private static final List<CustomizedFileFilter> FILTERS = new ArrayList<CustomizedFileFilter>();
    private JFileChooser chooser;
    private JButton saveButton;
    private JButton cancelButton;
    private JTextField author;
    private JTextField eMail;
    private JTextField institution;
    private JTextField description;
    private JTextField journalRef;
    private JTextField scriptArea;
    private JTextField location;
    private JButton locationFinder;
    private Map<Long, String> scripts;
    private List<String> folders;
    private JPopupMenu menu;

    private void initComponents() {
        this.folders = new ArrayList<String>();
        if (this.scripts != null) {
            for (Map.Entry<Long, String> entry : this.scripts.entrySet()) {
                String value;
                String[] values = UIUtilities.splitString(entry.getValue());
                if (values == null || values.length <= 1 || this.folders.contains(value = values[values.length - 2])) continue;
                this.folders.add(value);
            }
        }
        this.chooser = new JFileChooser();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setDialogType(1);
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        while (i.hasNext()) {
            this.chooser.addChoosableFileFilter(i.next());
        }
        this.chooser.setControlButtonsAreShown(false);
        this.saveButton = new JButton("Upload");
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText("Upload the selected script to the server."));
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText(UIUtilities.formatToolTipText("Closes the dialog."));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("1");
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        this.author = new JTextField(exp.getFirstName() + SEPARATOR + exp.getLastName());
        this.eMail = new JTextField(exp.getEmail());
        this.institution = new JTextField(exp.getInstitution());
        this.journalRef = new JTextField();
        this.description = new JTextField();
        this.location = new JTextField();
        this.locationFinder = new JButton("Find Folder");
        this.locationFinder.setToolTipText("List the existing folders.");
        this.locationFinder.setEnabled(this.folders.size() > 0);
        this.locationFinder.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ScriptUploaderDialog.this.showFolderList(e.getPoint());
            }
        });
        this.scriptArea = (JTextField)UIUtilities.findComponent(this.chooser, JTextField.class);
        if (this.scriptArea != null) {
            this.scriptArea.setEnabled(false);
            this.scriptArea.getDocument().addDocumentListener(this);
        }
        this.saveButton.setEnabled(this.scriptArea == null);
    }

    private JPanel buildControls() {
        double[][] size = new double[][]{{-2.0, 5.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, 50.0}};
        JPanel details = new JPanel();
        details.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        details.setLayout((LayoutManager)new TableLayout((double[][])size));
        int row = 0;
        JLabel l = UIUtilities.setTextFont("Folder:");
        details.add((Component)l, "0, " + row + ", LEFT, CENTER");
        details.add((Component)this.location, "2, " + row);
        details.add((Component)this.locationFinder, "0, " + ++row + ", LEFT, CENTER");
        JXTaskPane pane = new JXTaskPane();
        pane.setCollapsed(true);
        pane.setTitle("Script details");
        pane.add((Component)details);
        JPanel controls = new JPanel();
        controls.setLayout(new BorderLayout(0, 0));
        controls.add((Component)details, "North");
        controls.add((Component)this.buildToolbar(), "Center");
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)controls, "South");
        return p;
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(129));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildControls(), "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private JPanel buildToolbar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.cancelButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.saveButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void upload() {
        File f = this.scriptArea != null ? new File(this.chooser.getCurrentDirectory().toString(), this.scriptArea.getText()) : this.chooser.getSelectedFile();
        Iterator<CustomizedFileFilter> i = FILTERS.iterator();
        boolean supported = false;
        String mimeType = null;
        while (i.hasNext()) {
            CustomizedFileFilter filter = i.next();
            if (!filter.accept(f)) continue;
            supported = true;
            mimeType = filter.getMIMEType();
            break;
        }
        if (!supported) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(TITLE, "The selected script does not seem to be supported.");
            return;
        }
        if (this.scripts != null) {
            MessageBox box;
            String name = f.getName();
            Iterator<Map.Entry<Long, String>> j = this.scripts.entrySet().iterator();
            supported = false;
            while (j.hasNext()) {
                Map.Entry<Long, String> entry = j.next();
                String value = entry.getValue();
                if (!value.equals(name)) continue;
                supported = true;
                break;
            }
            if (supported && (box = new MessageBox((JFrame)this.getOwner(), TITLE, "A script with the same name already exists in the system.\nDo you still want to upload the script?")).centerMsgBox() == 0) {
                return;
            }
        }
        ScriptObject script = new ScriptObject(-1L, f.getAbsolutePath(), f.getName());
        script.setMIMEType(mimeType);
        String value = this.journalRef.getText();
        if (value != null) {
            script.setJournalRef(value.trim());
        }
        if ((value = this.description.getText()) != null) {
            script.setDescription(value.trim());
        }
        ExperimenterData exp = new ExperimenterData();
        value = this.author.getText();
        if (value == null) {
            exp = TreeViewerAgent.getUserDetails();
        } else {
            String[] v = value.split(SEPARATOR);
            if (v != null && v.length == 2) {
                exp.setFirstName(v[0].trim());
                exp.setLastName(v[1].trim());
            } else {
                exp = TreeViewerAgent.getUserDetails();
            }
        }
        value = this.eMail.getText();
        if (value != null) {
            exp.setEmail(value.trim());
        }
        if ((value = this.institution.getText()) != null) {
            exp.setInstitution(value.trim());
        }
        if ((value = this.location.getText()) != null) {
            script.setFolder(value.trim());
        }
        IconManager icons = IconManager.getInstance();
        script.setIcon(icons.getIcon(128));
        this.firePropertyChange(UPLOAD_SCRIPT_PROPERTY, null, script);
        this.close();
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void handleTextUpdate() {
        if (this.scriptArea == null) {
            return;
        }
        String text = this.scriptArea.getText();
        boolean b = false;
        String value = "";
        if (text != null && text.trim().length() > 0) {
            b = true;
            Iterator<CustomizedFileFilter> i = FILTERS.iterator();
            boolean supported = false;
            while (i.hasNext()) {
                CustomizedFileFilter filter = i.next();
                if (!filter.accept(text)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                this.location.setText(value);
                this.saveButton.setEnabled(false);
                return;
            }
            File f = this.chooser.getCurrentDirectory();
            if (f != null) {
                value = f.getName();
            }
        }
        this.location.setText(value);
        this.saveButton.setEnabled(b);
    }

    private void showFolderList(Point p) {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            int index = 2;
            Iterator<String> i = this.folders.iterator();
            while (i.hasNext()) {
                JMenuItem item = new JMenuItem(i.next());
                item.setActionCommand("" + index);
                item.addActionListener(this);
                ++index;
            }
        }
        this.menu.show(this.locationFinder, p.x, p.y);
    }

    public ScriptUploaderDialog(JFrame owner, Map<Long, String> scripts) {
        super(owner);
        this.scripts = scripts;
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.close();
                break;
            }
            case 0: {
                this.upload();
                break;
            }
            default: {
                if (!(e.getSource() instanceof JMenuItem)) break;
                JMenuItem item = (JMenuItem)e.getSource();
                this.location.setText(item.getText());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleTextUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static {
        FILTERS.add(new CppFilter());
        FILTERS.add(new JavaFilter());
        FILTERS.add(new MatlabFilter());
        FILTERS.add(new PythonFilter());
    }
}

