/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PersonalManagementAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.ManagePopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

class ToolBar
extends JPanel {
    private static final Dimension HBOX = new Dimension(100, 16);
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private TreeViewerWin view;
    private JXBusyLabel importLabel;
    private JToolBar importBar;
    private JPopupMenu personalMenu;
    private JToggleButton fullScreen;

    private void initComponents() {
        this.importLabel = new JXBusyLabel();
        this.importLabel.setEnabled(true);
        this.importLabel.setVisible(false);
        this.importLabel.setHorizontalTextPosition(2);
    }

    private void initMenuItem(JMenuItem item) {
        item.setBorder(null);
        item.setFont((Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Labels"));
    }

    private JComponent createManagementBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JToggleButton button = new JToggleButton(this.controller.getAction(TreeViewerControl.INSPECTOR));
        button.setSelected(true);
        bar.add(button);
        button = new JToggleButton(this.controller.getAction(TreeViewerControl.METADATA));
        button.setSelected(true);
        bar.add(button);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.BROWSE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.VIEW));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.REFRESH_TREE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(new JSeparator(1));
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.MANAGER);
        b = new JButton(a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addMouseListener((ManagerAction)a);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.EDITOR_NO_SELECTION));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.IMPORT));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(new JSeparator(1));
        this.fullScreen = new JToggleButton(this.controller.getAction(TreeViewerControl.FULLSCREEN));
        this.fullScreen.setSelected(this.model.isFullScreen());
        a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
        b = new JButton(a);
        b.addMouseListener((SwitchUserAction)a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        Set set = TreeViewerAgent.getAvailableUserGroups();
        if (set != null && set.size() > 0) {
            a = this.controller.getAction(TreeViewerControl.PERSONAL);
            b = new JButton(a);
            BorderFactory.createCompoundBorder(new EmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.GRAY));
            b.addMouseListener((PersonalManagementAction)a);
            bar.add(b);
        }
        return bar;
    }

    private JToolBar createSearchBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(new JSeparator(1));
        bar.add(new JToggleButton(this.controller.getAction(TreeViewerControl.SEARCH)));
        return bar;
    }

    private JToolBar createImportBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add((Component)this.importLabel);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.IMPORTER));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.createManagementBar());
        if (!"JXTaskPane".equals(this.view.getLayoutType())) {
            bars.add(this.createSearchBar());
        }
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 0));
        this.add(UIUtilities.buildComponentPanel(outerPanel));
    }

    void setImportStatus(String perc, boolean show) {
        if (this.importBar == null) {
            this.importBar = this.createImportBar();
            this.add(UIUtilities.buildComponentPanelRight(this.importBar));
        }
        this.importLabel.setBusy(true);
        this.importLabel.setText(perc);
        this.importLabel.setVisible(show);
    }

    ToolBar(TreeViewerControl controller, TreeViewerModel model, TreeViewerWin view) {
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void showManagementMenu(Component c, Point p) {
        if (p == null) {
            return;
        }
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        ManagePopupMenu managePopupMenu = new ManagePopupMenu(this.controller);
        managePopupMenu.show(c, p.x, p.y);
    }

    void showPersonalMenu(Component c, Point p) {
        if (p == null) {
            return;
        }
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        this.personalMenu = new JPopupMenu();
        this.personalMenu.setBorder(BorderFactory.createBevelBorder(0));
        List<GroupSelectionAction> l = this.controller.getUserGroupAction();
        Iterator<GroupSelectionAction> i = l.iterator();
        ButtonGroup buttonGroup = new ButtonGroup();
        ExperimenterData exp = TreeViewerAgent.getUserDetails();
        long id = exp.getDefaultGroup().getId();
        while (i.hasNext()) {
            GroupSelectionAction a = i.next();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
            item.setEnabled(true);
            item.setSelected(a.isSameGroup(id));
            this.initMenuItem(item);
            buttonGroup.add(item);
            this.personalMenu.add(item);
        }
        this.personalMenu.show(c, p.x, p.y);
    }

    void showCreateMenu(Component c, Point p, int index) {
        if (c == null) {
            return;
        }
        if (p == null) {
            return;
        }
        PopupMenu menu = new PopupMenu(this.controller, index);
        menu.show(c, p.x, p.y);
    }

    void setFullScreenSelected(boolean selected) {
        this.fullScreen.setSelected(selected);
    }
}

