/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import pojos.ExperimenterData;

class UserListRenderer
extends JLabel
implements ListCellRenderer {
    private static final Border BORDER = new EmptyBorder(5, 5, 5, 5);
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color BACKGROUND_ONE = new Color(236, 243, 254);
    private static final int GAP = 20;
    private Icon userIcon;

    public UserListRenderer(Icon userIcon) {
        this.setOpaque(true);
        this.userIcon = userIcon;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        this.setVerticalAlignment(0);
        this.setIcon(this.userIcon);
        this.setIconTextGap(20);
        if (value instanceof String) {
            this.setText((String)value);
        } else if (value instanceof ExperimenterData) {
            ExperimenterData data = (ExperimenterData)value;
            this.setText(data.getFirstName() + " " + data.getLastName());
        }
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            if (index % 2 == 0) {
                this.setBackground(BACKGROUND);
            } else {
                this.setBackground(BACKGROUND_ONE);
            }
        }
        this.setBorder(BORDER);
        return this;
    }
}

