/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import com.sun.opengl.util.texture.TextureData;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import loci.formats.IFormatHandler;
import loci.formats.ImageReader;
import loci.formats.gui.FormatFileFilter;
import loci.formats.gui.GUITools;
import omero.api.RenderingEnginePrx;
import omero.model.Channel;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.RenderingDef;
import omero.romio.PlaneDef;
import omero.rtypes;
import omero.sys.Parameters;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.ScriptCallback;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.model.ROIResult;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.data.util.StatusLabel;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.image.io.WriterImage;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.ROIData;
import pojos.WorkflowData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OmeroImageServiceImpl
implements OmeroImageService {
    private List<FileFilter> filters;
    private String[] supportedExtensions;
    private Registry context;
    private OMEROGateway gateway;

    private boolean isBinaryAvailable() {
        Boolean b = (Boolean)this.context.lookup("/services/SERVER/BinaryAvailable");
        if (b == null) {
            return true;
        }
        return b;
    }

    private BufferedImage createImage(byte[] values) throws RenderingServiceException {
        try {
            return WriterImage.bytesToImage(values);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot create buffered image", e);
        }
    }

    private BufferedImage createImage(String path) throws FSAccessException {
        try {
            return ImageIO.read(new File(path));
        }
        catch (Exception e) {
            throw new FSAccessException("Cannot create buffered image", e);
        }
    }

    OmeroImageServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    void shutDown() {
        PixelsServicesFactory.shutDownRenderingControls(this.context);
    }

    @Override
    public RenderingControl loadRenderingControl(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID), true);
        if (proxy == null) {
            int compressionLevel;
            UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
            switch (uc.getSpeedLevel()) {
                case 1: {
                    compressionLevel = 1;
                    break;
                }
                case 2: {
                    compressionLevel = 2;
                    break;
                }
                default: {
                    compressionLevel = 0;
                }
            }
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            Pixels pixels = this.gateway.getPixels(pixelsID);
            RenderingDef def = this.gateway.getRenderingDef(pixelsID, exp.getId());
            List l = pixels.copyChannels();
            Iterator i = l.iterator();
            ArrayList<ChannelData> m = new ArrayList<ChannelData>(l.size());
            int index = 0;
            while (i.hasNext()) {
                m.add(new ChannelData(index, (Channel)i.next()));
                ++index;
            }
            proxy = PixelsServicesFactory.createRenderingControl(this.context, re, pixels, m, compressionLevel, def);
        }
        return proxy;
    }

    @Override
    public Object renderImage(long pixelsID, PlaneDef pDef, boolean asTexture, boolean largeImage) throws RenderingServiceException {
        try {
            if (!largeImage) {
                return PixelsServicesFactory.render(this.context, new Long(pixelsID), pDef, asTexture);
            }
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(pixelsID);
            int w = pDef.x;
            int h = pDef.y;
            int max = w;
            if (max < h) {
                max = h;
            }
            if (max > 3072) {
                max = 3072;
            }
            Map m = this.gateway.getThumbnailSet(ids, max, true);
            byte[] values = (byte[])m.get(pixelsID);
            if (asTexture) {
                return PixelsServicesFactory.createTexture(WriterImage.bytesToDataBuffer(values), w, h);
            }
            return this.createImage(values);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", e);
        }
    }

    @Override
    public void shutDown(long pixelsID) {
        if (!PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID)) {
            this.gateway.removeREService(pixelsID);
        }
    }

    @Override
    public BufferedImage getThumbnail(long pixID, int sizeX, int sizeY, long userID) throws RenderingServiceException {
        try {
            if (pixID < 0L) {
                return null;
            }
            if (!this.isBinaryAvailable()) {
                return null;
            }
            return this.createImage(this.gateway.getThumbnail(pixID, sizeX, sizeY, userID));
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return null;
            }
            throw new RenderingServiceException("Get Thumbnail", e);
        }
    }

    @Override
    public Map<Long, BufferedImage> getThumbnailSet(List pixelsID, int max) throws RenderingServiceException {
        HashMap<Long, BufferedImage> r = new HashMap<Long, BufferedImage>();
        ArrayList ids = new ArrayList();
        try {
            if (pixelsID == null || pixelsID.size() == 0) {
                return r;
            }
            Iterator j = pixelsID.iterator();
            if (!this.isBinaryAvailable()) {
                while (j.hasNext()) {
                    long id = (Long)j.next();
                    r.put(id, null);
                }
                return r;
            }
            PlaneDef pDef = new PlaneDef();
            pDef.slice = 0;
            ids.addAll(pixelsID);
            Map m = this.gateway.getThumbnailSet(pixelsID, max, false);
            if (m == null || m.size() == 0) {
                Iterator i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
                return r;
            }
            Iterator<Object> i = m.keySet().iterator();
            while (i.hasNext()) {
                long id = (Long)i.next();
                byte[] values = (byte[])m.get(id);
                ids.remove(id);
                if (values == null || values.length == 0) {
                    r.put(id, null);
                    continue;
                }
                try {
                    BufferedImage img = this.createImage(values);
                    r.put(id, this.createImage(values));
                }
                catch (Exception e) {
                    r.put(id, null);
                }
            }
            if (ids.size() > 0) {
                i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
            }
            return r;
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, e.getMessage());
            if (ids.size() > 0) {
                Iterator i = ids.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), null);
                }
            }
            return r;
        }
    }

    @Override
    public RenderingControl reloadRenderingService(long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID), false);
        if (proxy == null) {
            return null;
        }
        try {
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            return PixelsServicesFactory.reloadRenderingControl(this.context, pixelsID, re);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, e);
        }
    }

    @Override
    public RenderingControl resetRenderingService(long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID), false);
        if (proxy == null) {
            return null;
        }
        try {
            RenderingEnginePrx re = this.gateway.createRenderingEngine(pixelsID);
            ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
            RenderingDef def = this.gateway.getRenderingDef(pixelsID, exp.getId());
            return PixelsServicesFactory.resetRenderingControl(this.context, pixelsID, re, def);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, e);
        }
    }

    @Override
    public PixelsData loadPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return (PixelsData)PojoMapper.asDataObject((IObject)this.gateway.getPixels(pixelsID));
    }

    @Override
    public byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels' ID not valid.");
        }
        return this.gateway.getPlane(pixelsID, z, t, c);
    }

    public Map pasteRenderingSettings(long pixelsID, Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.pasteRenderingSettings(pixelsID, rootNodeType, nodesID);
    }

    public Map resetRenderingSettings(Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.resetRenderingSettings(rootNodeType, nodesID);
    }

    public Map setMinMaxSettings(Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.setMinMaxSettings(rootNodeType, nodesID);
    }

    public Map setOwnerRenderingSettings(Class rootNodeType, List nodesID) throws DSOutOfServiceException, DSAccessException {
        if (nodesID == null || nodesID.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        return this.gateway.setOwnerRenderingSettings(rootNodeType, nodesID);
    }

    @Override
    public Map getRenderingSettings(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getRenderingSettings(pixelsID, userID);
    }

    @Override
    public List getRenderingSettingsFor(long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getRenderingSettingsFor(pixelsID, userID);
    }

    @Override
    public BufferedImage renderProjected(long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        return PixelsServicesFactory.renderProjected(this.context, pixelsID, startZ, endZ, type, stepping, channels);
    }

    @Override
    public TextureData renderProjectedAsTexture(long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels) throws RenderingServiceException, DSOutOfServiceException {
        return PixelsServicesFactory.renderProjectedAsTexture(this.context, pixelsID, startZ, endZ, type, stepping, channels);
    }

    @Override
    public ImageData projectImage(ProjectionParam ref) throws DSOutOfServiceException, DSAccessException {
        if (ref == null) {
            return null;
        }
        ImageData image = this.gateway.projectImage(ref.getPixelsID(), ref.getStartT(), ref.getEndT(), ref.getStartZ(), ref.getEndZ(), ref.getStepping(), ref.getProjectionType(), ref.getChannels(), ref.getName(), ref.getPixelsType());
        if (image == null) {
            return null;
        }
        Image img = image.asImage();
        img.setDescription(rtypes.rstring((String)ref.getDescription()));
        image = (ImageData)PojoMapper.asDataObject(this.gateway.updateObject((IObject)img, new Parameters()));
        image = this.gateway.getImage(image.getId(), new Parameters());
        List<DatasetData> datasets = ref.getDatasets();
        if (datasets != null && datasets.size() > 0) {
            Iterator<Object> i = datasets.iterator();
            ArrayList<DatasetData> existing = new ArrayList<DatasetData>();
            ArrayList<DatasetData> toCreate = new ArrayList<DatasetData>();
            while (i.hasNext()) {
                DatasetData dataset = i.next();
                if (dataset.getId() > 0L) {
                    existing.add(dataset);
                    continue;
                }
                toCreate.add(dataset);
            }
            if (toCreate.size() > 0) {
                i = toCreate.iterator();
                OmeroDataService svc = this.context.getDataService();
                while (i.hasNext()) {
                    existing.add((DatasetData)svc.createDataObject((DataObject)i.next(), ref.getDatasetParent(), null));
                }
            }
            ArrayList<IObject> links = new ArrayList<IObject>(datasets.size());
            img = image.asImage();
            i = existing.iterator();
            while (i.hasNext()) {
                IObject l = ModelMapper.linkParentToChild((IObject)img, ((DatasetData)i.next()).asIObject());
                links.add(l);
            }
            this.gateway.createObjects(links);
        }
        return image;
    }

    @Override
    public Boolean createRenderingSettings(long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes) throws DSOutOfServiceException, DSAccessException {
        if (rndToCopy == null) {
            RenderingDef def = this.gateway.createRenderingDef(pixelsID);
            return def != null;
        }
        RenderingControl rndControl = this.loadRenderingControl(pixelsID);
        try {
            rndControl.copyRenderingSettings(rndToCopy, indexes);
            rndControl.saveCurrentSettings();
            this.shutDown(pixelsID);
        }
        catch (Exception e) {
            throw new DSAccessException("Unable to copy the rendering settings.");
        }
        return Boolean.TRUE;
    }

    @Override
    public Collection loadPlaneInfo(long pixelsID, int z, int t, int channel) throws DSOutOfServiceException, DSAccessException {
        List<IObject> planes = this.gateway.loadPlaneInfo(pixelsID, z, t, channel);
        return planes;
    }

    @Override
    public Object importImage(DataObject container, File file, StatusLabel status, long userID, long groupID, boolean archived, String name, int depth) throws ImportException {
        if (file == null) {
            throw new IllegalArgumentException("No images to import.");
        }
        Object object = file.isDirectory() ? this.gateway.importFolder(container, file, status, archived, depth) : this.gateway.importImage(container, file, status, archived, name);
        if (!(object instanceof ImageData)) {
            return object;
        }
        ImageData image = (ImageData)object;
        if (image != null) {
            try {
                PixelsData pix = image.getDefaultPixels();
                BufferedImage img = this.createImage(this.gateway.getThumbnailByLongestSide(pix.getId(), 24));
                ThumbnailData data = new ThumbnailData(image.getId(), img, userID, true);
                data.setImage(image);
                return data;
            }
            catch (Exception e) {
                DeletableObject d = new DeletableObject((DataObject)image);
                ArrayList<DeletableObject> l = new ArrayList<DeletableObject>(1);
                l.add(d);
                try {
                    this.context.getDataService().delete(l);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new ImportException("Failed to create thumbnail", e, this.gateway.getReaderType());
            }
        }
        return image;
    }

    @Override
    public List<FileFilter> getSupportedFileFilters() {
        if (this.filters != null) {
            return this.filters;
        }
        this.filters = new ArrayList<FileFilter>();
        ImageReader reader = new ImageReader();
        FileFilter[] array = GUITools.buildFileFilters((IFormatHandler)reader);
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                FileFilter f = array[i];
                if (!(f instanceof FormatFileFilter) || f.toString().contains(".zip")) continue;
                this.filters.add(f);
            }
        }
        return this.filters;
    }

    @Override
    public Object monitor(String directory, DataObject container, long userID, long groupID) {
        if (this.supportedExtensions == null) {
            List<FileFilter> l = this.getSupportedFileFilters();
            Iterator<FileFilter> i = l.iterator();
            ArrayList<String> formats = new ArrayList<String>();
            String regEx = "\\*";
            while (i.hasNext()) {
                String description = i.next().getDescription();
                String[] terms = description.split(regEx);
                for (int j = 1; j < terms.length; ++j) {
                    String v = terms[j].trim();
                    if ((v = v.replaceAll(",", "")).endsWith(")")) {
                        v = v.substring(0, v.length() - 1);
                    }
                    formats.add(v);
                }
            }
            this.supportedExtensions = new String[formats.size()];
            Iterator k = formats.iterator();
            int index = 0;
            while (k.hasNext()) {
                this.supportedExtensions[index] = (String)k.next();
                ++index;
            }
        }
        return true;
    }

    @Override
    public ScriptCallback createMovie(long imageID, long pixelsID, List<Integer> channels, MovieExportParam param) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("Image ID not valid.");
        }
        if (param == null) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        if (channels == null) {
            channels = new ArrayList<Integer>();
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        return this.gateway.createMovie(imageID, pixelsID, exp.getId(), channels, param);
    }

    @Override
    public List<ROIResult> loadROI(long imageID, List<Long> fileID, long userID) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.loadROI(imageID, fileID, userID);
    }

    @Override
    public List<ROIData> saveROI(long imageID, long userID, List<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.saveROI(imageID, userID, roiList);
    }

    @Override
    public Object exportImageAsOMETiff(long imageID, File file) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        if (file == null) {
            throw new IllegalArgumentException("No File specified.");
        }
        return this.gateway.exportImageAsOMETiff(file, imageID);
    }

    @Override
    public ScriptCallback createFigure(List<Long> ids, Class type, Object parameters) throws DSOutOfServiceException, DSAccessException {
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        if (parameters instanceof FigureParam) {
            FigureParam p = (FigureParam)parameters;
            return this.gateway.createFigure(ids, type, p, exp.getId());
        }
        return null;
    }

    @Override
    public List<ROIResult> loadROIFromServer(long imageID, long userID) throws DSOutOfServiceException, DSAccessException {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("No image specified.");
        }
        return this.gateway.loadROI(imageID, null, userID);
    }

    @Override
    public Object renderOverLays(long pixelsID, PlaneDef pd, long tableID, Map<Long, Integer> overlays, boolean asTexture) throws RenderingServiceException {
        try {
            return PixelsServicesFactory.renderOverlays(this.context, pixelsID, pd, tableID, overlays, asTexture);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", e);
        }
    }

    @Override
    public DataObject analyseFrap(List<Long> ids, Class type, Object param) throws DSOutOfServiceException, DSAccessException {
        if (ids == null || ids.size() <= 0) {
            throw new IllegalArgumentException("No objects to analyse.");
        }
        if (type == null) {
            throw new IllegalArgumentException("No node to analyze.");
        }
        long id = this.gateway.analyseFRAP(ids, type, param);
        if (id < 0L) {
            return null;
        }
        return this.context.getMetadataService().loadAnnotation(id);
    }

    @Override
    public ScriptCallback runScript(ScriptObject script) throws DSOutOfServiceException, DSAccessException {
        if (script == null) {
            throw new IllegalArgumentException("No script to run.");
        }
        return this.gateway.runScript(script);
    }

    @Override
    public List<ScriptObject> loadAvailableScriptsWithUI() throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadRunnableScriptsWithUI();
    }

    @Override
    public List<ScriptObject> loadAvailableScripts(long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadRunnableScripts();
    }

    @Override
    public ScriptObject loadScript(long scriptID) throws ProcessException {
        return this.gateway.loadScript(scriptID);
    }

    @Override
    public Map<Long, String> getScriptsAsString() throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getScriptsAsString();
    }

    @Override
    public Object uploadScript(ScriptObject script) throws DSOutOfServiceException, DSAccessException {
        if (script == null) {
            throw new IllegalArgumentException("No script to upload.");
        }
        Boolean b = (Boolean)this.context.lookup("/users/administrator");
        boolean value = false;
        if (b != null) {
            value = b;
        }
        return this.gateway.uploadScript(script, value);
    }

    @Override
    public Collection loadROIMeasurements(Class type, long id, long userID) throws DSOutOfServiceException, DSAccessException {
        if (ImageData.class.equals((Object)type)) {
            return this.gateway.loadROIMeasurements(id, userID);
        }
        ArrayList<Long> ids = null;
        if (userID != -1L) {
            ids = new ArrayList<Long>(1);
            ids.add(userID);
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(1);
        nodeIds.add(id);
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(FileAnnotationData.class);
        Map map = this.gateway.loadAnnotations(type, nodeIds, types, ids, new Parameters());
        if (map == null || map.size() == 0) {
            return new ArrayList();
        }
        Collection l = (Collection)map.get(id);
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (l != null) {
            for (FileAnnotationData fa : l) {
                String ns = fa.getNameSpace();
                if (!"openmicroscopy.org/omero/measurement".equals(ns)) continue;
                list.add(fa);
            }
        }
        return list;
    }

    @Override
    public Map<DataObject, BufferedImage> getFSThumbnailSet(List<DataObject> files, int maxLength, long userID) throws DSAccessException, DSOutOfServiceException, FSAccessException {
        HashMap<DataObject, BufferedImage> m = new HashMap<DataObject, BufferedImage>();
        if (files == null || files.size() == 0) {
            return m;
        }
        Iterator<DataObject> i = files.iterator();
        if (!this.isBinaryAvailable()) {
            while (i.hasNext()) {
                DataObject file = i.next();
                m.put(file, null);
            }
            return m;
        }
        FSFileSystemView view = this.gateway.getFSRepositories(userID);
        while (i.hasNext()) {
            DataObject file = i.next();
            String path = view.getThumbnail(file);
            try {
                if (path != null) {
                    m.put(file, Factory.scaleBufferedImage(this.createImage(path), maxLength));
                    continue;
                }
                m.put(file, null);
            }
            catch (Exception e) {
                m.put(file, null);
            }
        }
        return m;
    }

    @Override
    public Object storeWorkflows(List<WorkflowData> workflows, long userID) throws DSAccessException, DSOutOfServiceException {
        return this.gateway.storeWorkflows(workflows, userID);
    }

    @Override
    public List<WorkflowData> retrieveWorkflows(long userID) throws DSAccessException, DSOutOfServiceException {
        ExperimenterData exp = (ExperimenterData)this.context.lookup("/current_user/details");
        if (userID < 0L) {
            userID = exp.getId();
        }
        return this.gateway.retrieveWorkflows(userID);
    }

    @Override
    public Map<DataObject, BufferedImage> getExperimenterThumbnailSet(List<DataObject> experimenters, int maxLength) throws DSAccessException, DSOutOfServiceException {
        Map annotations;
        DataObject exp;
        HashMap<DataObject, BufferedImage> m = new HashMap<DataObject, BufferedImage>();
        if (experimenters == null || experimenters.size() == 0) {
            return m;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator<DataObject> i = experimenters.iterator();
        if (!this.isBinaryAvailable()) {
            while (i.hasNext()) {
                m.put(i.next(), null);
            }
            return m;
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(FileAnnotationData.class);
        HashMap<Long, DataObject> exps = new HashMap<Long, DataObject>();
        while (i.hasNext()) {
            exp = i.next();
            ids.add(exp.getId());
            m.put(exp, null);
            exps.put(exp.getId(), exp);
        }
        try {
            annotations = this.gateway.loadAnnotations(ExperimenterData.class, ids, types, new ArrayList(), new Parameters());
        }
        catch (Exception e) {
            return m;
        }
        if (annotations == null || annotations.size() == 0) {
            return m;
        }
        for (Map.Entry entry : annotations.entrySet()) {
            Long id = (Long)entry.getKey();
            Collection values = (Collection)entry.getValue();
            Iterator k = values.iterator();
            FileAnnotationData ann = null;
            while (k.hasNext()) {
                FileAnnotationData fa;
                Object object = k.next();
                if (!(object instanceof FileAnnotationData) || !"openmicroscopy.org/omero/experimenter/photo".equals((fa = (FileAnnotationData)object).getNameSpace())) continue;
                if (ann == null) {
                    ann = fa;
                    continue;
                }
                if (fa.getId() <= ann.getId()) continue;
                ann = fa;
            }
            if (ann == null) continue;
            exp = (DataObject)exps.get(id);
            try {
                BufferedImage img = this.createImage(this.gateway.getUserPhoto(ann.getFileID(), ann.getFileSize()));
                m.put((DataObject)exps.get(id), Factory.scaleBufferedImage(img, maxLength));
            }
            catch (Exception e) {}
        }
        return m;
    }
}

