/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.env.data.util.Parser;
import org.openmicroscopy.shoola.util.image.io.IconReader;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationData {
    public static final String LOCATION_MAC = "/Applications";
    public static final String LOCATION_WINDOWS = "C:\\Program Files";
    public static final String LOCATION_LINUX = "/Applications";
    private File file;
    private String applicationName;
    private Icon applicationIcon;
    private String executable;

    private static Icon convert(String path) {
        if (path == null) {
            return null;
        }
        if (!path.endsWith("icns")) {
            path = path + ".icns";
        }
        IconReader reader = new IconReader(path);
        BufferedImage img = null;
        try {
            img = reader.decode(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    private void parseMac() {
        try {
            Map<String, Object> m = Parser.parseInfoPList(this.getApplicationPath());
            this.executable = (String)m.get("CFBundleExecutable");
            this.applicationIcon = ApplicationData.convert((String)m.get("CFBundleIconFile"));
            this.applicationName = (String)m.get("CFBundleName");
        }
        catch (Exception e) {
            this.applicationName = UIUtilities.removeFileExtension(this.file.getAbsolutePath());
            this.applicationIcon = null;
            this.executable = this.getApplicationPath();
        }
        if (this.applicationName == null || this.applicationName.length() == 0) {
            this.applicationName = UIUtilities.removeFileExtension(this.file.getName());
        }
        if (this.executable == null || this.executable.length() == 0) {
            this.executable = this.getApplicationPath();
        }
        if (this.executable.contains("Microsoft")) {
            this.executable = null;
        }
    }

    public static String getDefaultLocation() {
        if (UIUtilities.isMacOS()) {
            return "/Applications";
        }
        if (UIUtilities.isWindowsOS()) {
            return LOCATION_WINDOWS;
        }
        return "/Applications";
    }

    public ApplicationData(File file) {
        this.file = file;
        String name = file.getName();
        if (name == null || name.length() == 0) {
            this.applicationName = "";
            this.applicationIcon = null;
            this.executable = null;
        } else if (UIUtilities.isMacOS()) {
            this.parseMac();
        }
    }

    public ApplicationData(String path) {
        this(new File(path));
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Icon getApplicationIcon() {
        return this.applicationIcon;
    }

    public String getApplicationPath() {
        return this.file.getAbsolutePath();
    }

    public List<String> getArguments() {
        ArrayList<String> list = new ArrayList<String>();
        if (UIUtilities.isMacOS()) {
            if (this.executable != null && this.executable.length() > 0) {
                list.add(this.executable);
            } else {
                list.add("open");
            }
        }
        return list;
    }

    public String toString() {
        if (this.applicationName == null) {
            return "";
        }
        return this.applicationName;
    }
}

