/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import omero.RType;
import omero.grid.JobParams;
import omero.grid.Param;
import org.openmicroscopy.shoola.env.data.model.ParamData;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptObject {
    public static final String PARAMETER_SEPARATOR = "_";
    public static final String PARAMETER_UI_SEPARATOR = " ";
    public static final String FIGURE_PATH = "/omero/figure_scripts/";
    public static final String EXPORT_PATH = "/omero/export_scripts/";
    public static final String REGION_PATH = "/omero/region_scripts/";
    public static final String UTIL_PATH = "/omero/util_scripts/";
    public static final String SETUP_PATH = "/omero/setup_scripts/";
    public static final int EXPORT = 0;
    public static final int FIGURE = 1;
    public static final int REGION = 2;
    public static final int UTIL = 3;
    public static final int OTHER = 4;
    private long scriptID;
    private String name;
    private String path;
    private String description;
    private String journalRef;
    private String contact;
    private String version;
    private Map<String, Class> parameterTypes;
    private Map<String, Object> parameterValues;
    private Map<String, ParamData> inputs;
    private Map<String, ParamData> outputs;
    private Icon icon;
    private Icon iconLarge;
    private JobParams parameters;
    private String mimeType;
    private int category;
    private String folder;
    private boolean official;

    private void convertJobParameters() {
        Param p;
        if (this.parameters == null) {
            return;
        }
        String[] authors = this.parameters.authors;
        if (authors != null && authors.length > 0) {
            for (int i = 0; i < authors.length; ++i) {
                ExperimenterData exp = new ExperimenterData();
                exp.setLastName(authors[i]);
            }
        }
        Map map = this.parameters.inputs;
        this.inputs = new HashMap<String, ParamData>();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                p = (Param)entry.getValue();
                this.inputs.put((String)entry.getKey(), new ParamData(p));
            }
        }
        map = this.parameters.outputs;
        this.outputs = new HashMap<String, ParamData>();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                p = (Param)entry.getValue();
                this.outputs.put((String)entry.getKey(), new ParamData(p));
            }
        }
    }

    private void setCategory() {
        this.category = FIGURE_PATH.equals(this.path) ? 1 : (EXPORT_PATH.equals(this.path) ? 0 : (REGION_PATH.equals(this.path) ? 2 : (UTIL_PATH.equals(this.path) ? 3 : 4)));
    }

    public ScriptObject(long scriptID, String path, String name) {
        this.scriptID = scriptID;
        this.path = path;
        this.name = name;
        this.setCategory();
        this.description = "";
        this.journalRef = "";
        this.mimeType = null;
        this.official = true;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public boolean isOfficialScript() {
        return this.official;
    }

    public String getScriptLabel() {
        return UIUtilities.toUnix(this.path + this.name);
    }

    public String getPath() {
        return this.path;
    }

    public String getFolder() {
        if (this.folder == null || this.folder.length() == 0) {
            return this.getPath();
        }
        return File.separator + this.folder + File.separator + this.name;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setJobParams(JobParams parameters) {
        this.parameters = parameters;
        this.convertJobParameters();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJournalRef(String journalRef) {
        this.journalRef = journalRef;
    }

    public String[] getAuthors() {
        if (this.parameters != null) {
            return this.parameters.authors;
        }
        return null;
    }

    public String getDescription() {
        if (this.parameters != null) {
            return this.parameters.description;
        }
        return this.description;
    }

    public String getJournalRef() {
        return this.journalRef;
    }

    public long getScriptID() {
        return this.scriptID;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayedName() {
        int lastDotIndex = this.name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return this.name;
        }
        String value = this.name.substring(0, lastDotIndex);
        if (!value.contains(PARAMETER_SEPARATOR)) {
            return value;
        }
        return value.replace(PARAMETER_SEPARATOR, PARAMETER_UI_SEPARATOR);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIconLarge(Icon icon) {
        this.iconLarge = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIconLarge() {
        return this.iconLarge;
    }

    public String getContact() {
        if (this.parameters != null) {
            return this.parameters.contact;
        }
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getVersion() {
        if (this.parameters != null) {
            return this.parameters.version;
        }
        return this.version;
    }

    public Map<String, ParamData> getInputs() {
        return this.inputs;
    }

    public Map<String, RType> getValueToPass() {
        HashMap<String, RType> map = new HashMap<String, RType>();
        if (this.inputs == null) {
            return map;
        }
        for (Map.Entry<String, ParamData> entry : this.inputs.entrySet()) {
            ParamData p = entry.getValue();
            RType type = p.getValueToPassAsRType();
            if (type == null) continue;
            map.put(entry.getKey(), type);
        }
        return map;
    }

    public boolean isParametersLoaded() {
        return this.parameters != null;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getCategory() {
        return this.category;
    }

    public JobParams getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.getScriptLabel();
    }
}

