/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DataObject;
import pojos.GroupData;

public class ExistingObjectsSaver
extends BatchCallTree {
    private BatchCall call;
    private Object result;

    private BatchCall makeBatchCall(final Collection parent, final Collection children, boolean admin) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                for (Object obj : parent) {
                    if (!(obj instanceof DataObject)) continue;
                    os.addExistingObjects((DataObject)obj, children);
                }
                ExistingObjectsSaver.this.result = parent;
            }
        };
    }

    private BatchCall makeBatchCall(final Map toPaste) {
        return new BatchCall("Copy and paste: "){

            public void doCall() throws Exception {
                AdminService as = ExistingObjectsSaver.this.context.getAdminService();
                OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                for (Map.Entry entry : toPaste.entrySet()) {
                    Object p = entry.getKey();
                    if (p instanceof GroupData) {
                        as.copyExperimenters((GroupData)p, (Set)entry.getValue());
                        continue;
                    }
                    if (!(p instanceof DataObject)) continue;
                    os.addExistingObjects((DataObject)p, (Set)entry.getValue());
                }
                ExistingObjectsSaver.this.result = toPaste;
            }
        };
    }

    private BatchCall makeBatchCall(final Map toPaste, final Map toRemove, final boolean admin) {
        return new BatchCall("Cut and paste: "){

            public void doCall() throws Exception {
                if (admin) {
                    AdminService as = ExistingObjectsSaver.this.context.getAdminService();
                    as.cutAndPasteExperimenters(toPaste, toRemove);
                    ExistingObjectsSaver.this.result = toPaste;
                } else {
                    OmeroDataService os = ExistingObjectsSaver.this.context.getDataService();
                    os.cutAndPaste(toPaste, toRemove);
                    ExistingObjectsSaver.this.result = toPaste;
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.call);
    }

    protected Object getResult() {
        return this.result;
    }

    public ExistingObjectsSaver(Collection parent, Collection children, boolean admin) {
        if (children == null || children.size() == 0) {
            throw new IllegalArgumentException("No item to add.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent to update.");
        }
        this.call = this.makeBatchCall(parent, children, admin);
    }

    public ExistingObjectsSaver(Map toPaste, Map toRemove, boolean admin) {
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        this.call = toRemove == null ? this.makeBatchCall(toPaste) : this.makeBatchCall(toPaste, toRemove, admin);
    }
}

