/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesChecker
extends BatchCallTree {
    private BatchCall loadCall;
    private Object result;

    private boolean isFileSupported(File f, List<FileFilter> filters) {
        String path = f.getAbsolutePath();
        if ((path = path.toLowerCase()).endsWith(".zip")) {
            return true;
        }
        Iterator<FileFilter> i = filters.iterator();
        while (i.hasNext()) {
            if (!i.next().accept(f)) continue;
            return true;
        }
        return false;
    }

    private BatchCall makeCheckCall(final List<File> files) {
        return new BatchCall("Downloading files."){

            public void doCall() {
                OmeroImageService service = FilesChecker.this.context.getImageService();
                List<FileFilter> filters = service.getSupportedFileFilters();
                HashMap m = new HashMap();
                m.put(false, new ArrayList());
                m.put(true, new ArrayList());
                for (File f : files) {
                    List l = (List)m.get(FilesChecker.this.isFileSupported(f, filters));
                    l.add(f);
                }
                FilesChecker.this.result = m;
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public FilesChecker(List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("No files to check.");
        }
        this.loadCall = this.makeCheckCall(files);
    }
}

