/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionSaver
extends BatchCallTree {
    private long pixelsID;
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeRenderProjectedCall(final int startZ, final int endZ, final int stepping, final int algorithm, final List<Integer> channels, final boolean openGLSupport) {
        return new BatchCall("Preview the projected image."){

            public void doCall() throws Exception {
                OmeroImageService rds = ProjectionSaver.this.context.getImageService();
                if (openGLSupport) {
                    ProjectionSaver.this.result = rds.renderProjectedAsTexture(ProjectionSaver.this.pixelsID, startZ, endZ, stepping, algorithm, channels);
                } else {
                    ProjectionSaver.this.result = rds.renderProjected(ProjectionSaver.this.pixelsID, startZ, endZ, stepping, algorithm, channels);
                }
            }
        };
    }

    private BatchCall makeProjectionCall(final ProjectionParam ref) {
        return new BatchCall("Project the image"){

            public void doCall() throws Exception {
                OmeroImageService rds = ProjectionSaver.this.context.getImageService();
                ProjectionSaver.this.result = rds.projectImage(ref);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ProjectionSaver(long pixelsID, int startZ, int endZ, int stepping, int type, List<Integer> channels, boolean openGLSupport) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels Id not valid.");
        }
        this.pixelsID = pixelsID;
        this.loadCall = this.makeRenderProjectedCall(startZ, endZ, stepping, type, channels, openGLSupport);
    }

    public ProjectionSaver(ProjectionParam ref) {
        this.loadCall = this.makeProjectionCall(ref);
    }
}

