/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingSettingsSaver
extends BatchCallTree {
    public static final int PASTE = 0;
    public static final int RESET = 1;
    public static final int SET_MIN_MAX = 2;
    public static final int CREATE = 3;
    public static final int SET_OWNER = 4;
    private Object result;
    private BatchCall loadCall;

    private void checkRootType(Class type) {
        if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || PlateData.class.equals((Object)type) || ProjectData.class.equals((Object)type) || ScreenData.class.equals((Object)type)) {
            return;
        }
        throw new IllegalArgumentException("Type not supported.");
    }

    private BatchCall makeBatchCall(final long pixelsID, final Class rootType, final List<Long> ids, final int index) {
        return new BatchCall("Modify the rendering settings: "){

            public void doCall() throws Exception {
                OmeroImageService rds = RenderingSettingsSaver.this.context.getImageService();
                switch (index) {
                    case 0: {
                        RenderingSettingsSaver.this.result = rds.pasteRenderingSettings(pixelsID, rootType, ids);
                        break;
                    }
                    case 1: {
                        RenderingSettingsSaver.this.result = rds.resetRenderingSettings(rootType, ids);
                        break;
                    }
                    case 2: {
                        RenderingSettingsSaver.this.result = rds.setMinMaxSettings(rootType, ids);
                        break;
                    }
                    case 4: {
                        RenderingSettingsSaver.this.result = rds.setOwnerRenderingSettings(rootType, ids);
                    }
                }
            }
        };
    }

    private BatchCall makeBatchCall(final long pixelsID, final TimeRefObject ref, final int index) {
        return new BatchCall("Modify the rendering settings: "){

            public void doCall() throws Exception {
                long userID = ((ExperimenterData)RenderingSettingsSaver.this.context.lookup("/current_user/details")).getId();
                OmeroDataService os = RenderingSettingsSaver.this.context.getDataService();
                Collection l = os.getImagesPeriod(ref.getStartTime(), ref.getEndTime(), userID, true);
                if (l != null) {
                    Iterator i = l.iterator();
                    ArrayList<Long> ids = new ArrayList<Long>(l.size());
                    while (i.hasNext()) {
                        DataObject element = (DataObject)i.next();
                        ids.add(element.getId());
                    }
                    OmeroImageService rds = RenderingSettingsSaver.this.context.getImageService();
                    switch (index) {
                        case 0: {
                            RenderingSettingsSaver.this.result = rds.pasteRenderingSettings(pixelsID, ImageData.class, ids);
                            break;
                        }
                        case 1: {
                            RenderingSettingsSaver.this.result = rds.resetRenderingSettings(ImageData.class, ids);
                            break;
                        }
                        case 2: {
                            RenderingSettingsSaver.this.result = rds.setMinMaxSettings(ImageData.class, ids);
                            break;
                        }
                        case 4: {
                            RenderingSettingsSaver.this.result = rds.setOwnerRenderingSettings(ImageData.class, ids);
                        }
                    }
                }
            }
        };
    }

    private BatchCall makeCreateBatchCall(final long pixelsID, final RndProxyDef rndToCopy, final List<Integer> indexes) {
        return new BatchCall("Paste the rendering settings: "){

            public void doCall() throws Exception {
                OmeroImageService os = RenderingSettingsSaver.this.context.getImageService();
                RenderingSettingsSaver.this.result = os.createRenderingSettings(pixelsID, rndToCopy, indexes);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public RenderingSettingsSaver(Class rootNodeType, List<Long> ids, int index) {
        this.checkRootType(rootNodeType);
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.loadCall = this.makeBatchCall(-1L, rootNodeType, ids, index);
    }

    public RenderingSettingsSaver(long pixelsID, Class rootNodeType, List<Long> ids) {
        this.checkRootType(rootNodeType);
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.loadCall = this.makeBatchCall(pixelsID, rootNodeType, ids, 0);
    }

    public RenderingSettingsSaver(long pixelsID, TimeRefObject ref) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.loadCall = this.makeBatchCall(pixelsID, ref, 0);
    }

    public RenderingSettingsSaver(TimeRefObject ref, int index) {
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.loadCall = this.makeBatchCall(-1L, ref, index);
    }

    public RenderingSettingsSaver(long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.loadCall = this.makeCreateBatchCall(pixelsID, rndToCopy, indexes);
    }
}

