/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.init.AgentsInit;
import org.openmicroscopy.shoola.env.init.CacheInit;
import org.openmicroscopy.shoola.env.init.CmdProcessorInit;
import org.openmicroscopy.shoola.env.init.ContainerConfigInit;
import org.openmicroscopy.shoola.env.init.DataServicesInit;
import org.openmicroscopy.shoola.env.init.EventBusInit;
import org.openmicroscopy.shoola.env.init.InitializationListener;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.LoggerInit;
import org.openmicroscopy.shoola.env.init.LoginServiceInit;
import org.openmicroscopy.shoola.env.init.RenderingServicesInit;
import org.openmicroscopy.shoola.env.init.SplashScreenInit;
import org.openmicroscopy.shoola.env.init.StartupException;
import org.openmicroscopy.shoola.env.init.TaskBarInit;
import org.openmicroscopy.shoola.env.init.UserNotifierInit;

public class Initializer {
    protected static final List<Class> initList = new ArrayList<Class>();
    private List<InitializationTask> processingQueue;
    private InitializationTask currentTask;
    private Stack<InitializationTask> doneTasks;
    private Set<InitializationListener> initListeners;
    private Container container;

    private static InitializationTask createInitTask(Object taskType, Container c, Initializer i) throws StartupException {
        if (taskType == null) {
            throw new NullPointerException("No task type.");
        }
        if (c == null) {
            throw new NullPointerException("No container.");
        }
        if (i == null) {
            throw new NullPointerException("No initializer.");
        }
        InitializationTask task = null;
        try {
            Class taskClass = (Class)taskType;
            task = (InitializationTask)taskClass.newInstance();
            task.linkContainer(c);
            task.linkInitializer(i);
        }
        catch (InstantiationException ie) {
            throw new StartupException("Couldn't instantiate initialization task.", ie);
        }
        catch (IllegalAccessException iae) {
            throw new StartupException("Couldn't instantiate initialization task.", iae);
        }
        catch (ClassCastException cce) {
            throw new StartupException("Invalid initialization task: " + taskType + " doesn't extends InitializationTask.");
        }
        return task;
    }

    private void notifyStart() {
        int size = this.processingQueue.size() - 2;
        Iterator<InitializationListener> i = this.initListeners.iterator();
        while (i.hasNext()) {
            i.next().onStart(size);
        }
    }

    private void notifyExecute() {
        String name = this.currentTask.getName();
        Iterator<InitializationListener> i = this.initListeners.iterator();
        while (i.hasNext()) {
            i.next().onExecute(name);
        }
    }

    private void notifyEnd() {
        Iterator<InitializationListener> i = this.initListeners.iterator();
        while (i.hasNext()) {
            i.next().onEnd();
        }
    }

    protected Initializer() {
    }

    public Initializer(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.processingQueue = new ArrayList<InitializationTask>();
        this.doneTasks = new Stack();
        this.initListeners = new HashSet<InitializationListener>();
        this.container = c;
    }

    public void configure() throws StartupException {
        Iterator<Class> type = initList.iterator();
        while (type.hasNext()) {
            InitializationTask task = Initializer.createInitTask(type.next(), this.container, this);
            task.configure();
            this.processingQueue.add(task);
        }
    }

    public void doInit() throws StartupException {
        Iterator<InitializationTask> i = this.processingQueue.iterator();
        this.notifyStart();
        while (i.hasNext()) {
            this.currentTask = i.next();
            this.notifyExecute();
            this.currentTask.execute();
            this.doneTasks.push(this.currentTask);
        }
        this.notifyEnd();
        this.currentTask = null;
        this.processingQueue = null;
        this.initListeners = null;
        this.container.startService();
    }

    public void rollback() {
        Iterator i = this.doneTasks.iterator();
        while (i.hasNext()) {
            ((InitializationTask)i.next()).rollback();
        }
    }

    public boolean register(InitializationListener subscriber) {
        if (subscriber == null) {
            throw new NullPointerException();
        }
        return this.initListeners.add(subscriber);
    }

    static {
        initList.add(ContainerConfigInit.class);
        initList.add(SplashScreenInit.class);
        initList.add(LoggerInit.class);
        initList.add(CacheInit.class);
        initList.add(EventBusInit.class);
        initList.add(CmdProcessorInit.class);
        initList.add(DataServicesInit.class);
        initList.add(RenderingServicesInit.class);
        initList.add(LoginServiceInit.class);
        initList.add(TaskBarInit.class);
        initList.add(UserNotifierInit.class);
        initList.add(AgentsInit.class);
    }
}

